/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.io.Serializable;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Function;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.Predicates;
import orbital.math.Arithmetic;
import orbital.math.Matrix;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractMatrix;
import orbital.util.Setops;

public final class LUDecomposition
implements Serializable {
    private static final long serialVersionUID = 4112378842817846198L;
    private Matrix A;
    private Matrix P;
    private boolean sign;

    protected LUDecomposition(Matrix A, Matrix P, boolean sign) {
        this.A = A;
        this.P = P;
        this.sign = sign;
    }

    private LUDecomposition(Matrix M) {
        if (!M.isSquare()) {
            throw new IllegalArgumentException("only square matrices can be LU-decomposed");
        }
        AbstractMatrix A = (AbstractMatrix)M.clone();
        AbstractMatrix P = (AbstractMatrix)Values.getDefaultInstance().IDENTITY(A.dimension());
        this.sign = true;
        int k = 0;
        while (k < A.dimension().width - 1) {
            block10: {
                Arithmetic apinv;
                int pivot = k;
                int i = k + 1;
                while (i < A.dimension().height) {
                    if (A.get(i, k).norm().compareTo(A.get(pivot, k).norm()) > 0) {
                        pivot = i;
                    }
                    ++i;
                }
                if (pivot != k) {
                    A.swapRows(k, pivot);
                    P.swapRows(k, pivot);
                    this.sign = !this.sign;
                }
                try {
                    apinv = A.get(k, k).inverse();
                }
                catch (ArithmeticException x) {
                    break block10;
                }
                i = k + 1;
                while (i < A.dimension().height) {
                    A.set(i, k, A.get(i, k).multiply(apinv));
                    ++i;
                }
                int i2 = k + 1;
                while (i2 < A.dimension().height) {
                    int j = k + 1;
                    while (j < A.dimension().width) {
                        A.set(i2, j, A.get(i2, j).subtract(A.get(i2, k).multiply(A.get(k, j))));
                        ++j;
                    }
                    ++i2;
                }
            }
            ++k;
        }
        this.A = A;
        this.P = P;
    }

    public static LUDecomposition decompose(Matrix M) {
        return new LUDecomposition(M);
    }

    public boolean isInvertible() throws ArithmeticException {
        int i = 0;
        while (i < this.A.dimension().height) {
            if (this.A.get(i, i).norm().equals(Values.ZERO)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isRegular() throws ArithmeticException {
        return this.isInvertible();
    }

    public int linearRank() {
        return Setops.count(this.A.getDiagonal().iterator(), (Predicate)Functionals.compose(Functionals.bindSecond(Predicates.unequal, (Object)Values.ZERO), (Function)Functions.norm));
    }

    public Arithmetic det() {
        Arithmetic detU = (Arithmetic)Functionals.foldRight((BinaryFunction)Operations.times, (Object)Values.ONE, this.A.getDiagonal().iterator());
        return this.sign ? detU : detU.minus();
    }

    public Matrix getL() {
        Matrix L = Values.getDefaultInstance().IDENTITY(this.A.dimension());
        int i = 0;
        while (i < this.A.dimension().height) {
            int j = 0;
            while (j < i) {
                L.set(i, j, this.A.get(i, j));
                ++j;
            }
            ++i;
        }
        return L;
    }

    public Matrix getU() {
        Matrix U = Values.getDefaultInstance().ZERO(this.A.dimension());
        int i = 0;
        while (i < this.A.dimension().height) {
            int j = i;
            while (j < this.A.dimension().width) {
                U.set(i, j, this.A.get(i, j));
                ++j;
            }
            ++i;
        }
        return U;
    }

    public Matrix getP() {
        return Values.getDefaultInstance().constant(this.P);
    }

    public Vector solve(Vector b) {
        Vector c = this.P.multiply(b);
        Vector z = Values.getDefaultInstance().newInstance(this.A.dimension().width);
        int i = 0;
        while (i < this.A.dimension().height) {
            Arithmetic t = c.get(i);
            int j = 0;
            while (j < i) {
                t = t.subtract(this.A.get(i, j).multiply(z.get(j)));
                ++j;
            }
            z.set(i, t);
            ++i;
        }
        Vector x = Values.getDefaultInstance().newInstance(this.A.dimension().width);
        int i2 = this.A.dimension().height - 1;
        while (i2 >= 0) {
            Arithmetic t = c.get(i2);
            int j = i2 + 1;
            while (j < this.A.dimension().width) {
                t = t.subtract(this.A.get(i2, j).multiply(x.get(j)));
                ++j;
            }
            x.set(i2, t.divide(this.A.get(i2, i2)));
            --i2;
        }
        return x;
    }
}

