/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Function;
import orbital.math.Arithmetic;
import orbital.math.Matrix;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.Operations;

public final class Evaluations {
    private Evaluations() {
    }

    public static Arithmetic sum(Vector v) {
        return (Arithmetic)Operations.sum.apply(v);
    }

    public static double sum(double[] v) {
        return Functionals.foldRight((BinaryFunction)Operations.plus, 0.0, v);
    }

    public static Arithmetic average(Vector v) {
        return Evaluations.sum(v).divide(Values.getDefaultInstance().valueOf(v.dimension()));
    }

    public static double average(double[] v) {
        return Evaluations.sum(v) / (double)v.length;
    }

    public static Arithmetic min(Vector v) {
        return (Arithmetic)Operations.inf.apply(v);
    }

    public static double min(double[] v) {
        return Functionals.foldRight((BinaryFunction)Operations.min, v[0], v);
    }

    public static int min(int[] vals) {
        int min = vals[0];
        int i = 1;
        while (i < vals.length) {
            if (vals[i] < min) {
                min = vals[i];
            }
            ++i;
        }
        return min;
    }

    public static Arithmetic max(Vector v) {
        return (Arithmetic)Operations.sup.apply(v);
    }

    public static double max(double[] v) {
        return Functionals.foldRight((BinaryFunction)Operations.max, v[0], v);
    }

    public static int max(int[] vals) {
        int max = vals[0];
        int i = 1;
        while (i < vals.length) {
            if (max < vals[i]) {
                max = vals[i];
            }
            ++i;
        }
        return max;
    }

    public static Vector abs(Vector v) {
        return Functionals.map(Functions.norm, v);
    }

    public static double[] abs(double[] v) {
        return Functionals.map((Function)Functions.norm, v);
    }

    public static Arithmetic sum(Matrix M) {
        return (Arithmetic)Operations.sum.apply(M);
    }

    public static Arithmetic average(Matrix M) {
        return Evaluations.sum(M).divide(Values.getDefaultInstance().valueOf(M.dimension().width * M.dimension().height));
    }

    public static Arithmetic min(Matrix M) {
        return (Arithmetic)Operations.inf.apply(M);
    }

    public static Arithmetic max(Matrix M) {
        return (Arithmetic)Operations.sup.apply(M);
    }
}

