/*
 * Decompiled with CFR 0.152.
 */
package orbital.math;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import orbital.algorithm.Combinatorical;
import orbital.logic.functor.Functionals;
import orbital.logic.functor.Predicates;
import orbital.math.AlgebraicAlgorithms;
import orbital.math.Arithmetic;
import orbital.math.Complex;
import orbital.math.ExpectationHurtParseException;
import orbital.math.Fraction;
import orbital.math.Integer;
import orbital.math.MathUtilities;
import orbital.math.Matrix;
import orbital.math.Polynomial;
import orbital.math.Quotient;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Symbol;
import orbital.math.Tensor;
import orbital.math.UnivariatePolynomial;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.MathFunctor;
import orbital.util.Setops;
import orbital.util.logging.Level;
import orbital.util.logging.Logger;

public class ArithmeticFormat
extends Format {
    private static final Logger logger = Logger.getLogger((class$orbital$math$ArithmeticFormat == null ? (class$orbital$math$ArithmeticFormat = ArithmeticFormat.class$("orbital.math.ArithmeticFormat")) : class$orbital$math$ArithmeticFormat).getPackage().getName());
    private static final long serialVersionUID = 4708045695735837065L;
    public static final int NUMERATOR_FIELD = 2;
    public static final int DENOMINATOR_FIELD = 3;
    public static final int REAL_FIELD = 4;
    public static final int IMAGINARY_FIELD = 5;
    public static final int SYMBOL_FIELD = 10;
    private NumberFormat numberFormat;
    private String rationalSeparator = "/";
    private String complexPositiveSeparator = "+";
    private String complexNegativeSeparator = "-";
    private boolean complexUnitLast = false;
    private String complexUnit = "i";
    private String complexUnitSeparator = "*";
    private boolean complexAbbreviateNullReal = true;
    private boolean complexAbbreviateNullImaginary = true;
    private boolean complexAbbreviateOne = true;
    private boolean complexAbbreviateNullRealPositiveSeparator = true;
    private String vectorPrefix = "(";
    private String vectorSeparator = ",";
    private String[] vectorSeparatorAlternatives = new String[]{"\t", "|"};
    private String vectorSuffix = ")";
    private String matrixPrefix = "";
    private String matrixSeparator = ",\t";
    private String[] matrixSeparatorAlternatives = new String[]{",", "\t"};
    private String matrixSuffix = "";
    private String matrixRowPrefix = "[";
    private String matrixRowSeparator = System.getProperty("line.separator");
    private String[] matrixRowSeparatorAlternatives = new String[]{"\n", "\r\n", ";", " ", "\t", ""};
    private String matrixRowSuffix = "]";
    private String polynomialPrefix = "";
    private String polynomialTimesOperator = "";
    private String polynomialVariable = "X";
    private String polynomialPowerOperator = "^";
    private String polynomialPlusOperator = "+";
    private String polynomialPlusAlternative = "-";
    private String polynomialSuffix = "";
    private String multinomialPrefix = "";
    private String multinomialTimesOperator = "*";
    private String multinomialVariableTimesOperator = "*";
    private String[] multinomialVariables = new String[]{"X", "Y", "Z"};
    private String multinomialPowerOperator = "^";
    private String multinomialPlusOperator = "+";
    private String multinomialPlusAlternative = "-";
    private String multinomialSuffix = "";
    private static final ArithmeticFormat defaultFormat = ArithmeticFormat.getInstance(Locale.ENGLISH);
    static /* synthetic */ Class class$orbital$math$ArithmeticFormat;

    public ArithmeticFormat(Locale locale) {
        this.numberFormat = NumberFormat.getNumberInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMaximumFractionDigits(MathUtilities.getDefaultPrecisionDigits());
    }

    public static ArithmeticFormat getInstance(Locale locale) {
        return new ArithmeticFormat(locale);
    }

    public static ArithmeticFormat getInstance() {
        return new ArithmeticFormat(Locale.getDefault());
    }

    public static final ArithmeticFormat getDefaultInstance() {
        return defaultFormat;
    }

    public String getPolynomialVariable() {
        return this.polynomialVariable;
    }

    public void setPolynomialVariable(String polynomialVariable) {
        this.polynomialVariable = polynomialVariable;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    protected void setNumberFormat(NumberFormat newNumberFormat) {
        this.numberFormat = newNumberFormat;
    }

    public String format(Arithmetic obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Scalar obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Tensor obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Vector obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Matrix obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Complex obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Real obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Rational obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Integer obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Polynomial obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(UnivariatePolynomial obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Quotient obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Fraction obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(Symbol obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String format(MathFunctor obj) {
        return this.format(obj, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public StringBuffer format(Object obj, StringBuffer result, FieldPosition fieldPosition) {
        if (obj == null) {
            return new StringBuffer("null");
        }
        if (obj instanceof Arithmetic) {
            return this.format((Arithmetic)obj, result, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as an arithmetic object: " + obj.getClass());
    }

    public StringBuffer format(Arithmetic obj, StringBuffer result, FieldPosition fieldPosition) {
        if (obj == null) {
            return new StringBuffer("null");
        }
        if (obj instanceof Scalar) {
            return this.format((Scalar)obj, result, fieldPosition);
        }
        if (obj instanceof Tensor) {
            return this.format((Tensor)obj, result, fieldPosition);
        }
        if (obj instanceof Polynomial) {
            return this.format((Polynomial)obj, result, fieldPosition);
        }
        if (obj instanceof Symbol) {
            return this.format((Symbol)obj, result, fieldPosition);
        }
        if (obj instanceof Fraction) {
            return this.format((Fraction)obj, result, fieldPosition);
        }
        if (obj instanceof Quotient) {
            return this.format((Quotient)obj, result, fieldPosition);
        }
        if (obj instanceof MathFunctor) {
            return this.format((MathFunctor)obj, result, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as an arithmetic object: " + obj.getClass());
    }

    public StringBuffer format(Scalar obj, StringBuffer result, FieldPosition fieldPosition) {
        if (Complex.hasType.apply(obj)) {
            return this.format((Complex)obj, result, fieldPosition);
        }
        if (Real.hasType.apply(obj)) {
            return this.format((Real)obj, result, fieldPosition);
        }
        if (Rational.hasType.apply(obj)) {
            return this.format((Rational)obj, result, fieldPosition);
        }
        if (Integer.hasType.apply(obj)) {
            return this.format((Integer)obj, result, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as an arithmetic object");
    }

    public StringBuffer format(Tensor obj, StringBuffer result, FieldPosition fieldPosition) {
        if (obj == null) {
            return new StringBuffer("null");
        }
        if (obj instanceof Vector) {
            return this.format((Vector)obj, result, fieldPosition);
        }
        if (obj instanceof Matrix) {
            return this.format((Matrix)obj, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        obj = AlgebraicAlgorithms.flatten(obj);
        int[] permutation = new int[obj.rank()];
        int c = 0;
        int k = 0;
        while (k < permutation.length) {
            permutation[k] = c++;
            k += 2;
        }
        int k2 = 1;
        while (k2 < permutation.length) {
            permutation[k2] = c++;
            k2 += 2;
        }
        obj = obj.subTensorTransposed(permutation);
        result.append(this.matrixPrefix);
        int[] lasti = null;
        Combinatorical index = Combinatorical.getPermutations((int[])obj.dimensions());
        while (index.hasNext()) {
            int[] i = index.next();
            if (lasti == null) {
                result.append(this.matrixRowPrefix);
                result.append("{");
            } else {
                int numberOfCompleted = 0;
                int k3 = i.length - 1;
                while (k3 >= 0) {
                    if (i[k3] == 0 && lasti[k3] != false) {
                        ++numberOfCompleted;
                    }
                    --k3;
                }
                if (numberOfCompleted > 0) {
                    result.append("}");
                }
                int colAndRowsFinished = 2;
                while (colAndRowsFinished < numberOfCompleted) {
                    result.append("]\n[\t");
                    ++colAndRowsFinished;
                }
                if (numberOfCompleted >= (int)Math.floor((double)i.length / 2.0)) {
                    result.append(this.matrixRowSuffix);
                    result.append(this.matrixRowSeparator);
                    result.append(this.matrixRowPrefix);
                } else {
                    result.append(this.matrixSeparator);
                }
                if (numberOfCompleted > 0) {
                    result.append("{");
                }
            }
            this.format(obj.get(i), result, fieldPosition);
            lasti = (int[])i.clone();
        }
        result.append("}");
        result.append(this.matrixRowSuffix);
        result.append(this.matrixSuffix);
        return result;
    }

    public StringBuffer format(Vector v, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        result.append(this.vectorPrefix);
        ListIterator i = v.iterator();
        while (i.hasNext()) {
            this.format(i.next(), result, fieldPosition);
            if (!i.hasNext()) continue;
            result.append(this.vectorSeparator);
        }
        result.append(this.vectorSuffix);
        return result;
    }

    public StringBuffer format(Matrix v, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        result.append(this.matrixPrefix);
        int i = 0;
        while (i < v.dimension().height) {
            if (i != 0) {
                result.append(this.matrixRowSeparator);
            }
            result.append(this.matrixRowPrefix);
            int j = 0;
            while (j < v.dimension().width) {
                if (j != 0) {
                    result.append(this.matrixSeparator);
                }
                this.format(v.get(i, j), result, fieldPosition);
                ++j;
            }
            result.append(this.matrixRowSuffix);
            ++i;
        }
        result.append(this.matrixSuffix);
        return result;
    }

    public StringBuffer format(Complex v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Complex.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (fieldPosition.getField() == 4) {
            fieldPosition.setBeginIndex(result.length());
        }
        Real re = v.re();
        Real im = v.im();
        if (!re.equals(Values.ZERO) || this.complexAbbreviateNullReal && im.equals(Values.ZERO)) {
            this.format(re, result, fieldPosition);
        }
        if (fieldPosition.getField() == 4) {
            fieldPosition.setEndIndex(result.length());
        } else if (fieldPosition.getField() == 5) {
            fieldPosition.setBeginIndex(result.length());
        }
        if (!this.complexAbbreviateNullImaginary || !im.equals(Values.ZERO)) {
            boolean negative;
            boolean bl = negative = im.compareTo(Values.ZERO) < 0;
            if (negative) {
                im = (Real)im.minus();
                result.append(this.complexNegativeSeparator);
            } else if (!this.complexAbbreviateNullRealPositiveSeparator || !re.equals(Values.ZERO)) {
                result.append(this.complexPositiveSeparator);
            }
            if (!this.complexUnitLast) {
                result.append(this.complexUnit);
            }
            if (!this.complexAbbreviateOne || !im.norm().equals(Values.ONE)) {
                if (!this.complexUnitLast) {
                    result.append(this.complexUnitSeparator);
                }
                this.format(im, result, fieldPosition);
                if (this.complexUnitLast) {
                    result.append(this.complexUnitSeparator);
                }
            }
            if (this.complexUnitLast) {
                result.append(this.complexUnit);
            }
        }
        if (fieldPosition.getField() == 5) {
            fieldPosition.setEndIndex(result.length());
        }
        return result;
    }

    public StringBuffer format(Real v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Real.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        return this.numberFormat.format(v.doubleValue(), result, fieldPosition);
    }

    public StringBuffer format(Rational v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Rational.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (fieldPosition.getField() == 2 || fieldPosition.getField() == 4) {
            fieldPosition.setBeginIndex(result.length());
        }
        this.numberFormat.format(v.numerator(), result, fieldPosition);
        if (fieldPosition.getField() == 2) {
            fieldPosition.setEndIndex(result.length());
        } else if (fieldPosition.getField() == 3) {
            fieldPosition.setBeginIndex(result.length());
        }
        if (logger.isLoggable(Level.FINER) || !v.denominator().equals(Values.ONE)) {
            result.append(this.rationalSeparator);
            this.numberFormat.format(v.denominator(), result, fieldPosition);
        }
        if (fieldPosition.getField() == 3 || fieldPosition.getField() == 4) {
            fieldPosition.setEndIndex(result.length());
        }
        return result;
    }

    public StringBuffer format(Integer v, StringBuffer result, FieldPosition fieldPosition) {
        if (!Integer.hasType.apply(v)) {
            return this.format((Scalar)v, result, fieldPosition);
        }
        return this.numberFormat.format(v.longValue(), result, fieldPosition);
    }

    public StringBuffer format(Polynomial p, StringBuffer result, FieldPosition fieldPosition) {
        if (p instanceof UnivariatePolynomial) {
            return this.format((UnivariatePolynomial)p, result, fieldPosition);
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        int initialIndex = result.length();
        boolean addIndex = ((Integer)p.indexSet()).intValue() > this.multinomialVariables.length;
        result.append(this.multinomialPrefix);
        Iterator index = p.indices();
        while (index.hasNext()) {
            boolean skipped;
            Vector i = (Vector)index.next();
            Arithmetic ci = p.get(i);
            boolean constantTerm = Setops.all(i.iterator(), Functionals.bindSecond(Predicates.equal, (Object)Values.ZERO));
            if (ci.norm().equals(Values.ZERO) && (!constantTerm || p.degreeValue() > 0)) continue;
            int startIndex = result.length();
            if (ci.equals(ci.one()) && !constantTerm) {
                skipped = true;
            } else if (ci.equals(ci.one().minus()) && !constantTerm) {
                result.append(this.multinomialPlusAlternative);
                skipped = true;
            } else {
                result.append(ci);
                skipped = false;
            }
            if (!(startIndex <= initialIndex || result.length() > startIndex && result.substring(startIndex).startsWith(this.multinomialPlusAlternative))) {
                result.insert(startIndex, this.multinomialPlusOperator);
            }
            boolean firstVariableAfterCoefficient = true;
            int countk = 0;
            ListIterator k = i.iterator();
            while (k.hasNext()) {
                Integer exponent = (Integer)k.next();
                if (!exponent.equals(Values.ZERO)) {
                    if (firstVariableAfterCoefficient) {
                        if (!skipped) {
                            result.append(this.multinomialTimesOperator);
                        }
                    } else {
                        result.append(this.multinomialVariableTimesOperator);
                    }
                    result.append(addIndex ? this.multinomialVariables[0] + countk : this.multinomialVariables[countk]);
                    if (exponent.compareTo(Values.ONE) > 0) {
                        result.append(this.multinomialPowerOperator + exponent);
                    }
                    firstVariableAfterCoefficient = false;
                }
                ++countk;
            }
        }
        result.append(this.multinomialSuffix);
        return result;
    }

    public StringBuffer format(UnivariatePolynomial p, StringBuffer result, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        int initialIndex = result.length();
        result.append(this.polynomialPrefix);
        int i = Math.max(p.degreeValue(), 0);
        while (i >= 0) {
            Arithmetic ci = p.get(i);
            if (!ci.norm().equals(Values.ZERO) || i == 0 && result.length() == initialIndex) {
                boolean skipped;
                int startIndex = result.length();
                if (ci.equals(ci.one()) && i != 0) {
                    skipped = true;
                } else if (ci.equals(ci.one().minus()) && i != 0) {
                    result.append(this.polynomialPlusAlternative);
                    skipped = true;
                } else {
                    this.format(ci, result, fieldPosition);
                    skipped = false;
                }
                if (!(i >= p.degreeValue() || result.length() > startIndex && result.substring(startIndex).startsWith(this.polynomialPlusAlternative))) {
                    result.insert(startIndex, this.polynomialPlusOperator);
                }
                if (i != 0) {
                    if (!skipped) {
                        result.append(this.polynomialTimesOperator);
                    }
                    result.append(this.polynomialVariable);
                    if (i > 1) {
                        result.append(this.polynomialPowerOperator + i);
                    }
                }
            }
            --i;
        }
        result.append(this.polynomialSuffix);
        return result;
    }

    public StringBuffer format(Quotient q, StringBuffer result, FieldPosition fieldPosition) {
        result.append(q.representative().toString());
        return result;
    }

    public StringBuffer format(Fraction as, StringBuffer result, FieldPosition fieldPosition) {
        result.append("(" + as.numerator() + ") / (" + as.denominator() + ")");
        return result;
    }

    public StringBuffer format(Symbol s, StringBuffer result, FieldPosition fieldPosition) {
        if (fieldPosition.getField() == 10) {
            fieldPosition.setBeginIndex(result.length());
        }
        result.append(s.getSignifier());
        if (fieldPosition.getField() == 10) {
            fieldPosition.setEndIndex(result.length());
        }
        return result;
    }

    public StringBuffer format(MathFunctor f, StringBuffer result, FieldPosition fieldPosition) {
        return result.append("" + f);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Arithmetic parse(String source, ParsePosition status) {
        initialIndex = status.getIndex();
        vf = Values.getDefaultInstance();
        try {
            while (true) {
                block39: {
                    block38: {
                        if (!source.startsWith(this.matrixPrefix, status.getIndex()) || !source.startsWith(this.matrixRowPrefix, status.getIndex() + this.matrixPrefix.length())) break block38;
                        status.setIndex(status.getIndex() + this.matrixPrefix.length());
                        colWidth = 0;
                        rows = new LinkedList<LinkedList<E>>();
                        col = new LinkedList<void>();
                        ** GOTO lbl23
                        {
                            col.add(var8_17);
                            if (!this.found(this.matrixSeparator, source, status) && !this.found(this.matrixSeparatorAlternatives, source, status)) ** GOTO lbl16
                            do {
                                if ((el = this.parse(source, status)) != null) continue block7;
lbl16:
                                // 2 sources

                                this.consume(this.matrixRowSuffix, source, status);
                                rows.add(col);
                                if (col.size() > colWidth) {
                                    colWidth = col.size();
                                }
                                col = new ArrayList<E>(colWidth);
                                if (!this.found(this.matrixRowSeparator, source, status) && !this.found(this.matrixRowSeparatorAlternatives, source, status)) break block7;
lbl23:
                                // 2 sources

                            } while (this.found(this.matrixRowPrefix, source, status));
                        }
                        this.consume(this.matrixSuffix, source, status);
                        v = vf.newInstance(rows.size(), colWidth);
                        i = 0;
                        while (i < v.dimension().height) {
                            col = (List)rows.get(i);
                            j = 0;
                            while (j < v.dimension().width) {
                                v.set(i, j, j < col.size() ? (Arithmetic)col.get(j) : Values.ZERO);
                                ++j;
                            }
                            ++i;
                        }
                        return v;
                    }
                    if (this.found(this.vectorPrefix, source, status)) {
                        components = new LinkedList<void>();
                        while ((el = this.parse(source, status)) != null) {
                            components.add((void)rows);
                            if (!this.found(this.vectorSeparator, source, status) && !this.found(this.vectorSeparatorAlternatives, source, status)) break;
                        }
                        this.consume(this.vectorSuffix, source, status);
                        v = vf.newInstance(components.size());
                        i = 0;
                        while (i < v.dimension()) {
                            v.set(i, (Arithmetic)components.get(i));
                            ++i;
                        }
                        return v;
                    }
                    if (source.indexOf(this.complexUnit, status.getIndex()) < 0) break block39;
                    fallbackIndex = status.getIndex();
                    try {
                        re = null;
                        im /* !! */  = null;
                        imaginaryPart = false;
                        sign = 1;
                        val = null;
                        while ((re == null || im /* !! */  == null) && status.getIndex() < source.length()) {
                            block42: {
                                block40: {
                                    block41: {
                                        allowUnitNumberSuffix = false;
                                        if (val == null) {
                                            val = ArithmeticFormat.realValueOf(this.numberFormat.parse(source, status));
                                        }
                                        if (imaginaryPart) break block40;
                                        if (val != null && this.found(this.complexUnitSeparator, source, status) && this.found(this.complexUnit, source, status)) break block41;
                                        allowUnitNumberSuffix = this.found(this.complexUnitSeparator, source, status);
                                        if (!(this.found(this.complexUnit, source, status) | allowUnitNumberSuffix)) break block40;
                                    }
                                    if (im /* !! */  != null) {
                                        throw new NumberFormatException("no two imaginary parts");
                                    }
                                    imaginaryPart = true;
                                }
                                if (allowUnitNumberSuffix && val == null) {
                                    val = ArithmeticFormat.realValueOf(this.numberFormat.parse(source, status));
                                }
                                if (val == null) break block42;
                                val = vf.valueOf((double)sign * val.doubleValue());
                                if (!imaginaryPart) ** GOTO lbl83
                                if (im /* !! */  == null) {
                                    im /* !! */  = val;
                                } else {
                                    throw new NumberFormatException("no two imaginary parts");
lbl83:
                                    // 1 sources

                                    if (re == null) {
                                        re = val;
                                    } else {
                                        throw new NumberFormatException("no two real parts");
                                    }
                                }
                                val = null;
                                imaginaryPart = false;
                                sign = 1;
                                continue;
                            }
                            if (this.found("+", source, status)) {
                                if (im /* !! */  == null && imaginaryPart) {
                                    im /* !! */  = vf.valueOf(sign * 1);
                                }
                                sign = 1;
                                imaginaryPart = false;
                                continue;
                            }
                            if (this.found("-", source, status)) {
                                if (im /* !! */  == null && imaginaryPart) {
                                    im /* !! */  = vf.valueOf(sign * 1);
                                }
                                sign = -1;
                                imaginaryPart = false;
                                continue;
                            }
                            if (status.getIndex() < source.length()) break;
                        }
                        if (im /* !! */  == null && imaginaryPart) {
                            im /* !! */  = vf.valueOf(sign * 1);
                        }
                        if (im /* !! */  == null) {
                            throw new NumberFormatException("real value does not need to be parsed as a complex");
                        }
                        if (re == null) {
                            return vf.complex(Values.ZERO, im /* !! */ );
                        }
                        return vf.complex(re, im /* !! */ );
                    }
                    catch (NumberFormatException trial) {
                        status.setIndex(fallbackIndex);
                    }
                }
                if (source.indexOf(this.rationalSeparator, status.getIndex()) >= 0) {
                    fallbackIndex = status.getIndex();
                    try {
                        f = (NumberFormat)this.numberFormat.clone();
                        f.setParseIntegerOnly(true);
                        numerator = (Integer)vf.valueOf(f.parse(source, status));
                        if (numerator == null) {
                            throw new NumberFormatException("numerator expected");
                        }
                        if (!this.found(this.rationalSeparator, source, status)) {
                            throw new NumberFormatException("'" + this.rationalSeparator + "' expected");
                        }
                        denominator = (Integer)vf.valueOf(f.parse(source, status));
                        if (denominator == null) {
                            throw new NumberFormatException("denominator expected");
                        }
                        return vf.rational(numerator, denominator);
                    }
                    catch (NumberFormatException trial) {
                        status.setIndex(fallbackIndex);
                    }
                }
                if ((n = this.numberFormat.parse(source, status)) != null) {
                    return vf.narrow(vf.valueOf(n));
                }
                if (!Character.isWhitespace(source.charAt(status.getIndex()))) break;
                status.setIndex(status.getIndex() + 1);
            }
            return null;
        }
        catch (ExpectationHurtParseException invalid) {
            status.setIndex(initialIndex);
            return null;
        }
    }

    public Object parseObject(String source, ParsePosition status) {
        return this.parse(source, status);
    }

    public Arithmetic parse(String source) throws ParseException {
        ParsePosition status = new ParsePosition(0);
        Arithmetic result = this.parse(source, status);
        if (status.getIndex() == 0) {
            throw new ParseException("ArithmeticFormat.parse(String) failed at " + status + " '" + source.charAt(status.getErrorIndex()) + "'", status.getErrorIndex());
        }
        return result;
    }

    private final void consume(String expectedValue, String source, ParsePosition status) throws ExpectationHurtParseException {
        if (!this.found(expectedValue, source, status)) {
            status.setErrorIndex(status.getIndex());
            throw new ExpectationHurtParseException("'" + expectedValue + "' expected", status.getErrorIndex());
        }
    }

    private final boolean found(String value, String source, ParsePosition status) {
        if (source.startsWith(value, status.getIndex())) {
            status.setIndex(status.getIndex() + value.length());
            return true;
        }
        return false;
    }

    private final boolean found(String[] values, String source, ParsePosition status) {
        int i = 0;
        while (i < values.length) {
            if (this.found(values[i], source, status)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final Real realValueOf(Number number) {
        return number == null ? null : Values.getDefaultInstance().valueOf(number.doubleValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

