/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.trs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import orbital.logic.Composite;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Function;
import orbital.logic.functor.Functionals;
import orbital.logic.functor.Predicate;
import orbital.logic.sign.type.Type;
import orbital.logic.sign.type.TypeException;
import orbital.logic.sign.type.Typed;
import orbital.logic.trs.Substitution;
import orbital.logic.trs.Variable;
import orbital.math.functional.Functions;
import orbital.moon.logic.bridge.SubstitutionImpl;
import orbital.util.Setops;
import orbital.util.Utility;

public class Substitutions {
    public static final Substitution id = new Substitution(){

        public Collection getReplacements() {
            return Collections.EMPTY_SET;
        }

        public Object apply(Object a) {
            return a;
        }
    };
    public static final BinaryFunction lambda = new BinaryFunction(){

        public Object apply(Object x, Object f) {
            if (!(x instanceof Variable) || !((Variable)x).isVariable()) {
                throw new IllegalArgumentException("usually x should be a " + (class$orbital$logic$trs$Variable == null ? (class$orbital$logic$trs$Variable = Substitutions.class$("orbital.logic.trs.Variable")) : class$orbital$logic$trs$Variable).getName() + " with x.isVariable()==true, however this is not a strict requirement");
            }
            Substitution sigma = Substitutions.getInstance(Arrays.asList(Substitutions.createExactMatcher(Functions.constant(x), Functions.id), Substitutions.createExactMatcher(x, Functions.id)));
            return sigma.apply(f);
        }
    };
    static /* synthetic */ Class class$orbital$moon$logic$bridge$SubstitutionImpl$MatcherImpl;
    static /* synthetic */ Class class$orbital$logic$trs$Variable;

    private Substitutions() {
    }

    public static final Substitution getInstance(Collection replacements) {
        return Substitutions.getInstance(replacements, true);
    }

    public static final Substitution getInstance(Collection replacements, boolean typeSafe) {
        if (typeSafe) {
            Iterator i = replacements.iterator();
            while (i.hasNext()) {
                Substitution.Matcher m = (Substitution.Matcher)i.next();
                if (!(m instanceof SubstitutionImpl.MatcherImpl)) continue;
                Object p = m.pattern();
                Object s = ((SubstitutionImpl.MatcherImpl)m).substitute();
                if (!(p instanceof Typed) || !(s instanceof Typed)) continue;
                Type pType = ((Typed)p).getType();
                Type sType = ((Typed)s).getType();
                if (sType.subtypeOf(pType)) continue;
                throw new TypeException("substitution " + replacements + " with matcher " + m + " not type-safe", pType, sType);
            }
        }
        return new SubstitutionImpl(replacements);
    }

    private static final boolean validateDistinctPatterns(Collection replacements) {
        List r = replacements instanceof List ? (List)replacements : new LinkedList(replacements);
        ListIterator i = r.listIterator();
        while (i.hasNext()) {
            Object pattern = ((Substitution.Matcher)i.next()).pattern();
            ListIterator j = r.listIterator(i.nextIndex());
            while (j.hasNext()) {
                if (!pattern.equals(((Substitution.Matcher)j.next()).pattern())) continue;
                return false;
            }
        }
        return true;
    }

    public static final Substitution.Matcher createExactMatcher(Object pattern, Object substitute) {
        return new SubstitutionImpl.MatcherImpl(pattern, substitute);
    }

    public static final Substitution.Matcher createExactMatcher(Object pattern) {
        return new SubstitutionImpl.MatcherImpl(pattern);
    }

    public static final Substitution.Matcher createSingleSidedMatcher(Object pattern, Object substitute) {
        return new SubstitutionImpl.UnifyingMatcher(pattern, substitute);
    }

    public static final Substitution.Matcher createSingleSidedMatcher(Object pattern) {
        return new SubstitutionImpl.UnifyingMatcher(pattern);
    }

    public static final Substitution compose(Substitution sigma, Substitution tau) {
        Substitution.Matcher s;
        ArrayList<Substitution.Matcher> r = new ArrayList<Substitution.Matcher>(tau.getReplacements().size() + sigma.getReplacements().size());
        HashSet<Object> tauPatterns = new HashSet<Object>(tau.getReplacements().size() << 1);
        Iterator i = tau.getReplacements().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o.getClass() != (class$orbital$moon$logic$bridge$SubstitutionImpl$MatcherImpl == null ? Substitutions.class$("orbital.moon.logic.bridge.SubstitutionImpl$MatcherImpl") : class$orbital$moon$logic$bridge$SubstitutionImpl$MatcherImpl)) {
                throw new UnsupportedOperationException("currently, only exact matchers are supported");
            }
            s = (SubstitutionImpl.MatcherImpl)o;
            r.add(Substitutions.createExactMatcher(s.pattern(), sigma.apply(s.substitute())));
            tauPatterns.add(s.pattern());
        }
        Iterator i2 = sigma.getReplacements().iterator();
        while (i2.hasNext()) {
            s = (Substitution.Matcher)i2.next();
            if (tauPatterns.contains(s.pattern())) continue;
            r.add(s);
        }
        Substitution sigma_tau = Substitutions.getInstance(r);
        return sigma_tau;
    }

    public static final Function lambda(Object x, Object f) {
        return (Function)lambda.apply(x, f);
    }

    public static final Substitution unify(Collection T) {
        switch (T.size()) {
            case 0: 
            case 1: {
                return id;
            }
            case 2: {
                Object[] t = T.toArray();
                return Substitutions.unify(t[0], t[1]);
            }
        }
        throw new UnsupportedOperationException("unification currently does not support more than two terms. @todo");
    }

    static final Substitution unify(Object t1, Object t2) {
        Object t;
        if (t1 == null || t2 == null) {
            throw new NullPointerException("cannot unify (" + t1 + "," + t2 + ") because null does not unify anything.");
        }
        Object x = t1;
        if (Substitutions.isVariable(x) && Substitutions.other(t = t2) || Substitutions.isVariable(x = t2) && Substitutions.other(t = t1)) {
            if (x.equals(t)) {
                return id;
            }
            if (Substitutions.occur(x, t)) {
                return null;
            }
            if (x instanceof Typed && t instanceof Typed) {
                Type taux = ((Typed)x).getType();
                Type taut = ((Typed)t).getType();
                if (!taut.subtypeOf(taux)) {
                    if (Substitutions.isVariable(t)) {
                        Type both = taux.typeSystem().inf(new Type[]{taux, taut});
                        if (both == both.typeSystem().ABSURD()) {
                            return null;
                        }
                        throw new UnsupportedOperationException("modification cloning does not yet generally allow changing the type of a Typed object");
                    }
                    return null;
                }
            }
            return Substitutions.getInstance(Collections.singletonList(Substitutions.createExactMatcher(x, t)));
        }
        if (!(t1 instanceof Composite) || !(t2 instanceof Composite)) {
            if (t1.getClass() != t2.getClass() || !t1.equals(t2)) {
                return null;
            }
            return id;
        }
        Composite c1 = (Composite)t1;
        Object f = c1.getCompositor();
        Collection xs = Utility.asCollection(c1.getComponent());
        Composite c2 = (Composite)t2;
        Object g = c2.getCompositor();
        Collection ys = Utility.asCollection(c2.getComponent());
        if (c1.getClass() != c2.getClass() || !Utility.equals(f, g)) {
            return null;
        }
        Substitution s = id;
        Iterator xi = xs.iterator();
        Iterator yi = ys.iterator();
        while (xi.hasNext()) {
            Substitution s1 = Substitutions.unify(s.apply(xi.next()), s.apply(yi.next()));
            if (s1 == null) {
                return null;
            }
            s = Substitutions.compose(s1, s);
        }
        return s;
    }

    private static final boolean isVariable(Object x) {
        return x instanceof Variable && ((Variable)x).isVariable();
    }

    private static boolean occur(final Object x, Object t) {
        if (t instanceof Composite) {
            return Substitutions.occur(x, ((Composite)t).getComponent());
        }
        if (t.getClass().isArray()) {
            if (t instanceof Object[]) {
                return Setops.some(Arrays.asList((Object[])t), new Predicate(){

                    public boolean apply(Object ti) {
                        return Substitutions.occur(x, ti);
                    }
                });
            }
            throw new IllegalArgumentException("illegal argument type " + t.getClass() + " is not yet supported");
        }
        return false;
    }

    private static final boolean other(Object o) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ResultCheckingSubstition
    extends SubstitutionImpl {
        private final Function composed;

        private ResultCheckingSubstition(Substitution sigma, Substitution tau, Collection r) {
            super(r);
            this.composed = Functionals.compose((Function)sigma, (Function)tau);
        }

        public Object apply(Object o) {
            Object os = super.apply(o);
            Object oc = this.composed.apply(o);
            return os;
        }
    }
}

