/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.sign.type;

import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.util.PropertyPermission;
import orbital.logic.functor.Functor;
import orbital.logic.sign.Expression;
import orbital.logic.sign.Symbol;
import orbital.logic.sign.type.Type;
import orbital.logic.sign.type.TypeSystem;
import orbital.logic.sign.type.Typed;
import orbital.logic.trs.Variable;
import orbital.moon.logic.sign.type.StandardTypeSystem;
import orbital.util.logging.Level;
import orbital.util.logging.Logger;

public final class Types {
    private static TypeSystem defaultTypeSystem = new StandardTypeSystem();
    public static final Type INDIVIDUAL = Types.getDefault().objectType(class$java$lang$Object == null ? (class$java$lang$Object = Types.class$("java.lang.Object")) : class$java$lang$Object);
    public static final Type TRUTH = Types.getDefault().objectType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Types.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$orbital$logic$sign$type$Type;

    public static final TypeSystem getDefault() {
        return defaultTypeSystem;
    }

    public static final void setDefault(TypeSystem newTypeSystem) {
        if (newTypeSystem == null) {
            throw new NullPointerException("Can't set default type system to " + newTypeSystem);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission("orbital.logic.imp.TypeSystem.default", "write"));
        }
        defaultTypeSystem = newTypeSystem;
    }

    private Types() {
    }

    public static final boolean isApplicableTo(Type compositorType, Expression[] args) {
        return Types.typeOf(args).subtypeOf(compositorType.domain());
    }

    public static final int arityOf(Type type) {
        TypeSystem typeSystem = type.typeSystem();
        return type == typeSystem.ABSURD() ? Integer.MIN_VALUE : (type.equals(typeSystem.NOTYPE()) ? 0 : Types.arityOf_perhapsProduct(type));
    }

    private static final int arityOf_perhapsProduct(Type type) {
        Type.Composite t;
        if (type instanceof Type.Composite && (t = (Type.Composite)type).getCompositor() == type.typeSystem().product()) {
            return ((Type[])t.getComponent()).length;
        }
        return 1;
    }

    public static final Type typeOf(Typed[] args) {
        if (args == null || args.length == 0) {
            return Types.getDefault().NOTYPE();
        }
        Type[] argumentTypes = new Type[args.length];
        int i = 0;
        while (i < argumentTypes.length) {
            argumentTypes[i] = args[i].getType();
            ++i;
        }
        return Types.getDefault().product(argumentTypes);
    }

    public static final Type typeOf(Object args) {
        if (args == null) {
            return Types.getDefault().NOTYPE();
        }
        if (args instanceof Typed) {
            return ((Typed)args).getType();
        }
        if (args instanceof Typed[]) {
            return Types.typeOf((Typed[])args);
        }
        return null;
    }

    private static final Type declaredTypeOf(Functor.Specification spec) {
        return Types.getDefault().map(Types.typeOf(spec.getParameterTypes()), Types.getDefault().objectType(spec.getReturnType()));
    }

    public static final Type declaredTypeOf(Functor f) throws IntrospectionException {
        Type type = Types.getTypeDeclaration(f);
        return type != null ? type : Types.declaredTypeOf(Functor.Specification.getSpecification(f));
    }

    private static final Type typeOf(Class[] args) {
        if (args == null || args.length == 0) {
            return Types.getDefault().NOTYPE();
        }
        Type[] argumentTypes = new Type[args.length];
        int i = 0;
        while (i < argumentTypes.length) {
            argumentTypes[i] = Types.getDefault().objectType(args[i]);
            ++i;
        }
        return Types.getDefault().product(argumentTypes);
    }

    private static Type getTypeDeclaration(Object f) {
        if (f instanceof Type) {
            return Types.getDefault().TYPE();
        }
        Class<?> c = f.getClass();
        try {
            Field spec = Types.getFieldOrInherited(c, "logicalTypeDeclaration");
            int requiredModifier = 16;
            if ((spec.getModifiers() & requiredModifier) == requiredModifier && (class$orbital$logic$sign$type$Type == null ? (class$orbital$logic$sign$type$Type = Types.class$("orbital.logic.sign.type.Type")) : class$orbital$logic$sign$type$Type).isAssignableFrom(spec.getType())) {
                spec.setAccessible(true);
                return (Type)spec.get(f);
            }
        }
        catch (NoSuchFieldException trial) {
        }
        catch (IllegalAccessException trial) {}
        return null;
    }

    private static Field getFieldOrInherited(Class c, String name) throws NoSuchFieldException {
        try {
            return c.getField(name);
        }
        catch (NoSuchFieldException trial) {
            return c.getDeclaredField(name);
        }
    }

    public static final String toTypedString(Typed s) {
        return s == null ? "<null>" : (s instanceof Symbol ? ((Symbol)s).getSignifier() : s.toString()) + ':' + s.getType() + (Logger.global.isLoggable(Level.ALL) && s instanceof Variable && ((Variable)((Object)s)).isVariable() ? "[var]" : "");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

