/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.sign.concrete;

import java.beans.IntrospectionException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import orbital.logic.Composite;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.BinaryPredicate;
import orbital.logic.functor.Function;
import orbital.logic.functor.Functor;
import orbital.logic.functor.Predicate;
import orbital.logic.functor.VoidFunction;
import orbital.logic.functor.VoidPredicate;
import orbital.util.KeyValuePair;
import orbital.util.Utility;
import orbital.util.graph.ListTree;
import orbital.util.graph.Node;

public abstract class Notation
implements Serializable,
Comparable {
    private static final long serialVersionUID = -3071672372655194662L;
    private static final int PRECEDENCE_HIGH = 499;
    private static final int PRECEDENCE_LOW = 500;
    private static final int PRECEDENCE_DEFAULT = 500;
    private final String name;
    private static int nextOrdinal = 0;
    private static Notation[] values = new Notation[8];
    private final int ordinal = nextOrdinal++;
    private static Notation defaultNotation;
    public static final Notation DEFAULT;
    public static final Notation AUTO;
    public static final Notation PREFIX;
    public static final Notation INFIX;
    public static final Notation BESTFIX;
    public static final Notation POSTFIX;
    private static Map compositorNotation;

    protected Notation(String name) {
        this.name = name;
        Notation.values[Notation.nextOrdinal - 1] = this;
    }

    public abstract String format(Object var1, Object var2);

    public String toString() {
        return this.name;
    }

    public int compareTo(Object o) {
        return this.ordinal - ((Notation)o).ordinal;
    }

    public final boolean equals(Object that) {
        return super.equals(that);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private Object readResolve() throws ObjectStreamException {
        return values[this.ordinal];
    }

    protected static final Notation getDefault() {
        return defaultNotation;
    }

    public static final void setDefault(Notation notation) {
        if (notation == DEFAULT) {
            throw new IllegalArgumentException("true notation expected, no synonym");
        }
        defaultNotation = notation != null ? notation : PREFIX;
    }

    private static Object[] getPureParameters(Object compositor) {
        if (compositor instanceof Functor) {
            if (compositor instanceof VoidFunction || compositor instanceof VoidPredicate) {
                return null;
            }
            if (compositor instanceof Function || compositor instanceof Predicate) {
                return new String[]{"#0"};
            }
            if (compositor instanceof BinaryFunction || compositor instanceof BinaryPredicate) {
                return new String[]{"#0", "#1"};
            }
            try {
                Functor.Specification spec = Functor.Specification.getSpecification((Functor)compositor);
                Object[] pure = new String[spec.arity()];
                int i = 0;
                while (i < pure.length) {
                    pure[i] = "#" + i;
                    ++i;
                }
                return pure;
            }
            catch (IntrospectionException trying) {
                return null;
            }
        }
        return null;
    }

    public static NotationSpecification getNotation(Object compositor) {
        return (NotationSpecification)compositorNotation.get(compositor);
    }

    protected static int precedenceOf(Object compositor) {
        NotationSpecification spec = Notation.getNotation(compositor);
        return spec != null ? spec.precedence : 0;
    }

    public static boolean setNotation(Object f, NotationSpecification spec) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("setStatic.notationSpecification"));
        }
        return compositorNotation.put(f, spec) != null;
    }

    public static NotationSpecification removeNotation(Object f) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("setStatic.notationSpecification"));
        }
        return (NotationSpecification)compositorNotation.remove(f);
    }

    public static final void setAllNotations(Object[][] compositorsAndNotations) {
        int i = 0;
        while (i < compositorsAndNotations.length) {
            if (compositorsAndNotations[i].length != 2) {
                throw new IllegalArgumentException("array of dimension [][2] expected");
            }
            Object f = compositorsAndNotations[i][0];
            NotationSpecification notation = (NotationSpecification)compositorsAndNotations[i][1];
            if (f == null) {
                throw new NullPointerException("illegal compositor " + f + " for " + notation);
            }
            if (notation == null) {
                throw new NullPointerException("illegal notation " + notation + " for " + f);
            }
            Notation.setNotation(f, notation);
            ++i;
        }
    }

    private static boolean hasCompactBrackets(Object compositor) {
        NotationSpecification spec = Notation.getNotation(compositor);
        return spec != null && spec.arity() == 1;
    }

    static boolean isHigh(int precedence) {
        return precedence <= 499;
    }

    private static Node compositeTree(Object f) {
        if (!(f instanceof Composite)) {
            return new ListTree.TreeNode(f, f + "");
        }
        Composite c = (Composite)f;
        Object compositor = c.getCompositor();
        Collection components = Utility.asCollection(c.getComponent());
        ListTree.TreeNode n = new ListTree.TreeNode(compositor, compositor + "");
        if (components == null) {
            throw new NullPointerException(f + " of " + f.getClass() + " has compositor " + compositor + " and components " + components);
        }
        Iterator i = components.iterator();
        while (i.hasNext()) {
            n.add(Notation.compositeTree(i.next()));
        }
        return n;
    }

    static {
        DEFAULT = new Notation("default"){
            private static final long serialVersionUID = 5644030897053785928L;

            public String format(Object compositor, Object arg) {
                return Notation.getDefault().format(compositor, arg);
            }
        };
        AUTO = new Notation("auto"){
            private static final long serialVersionUID = -5725522528292770323L;

            public String format(Object compositor, Object arg) {
                NotationSpecification spec = Notation.getNotation(compositor);
                if (spec != null) {
                    return spec.notation.format(compositor, arg);
                }
                return PREFIX.format(compositor, arg);
            }
        };
        PREFIX = new Notation("prefix"){
            private static final long serialVersionUID = -5933847939038152414L;

            public String format(Object compositor, Object arg) {
                StringBuffer sb = new StringBuffer();
                if (compositor != null) {
                    if (compositor instanceof Composite) {
                        sb.append(this.format("", compositor));
                    } else {
                        sb.append(compositor + "");
                    }
                }
                if (arg == null) {
                    arg = Notation.getPureParameters(compositor);
                }
                if (arg != null) {
                    if (!Notation.hasCompactBrackets(compositor)) {
                        sb.append('(');
                    }
                    Iterator i = Utility.asCollection(arg).iterator();
                    while (i.hasNext()) {
                        sb.append(i.next() + (i.hasNext() ? "," : ""));
                    }
                    if (!Notation.hasCompactBrackets(compositor)) {
                        sb.append(')');
                    }
                }
                return sb.toString();
            }
        };
        INFIX = new Notation("infix"){
            private static final long serialVersionUID = 585674879470556509L;

            public String format(Object compositor, Object arg_) {
                Collection arg;
                if (arg_ == null) {
                    arg_ = Notation.getPureParameters(compositor);
                }
                if ((arg = Utility.asCollection(arg_)) == null || arg.size() == 0) {
                    return compositor + "";
                }
                StringBuffer sb = new StringBuffer();
                int precedence = Notation.precedenceOf(compositor);
                if (arg.size() == 1) {
                    if (compositor instanceof Composite) {
                        sb.append("(" + this.format("", compositor) + ") @");
                    } else {
                        sb.append(compositor + " @ ");
                    }
                }
                Iterator i = arg.iterator();
                while (i.hasNext()) {
                    sb.append(i.next());
                    if (!i.hasNext()) continue;
                    if (!Notation.isHigh(precedence)) {
                        sb.append(' ');
                    }
                    if (compositor instanceof Composite) {
                        sb.append("(" + this.format("", compositor) + ")");
                    } else {
                        sb.append(compositor);
                    }
                    if (Notation.isHigh(precedence)) continue;
                    sb.append(' ');
                }
                return sb.toString();
            }
        };
        BESTFIX = new Notation("bestfix"){
            private static final long serialVersionUID = 2361099498303659521L;

            public String format(Object compositor, Object arg_) {
                Node root;
                Collection arg;
                if (!(compositor instanceof Functor)) {
                    return PREFIX.format(compositor, arg_);
                }
                if (arg_ == null) {
                    arg_ = Notation.getPureParameters(compositor);
                }
                if ((arg = Utility.asCollection(arg_)) == null || arg.size() == 0) {
                    root = Notation.compositeTree(compositor);
                } else {
                    root = new ListTree.TreeNode(compositor, compositor.toString());
                    Iterator i = arg.iterator();
                    while (i.hasNext()) {
                        root.add(Notation.compositeTree(i.next()));
                    }
                }
                return new Function(this){
                    private StringBuffer sb;
                    private final /* synthetic */ 5 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object apply(Object root) {
                        return this.visit((Node)root);
                    }

                    private final String visit(Node node) {
                        if (node.isLeaf()) {
                            return ((KeyValuePair)((Object)node)).getValue() + "";
                        }
                        NotationSpecification spec = Notation.getNotation(((KeyValuePair)((Object)node)).getKey());
                        int apos = 0;
                        String[] argDesc = new String[node.getEdgeCount()];
                        int i = 0;
                        Iterator it = node.edges();
                        while (it.hasNext()) {
                            block8: {
                                String inner;
                                block7: {
                                    if (spec != null && NotationSpecification.access$400(spec).charAt(apos) == 'f') {
                                        ++apos;
                                    }
                                    Node n = (Node)it.next();
                                    NotationSpecification childSpec = Notation.getNotation(((KeyValuePair)((Object)n)).getKey());
                                    inner = this.visit(n);
                                    if (spec == null) break block7;
                                    switch (NotationSpecification.access$400(spec).charAt(apos++)) {
                                        case 'x': {
                                            argDesc[i] = childSpec == null || childSpec.compareTo(spec) < 0 ? inner : '(' + inner + ')';
                                            break block8;
                                        }
                                        case 'y': {
                                            argDesc[i] = childSpec == null || childSpec.compareTo(spec) <= 0 ? inner : '(' + inner + ')';
                                            break block8;
                                        }
                                        default: {
                                            throw new NumberFormatException("wrong associativity specifier " + spec);
                                        }
                                    }
                                }
                                argDesc[i] = inner;
                            }
                            ++i;
                        }
                        return AUTO.format(((KeyValuePair)((Object)node)).getKey(), argDesc);
                    }
                }.apply(root).toString();
            }
        };
        POSTFIX = new Notation("postfix"){
            private static final long serialVersionUID = -7892084161142935847L;

            public String format(Object compositor, Object arg) {
                StringBuffer sb = new StringBuffer();
                if (arg == null) {
                    arg = Notation.getPureParameters(compositor);
                }
                if (arg != null) {
                    if (!Notation.hasCompactBrackets(compositor)) {
                        sb.append('(');
                    }
                    Iterator i = Utility.asCollection(arg).iterator();
                    while (i.hasNext()) {
                        sb.append(i.next() + (i.hasNext() ? "," : ""));
                    }
                    if (!Notation.hasCompactBrackets(compositor)) {
                        sb.append(')');
                    }
                }
                if (compositor instanceof Composite) {
                    sb.append(this.format("", compositor));
                } else {
                    sb.append(compositor + "");
                }
                return sb.toString();
            }
        };
        compositorNotation = new HashMap();
        defaultNotation = BESTFIX;
    }

    public static class NotationSpecification
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -8249931256922519844L;
        private int precedence;
        private String associativity;
        private Notation notation;

        public NotationSpecification(int precedence, String associativity, Notation notation) {
            this.precedence = precedence;
            this.associativity = associativity;
            this.notation = notation;
        }

        public NotationSpecification(int precedence, String associativity, Notation notation, int arity) {
            this(precedence, associativity, notation);
            int assocArity = associativity.length() - 1;
            if (arity != assocArity) {
                throw new IllegalArgumentException("associativity description " + associativity + " with " + assocArity + " arguments must match arity " + arity);
            }
        }

        public NotationSpecification(int precedence, Notation notation, int arity) {
            this(precedence, NotationSpecification.prefixNonAssociativity(arity), notation);
        }

        public NotationSpecification(int precedence, String associativity) {
            this(precedence, associativity, null);
            int f = associativity.indexOf(102);
            if (f == 0) {
                this.notation = PREFIX;
            } else if (f == associativity.length() - 1) {
                this.notation = POSTFIX;
            } else if (f > 0) {
                this.notation = INFIX;
            } else {
                throw new IllegalArgumentException("could not guess notation from associativity '" + associativity + "'");
            }
        }

        public NotationSpecification(int arity) {
            this(500, DEFAULT, arity);
        }

        private static final String prefixNonAssociativity(int arity) {
            char[] associativityArguments = new char[arity];
            Arrays.fill(associativityArguments, 'y');
            return "f" + new String(associativityArguments);
        }

        public boolean equals(Object o) {
            if (o instanceof NotationSpecification) {
                NotationSpecification b = (NotationSpecification)o;
                return this.precedence == b.precedence && this.associativity.equals(b.associativity) && this.notation.equals(b.notation);
            }
            return false;
        }

        public int hashCode() {
            return this.precedence ^ Utility.hashCode(this.associativity) ^ Utility.hashCode(this.notation);
        }

        public int compareTo(Object o) {
            return this.precedence - ((NotationSpecification)o).precedence;
        }

        public String toString() {
            return "[" + this.precedence + "," + this.associativity + "," + this.notation + "]";
        }

        public int getPrecedence() {
            return this.precedence;
        }

        public String getAssociativity() {
            return this.associativity;
        }

        public Notation getNotation() {
            return this.notation;
        }

        int arity() {
            return this.getAssociativity().length() - 1;
        }

        static /* synthetic */ String access$400(NotationSpecification x0) {
            return x0.associativity;
        }
    }
}

