/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.sign;

import java.io.Serializable;
import orbital.logic.sign.Symbol;
import orbital.logic.sign.concrete.Notation;
import orbital.logic.sign.type.Type;
import orbital.logic.sign.type.Types;
import orbital.moon.logic.sign.type.StandardTypeSystem;
import orbital.util.Utility;
import orbital.util.logging.Level;
import orbital.util.logging.Logger;

public class SymbolBase
implements Symbol,
Serializable {
    private static final long serialVersionUID = 4003299661212808663L;
    public static final Type BOOLEAN_ATOM = Types.TRUTH;
    public static final Type UNIVERSAL_ATOM = Types.INDIVIDUAL;
    private String signifier;
    private Type type;
    private Notation.NotationSpecification notation;
    private final boolean variable;

    public SymbolBase(String signifier, Type type, Notation.NotationSpecification notation, boolean variable) {
        this.signifier = signifier;
        this.setType(type);
        this.mysetNotation(notation);
        this.variable = variable;
    }

    public SymbolBase(String signifier, Type type, Notation.NotationSpecification notation) {
        this(signifier, type, notation, false);
    }

    public SymbolBase(String signifier, Type type) {
        this(signifier, type, null);
    }

    public boolean equals(Object o) {
        if (o instanceof Symbol) {
            Symbol b = (Symbol)o;
            return Utility.equals(this.getSignifier(), b.getSignifier()) && Utility.equals(this.getType(), b.getType()) && Utility.equals(this.getNotation(), b.getNotation());
        }
        return false;
    }

    public int compareTo(Object o) {
        Symbol b = (Symbol)o;
        int a = Utility.compare(this.getNotation(), b.getNotation());
        if (a != 0) {
            return a;
        }
        a = StandardTypeSystem.LEXICOGRAPHIC.compare(this.getType(), b.getType());
        return a != 0 ? a : Utility.compare(this.getSignifier(), b.getSignifier());
    }

    public int hashCode() {
        return Utility.hashCode(this.getSignifier()) ^ Utility.hashCode(this.getType()) ^ Utility.hashCode(this.getNotation());
    }

    public String getSignifier() {
        return this.signifier;
    }

    public void setSignifier(String signifier) {
        this.signifier = signifier;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("invalid type specification: " + type + " for " + this.getSignifier());
        }
        this.type = type;
    }

    public Notation.NotationSpecification getNotation() {
        return this.notation;
    }

    private void mysetNotation(Notation.NotationSpecification notation) {
        this.notation = notation != null ? notation : new Notation.NotationSpecification(Types.arityOf(this.type.domain()));
    }

    public void setNotation(Notation.NotationSpecification notation) {
        this.mysetNotation(notation);
    }

    public boolean isVariable() {
        return this.variable;
    }

    public String toString() {
        if (Logger.global.isLoggable(Level.FINEST) || this.getType().equals(Types.getDefault().TYPE())) {
            return this.getSignifier() + ':' + this.getType() + (Logger.global.isLoggable(Level.ALL) ? (this.isVariable() ? "[var]" : "[const]") : "");
        }
        return this.getSignifier();
    }

    private String toShortString() {
        Type type = this.getType();
        return type.equals(Types.TRUTH) ? this.getSignifier() : this.getSignifier() + '/' + Types.arityOf(type.domain());
    }
}

