/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.sign;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import orbital.logic.sign.Expression;
import orbital.logic.sign.Signature;
import orbital.logic.sign.Symbol;
import orbital.logic.sign.type.Type;
import orbital.logic.sign.type.Types;
import orbital.util.DelegateSortedSet;
import orbital.util.InnerCheckedException;
import orbital.util.Setops;

public class SignatureBase
extends DelegateSortedSet
implements Signature {
    private static final long serialVersionUID = -2651634605539964276L;
    public static final SignatureBase EMPTY = new SignatureBase(Collections.unmodifiableSortedSet(new TreeSet()));
    static /* synthetic */ Class class$orbital$logic$sign$Expression;
    static /* synthetic */ Class class$orbital$logic$sign$SignatureBase;
    static /* synthetic */ Class class$orbital$logic$sign$Symbol;

    public SignatureBase(Collection symbols) {
        this(new TreeSet(symbols));
    }

    public SignatureBase() {
        super(new TreeSet());
    }

    private SignatureBase(SortedSet symbols) {
        super(symbols);
    }

    public boolean equals(Object o) {
        return o instanceof Signature && this.getDelegatee().equals(o);
    }

    public int hashCode() {
        return this.getDelegatee().hashCode();
    }

    public SortedSet getSymbols() {
        return (SortedSet)this.getDelegatee();
    }

    public void setSymbols(SortedSet symbols) {
        this.setDelegatee(symbols);
    }

    public boolean contains(String signifier, Object[] arg) {
        return this.get(signifier, arg) != null;
    }

    public Symbol get(String signifier, Object[] arg) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            Symbol s = (Symbol)o;
            if (!signifier.equals(s.getSignifier())) continue;
            if (arg instanceof Expression[]) {
                if (!Types.isApplicableTo(s.getType(), (Expression[])arg)) continue;
                return s;
            }
            throw new UnsupportedOperationException("type checking requires that the arguments are instances of " + (class$orbital$logic$sign$Expression == null ? (class$orbital$logic$sign$Expression = SignatureBase.class$("orbital.logic.sign.Expression")) : class$orbital$logic$sign$Expression));
        }
        return null;
    }

    public Symbol get(String signifier, Type maxType) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            Symbol s = (Symbol)o;
            if (!signifier.equals(s.getSignifier()) || !s.getType().subtypeOf(maxType)) continue;
            return s;
        }
        return null;
    }

    public Signature union(Signature sigma2) {
        SignatureBase u = this.newInstance();
        u.setSymbols(Setops.union(this, sigma2));
        return u;
    }

    public Signature intersection(Signature sigma2) {
        SignatureBase s = this.newInstance();
        s.setSymbols(Setops.intersection(this, sigma2));
        return s;
    }

    public Signature difference(Signature sigma2) {
        SignatureBase d = this.newInstance();
        d.setSymbols(Setops.difference(this, sigma2));
        return d;
    }

    public Signature symmetricDifference(Signature sigma2) {
        SignatureBase d = this.newInstance();
        d.setSymbols(Setops.symmetricDifference(this, sigma2));
        return d;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.getClass().getName());
        str.append('{');
        Iterator it = this.iterator();
        while (it.hasNext()) {
            str.append(it.next() + (it.hasNext() ? "," : ""));
        }
        str.append('}');
        return str.toString();
    }

    private SignatureBase newInstance() {
        try {
            return (SignatureBase)this.getClass().newInstance();
        }
        catch (InstantiationException nonconform) {
            throw new InnerCheckedException("invariant: sub classes of " + (class$orbital$logic$sign$SignatureBase == null ? (class$orbital$logic$sign$SignatureBase = SignatureBase.class$("orbital.logic.sign.SignatureBase")) : class$orbital$logic$sign$SignatureBase) + " must support nullary constructor for virtual new instance.", nonconform);
        }
        catch (IllegalAccessException nonconform) {
            throw new InnerCheckedException("invariant: sub classes of " + (class$orbital$logic$sign$SignatureBase == null ? (class$orbital$logic$sign$SignatureBase = SignatureBase.class$("orbital.logic.sign.SignatureBase")) : class$orbital$logic$sign$SignatureBase) + " must support nullary constructor for virtual new instance.", nonconform);
        }
    }

    public boolean add(Object o) {
        if (o instanceof Symbol) {
            return super.add(o);
        }
        throw new ClassCastException(o + " is not an instance of " + (class$orbital$logic$sign$Symbol == null ? (class$orbital$logic$sign$Symbol = SignatureBase.class$("orbital.logic.sign.Symbol")) : class$orbital$logic$sign$Symbol));
    }

    public static final Signature unmodifiableSignature(final Signature s) {
        return new SignatureBase((SortedSet)s){
            private static final long serialVersionUID = -7777832542719541528L;

            public boolean addAll(Collection param1) {
                throw new UnsupportedOperationException();
            }

            public boolean add(Object param1) {
                throw new UnsupportedOperationException();
            }

            public Iterator iterator() {
                return Setops.unmodifiableIterator(s.iterator());
            }

            public boolean remove(Object param1) {
                throw new UnsupportedOperationException();
            }

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public boolean removeAll(Collection param1) {
                throw new UnsupportedOperationException();
            }

            public boolean retainAll(Collection param1) {
                throw new UnsupportedOperationException();
            }

            public Symbol get(String param1, Type param2) {
                return s.get(param1, param2);
            }

            public Symbol get(String param1, Object[] param2) {
                return s.get(param1, param2);
            }

            public Signature union(Signature param1) {
                return s.union(param1);
            }

            public Signature intersection(Signature param1) {
                return s.intersection(param1);
            }

            public Signature difference(Signature param1) {
                return s.difference(param1);
            }

            public Signature symmetricDifference(Signature param1) {
                return s.symmetricDifference(param1);
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

