/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.sign;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 9011745358925992935L;
    private int errorOffset = -1;
    private int columnNumber = -1;
    private int lineNumber = -1;

    public ParseException(String message, int errorOffset, int lineNumber, int columnNumber, Throwable cause) {
        super(message);
        this.errorOffset = errorOffset;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public ParseException(String message, int lineNumber, int columnNumber, Throwable cause) {
        this(message, -1, lineNumber, columnNumber, cause);
    }

    public ParseException(String message, int errorOffset, Throwable cause) {
        this(message, errorOffset, -1, -1, cause);
    }

    public ParseException(String message, int errorOffset, int lineNumber, int columnNumber) {
        this(message, errorOffset, lineNumber, columnNumber, null);
    }

    public ParseException(String message, int lineNumber, int columnNumber) {
        this(message, -1, lineNumber, columnNumber);
    }

    public ParseException(String message, int errorOffset) {
        this(message, errorOffset, -1, -1);
    }

    public String getMessage() {
        return (this.getLineNumber() < 0 && this.getColumnNumber() < 0 ? "" : this.getLineNumber() + ":" + this.getColumnNumber()) + (this.getErrorOffset() < 0 ? "" : "(@" + this.getErrorOffset() + ")") + ": " + super.getMessage();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getErrorOffset() {
        return this.errorOffset;
    }
}

