/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.imp;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import orbital.logic.imp.Interpretation;
import orbital.logic.sign.Signature;
import orbital.logic.sign.SignatureBase;
import orbital.logic.sign.Symbol;
import orbital.logic.sign.type.TypeException;
import orbital.logic.sign.type.Types;
import orbital.util.DelegateMap;
import orbital.util.InnerCheckedException;
import orbital.util.Utility;

public class InterpretationBase
extends DelegateMap
implements Interpretation {
    private static final long serialVersionUID = 1211049244164642015L;
    private Signature sigma;
    static /* synthetic */ Class class$orbital$logic$imp$InterpretationBase;

    public static final Interpretation EMPTY(Signature sigma) {
        return new InterpretationBase(sigma, Collections.EMPTY_MAP);
    }

    private InterpretationBase() {
        super(new TreeMap());
    }

    protected InterpretationBase(Signature sigma) {
        this();
        this.sigma = sigma;
    }

    public InterpretationBase(Signature sigma, Map associations) {
        this(sigma);
        this.putAll(associations);
    }

    private InterpretationBase(Interpretation delegatee) {
        super(delegatee);
        this.sigma = null;
    }

    public boolean equals(Object o) {
        if (o instanceof Interpretation) {
            Interpretation b = (Interpretation)o;
            return Utility.equals(this.getSignature(), b.getSignature()) && super.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return Utility.hashCode(this.getSignature()) ^ super.hashCode();
    }

    public Signature getSignature() {
        return this.sigma;
    }

    public void setSignature(Signature sigma) {
        if (sigma != null) {
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!sigma.contains(o)) continue;
                throw new IllegalArgumentException("signature does not contain associated symbol " + o + ". Signature is invalid for this interpretation. You should clear association map first.");
            }
        }
        this.sigma = sigma;
    }

    public Object get(Object symbol) {
        this.validate(symbol);
        Object referent = super.get(symbol);
        return referent;
    }

    public Object remove(Object symbol) {
        this.validate(symbol);
        return super.remove(symbol);
    }

    public Object put(Object symbol, Object referent) {
        this.validate(symbol);
        if (!this.validate(symbol, referent)) {
            throw new TypeException("referent " + referent + " must conform to the type specification " + ((Symbol)symbol).getType() + " of the symbol " + symbol, ((Symbol)symbol).getType(), Types.typeOf(referent));
        }
        return super.put(symbol, referent);
    }

    public void putAll(Map associations) {
        if (this.sigma != null) {
            Iterator it = associations.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if (!this.validate(e.getKey(), e.getValue())) {
                    throw new TypeException("referent " + e.getValue() + " of " + e.getValue().getClass() + " must conform to the type " + ((Symbol)e.getKey()).getType() + " of the symbol " + e.getKey(), ((Symbol)e.getKey()).getType(), Types.typeOf(e.getValue()));
                }
                if (this.sigma.contains(e.getKey())) continue;
                throw new IllegalArgumentException("symbol " + e.getKey() + " not in signature. Association map is invalid for this signature.");
            }
        }
        super.putAll(associations);
    }

    public boolean containsKey(Object symbol) {
        this.validate(symbol);
        return super.containsKey(symbol);
    }

    public boolean contains(Object symbol) {
        return this.containsKey(symbol);
    }

    public Interpretation union(Interpretation i2) {
        InterpretationBase u = this.newInstance();
        u.setSignature(this.getSignature().union(i2.getSignature()));
        u.putAll((Map)this);
        u.putAll((Map)i2);
        return u;
    }

    public String toString() {
        if (this.getDelegatee() == null) {
            return "I<null>";
        }
        StringBuffer str = new StringBuffer("I<");
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry e = (Map.Entry)it.next();
                str.append(e.getKey() + "/" + e.getValue() + (it.hasNext() ? "," : ""));
            }
            catch (ClassCastException oops) {
                throw new InternalError("map does not contain Map.Entry");
            }
        }
        str.append('>');
        return str.toString();
    }

    private final void validate(Object symbol) {
        try {
            if (symbol == null) {
                throw new NoSuchElementException("Symbol <null> not in signature");
            }
            if (!this.sigma.contains(symbol)) {
                throw new NoSuchElementException("Symbol '" + symbol + "' not in signature " + this.sigma);
            }
        }
        catch (ClassCastException ex) {
            throw new ClassCastException("exception during validation of '" + symbol + "'");
        }
    }

    private final boolean validate(Object symbol, Object referent) {
        return ((Symbol)symbol).getType().apply(referent);
    }

    private InterpretationBase newInstance() {
        try {
            return (InterpretationBase)this.getClass().newInstance();
        }
        catch (InstantiationException nonconform) {
            throw new InnerCheckedException("invariant: sub classes of " + (class$orbital$logic$imp$InterpretationBase == null ? (class$orbital$logic$imp$InterpretationBase = InterpretationBase.class$("orbital.logic.imp.InterpretationBase")) : class$orbital$logic$imp$InterpretationBase) + " must support nullary constructor for virtual new instance.", nonconform);
        }
        catch (IllegalAccessException nonconform) {
            throw new InnerCheckedException("invariant: sub classes of " + (class$orbital$logic$imp$InterpretationBase == null ? (class$orbital$logic$imp$InterpretationBase = InterpretationBase.class$("orbital.logic.imp.InterpretationBase")) : class$orbital$logic$imp$InterpretationBase) + " must support nullary constructor for virtual new instance.", nonconform);
        }
    }

    public static final Interpretation unmodifiableInterpretation(final Interpretation i) {
        return new InterpretationBase(i){
            private static final long serialVersionUID = 2999004456165993569L;

            public Object put(Object param1, Object param2) {
                throw new UnsupportedOperationException();
            }

            public void putAll(Map param1) {
                throw new UnsupportedOperationException();
            }

            public Signature getSignature() {
                return SignatureBase.unmodifiableSignature(i.getSignature());
            }

            public Interpretation union(Interpretation param1) {
                return i.union(param1);
            }

            public void setSignature(Signature param1) {
                throw new UnsupportedOperationException();
            }

            public Object remove(Object param1) {
                throw new UnsupportedOperationException();
            }

            public Collection values() {
                return Collections.unmodifiableCollection(i.values());
            }

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public Set keySet() {
                return Collections.unmodifiableSet(i.keySet());
            }

            public Set entrySet() {
                throw new UnsupportedOperationException("not yet implemented: unmodifiable view of entrySet() with unmodifiable entries");
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

