/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.functor;

import java.util.HashMap;
import java.util.Map;
import orbital.logic.functor.Function;

public interface MutableFunction
extends Function {
    public Object set(Object var1, Object var2);

    public Object clone() throws CloneNotSupportedException;

    public static class TableFunction
    implements MutableFunction {
        private final boolean cache;
        private final Map map = new HashMap();
        private Function initialization;

        public TableFunction(Function initialization, boolean cache) {
            this.initialization = initialization;
            this.cache = cache;
        }

        public TableFunction(Function initialization) {
            this(initialization, true);
        }

        public TableFunction() {
            this(null);
        }

        public Object clone() {
            TableFunction clone = new TableFunction(this.initialization);
            clone.map.putAll(this.map);
            return clone;
        }

        public Function getInitialization() {
            return this.initialization;
        }

        public void setInitialization(Function h) {
            this.initialization = h;
        }

        public Object apply(Object arg) {
            Object value = this.map.get(arg);
            if (value == null && this.initialization != null) {
                value = this.initialization.apply(arg);
                if (this.cache) {
                    this.map.put(arg, value);
                }
            }
            return value;
        }

        public Object set(Object arg, Object value) {
            return this.map.put(arg, value);
        }
    }
}

