/*
 * Decompiled with CFR 0.152.
 */
package orbital.logic.functor;

import java.beans.IntrospectionException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import orbital.logic.sign.concrete.Notation;
import orbital.math.MathUtilities;
import orbital.util.Utility;

public interface Functor {
    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    class 1 {
        static /* synthetic */ Class class$java$lang$Object;
        static /* synthetic */ Class class$orbital$logic$functor$Functor$Specification;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static class Specification
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 7951104941212844811L;
        private static final String spec_method = "apply";
        private Class spec_returnType = 1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object;
        private Class[] spec_parameterTypes = null;

        public Specification(Class[] parameterTypes, Class returnType) {
            if (parameterTypes == null) {
                throw new NullPointerException("parameterTypes is null");
            }
            if (returnType == null) {
                throw new NullPointerException("returnType is null");
            }
            this.spec_parameterTypes = parameterTypes;
            this.spec_returnType = returnType;
        }

        public Specification(Specification[] parameterTypes, Specification returnType) {
            if (parameterTypes.length != 1 || parameterTypes[0].arity() != 0 || returnType.arity() != 0) {
                throw new UnsupportedOperationException("@xxx how to represent the type " + MathUtilities.format(parameterTypes) + "->" + returnType);
            }
            this.spec_parameterTypes = new Class[]{parameterTypes[0].getReturnType()};
            this.spec_returnType = returnType.getReturnType();
        }

        public Specification(Class[] parameterTypes) {
            this(parameterTypes, Boolean.TYPE);
        }

        public Specification(int arity, Class returnType) {
            this(new Class[arity], returnType);
            int i = 0;
            while (i < arity) {
                this.spec_parameterTypes[i] = 1.class$java$lang$Object == null ? 1.class$("java.lang.Object") : 1.class$java$lang$Object;
                ++i;
            }
        }

        public Specification(int arity) {
            this(arity, 1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object);
        }

        public Specification(String method, Class[] parameterTypes, Class returnType) {
            this(parameterTypes, returnType);
            if (method == null) {
                throw new NullPointerException("method name is null");
            }
            if (!spec_method.equals(method)) {
                throw new UnsupportedOperationException("not yet implemented");
            }
        }

        public Object clone() {
            return new Specification(this.spec_parameterTypes, this.spec_returnType);
        }

        public int compareTo(Object o) {
            Specification b = (Specification)o;
            int order = this.arity() - b.arity();
            if (order != 0) {
                return order;
            }
            int i = 0;
            while (i < this.spec_parameterTypes.length) {
                order = this.spec_parameterTypes[i].getName().compareTo(b.spec_parameterTypes[i].getName());
                if (order != 0) {
                    return order;
                }
                ++i;
            }
            return this.spec_returnType.getName().compareTo(b.spec_returnType.getName());
        }

        public boolean equals(Object arg) {
            if (arg instanceof Specification) {
                Specification B = (Specification)arg;
                if (this.arity() != B.arity() || !this.spec_returnType.equals(B.spec_returnType)) {
                    return false;
                }
                int i = 0;
                while (i < this.spec_parameterTypes.length) {
                    if (!this.spec_parameterTypes[i].equals(B.spec_parameterTypes[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this.arity() ^ this.spec_returnType.hashCode() >> 1 ^ Utility.hashCodeAll(this.spec_parameterTypes);
        }

        public int arity() {
            return this.spec_parameterTypes.length;
        }

        public Class[] getParameterTypes() {
            return this.spec_parameterTypes;
        }

        protected void setParameterTypes(Class[] newParameterTypes) {
            this.spec_parameterTypes = newParameterTypes;
        }

        public Class getReturnType() {
            return this.spec_returnType;
        }

        protected void setReturnType(Class newReturnType) {
            this.spec_returnType = newReturnType;
        }

        public boolean isCompatible(Specification b) {
            if (this.arity() != b.arity() || !this.spec_returnType.equals(b.spec_returnType)) {
                return false;
            }
            int i = 0;
            while (i < this.spec_parameterTypes.length) {
                if (!this.spec_parameterTypes[i].isAssignableFrom(b.spec_parameterTypes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean isApplicableTo(Object[] args) {
            if ((args == null || args.length == 0) && this.arity() == 0) {
                return true;
            }
            if (args.length != this.arity()) {
                return false;
            }
            Class[] spec_parameterTypes = this.getParameterTypes();
            int i = 0;
            while (i < spec_parameterTypes.length) {
                if (!(args[i] == null | spec_parameterTypes[i].isInstance(args[i]))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean isConform(Functor f) {
            try {
                return f != null && this.getMethod(f.getClass()) != null;
            }
            catch (NoSuchMethodException no) {
                return false;
            }
        }

        public Method getMethod(Class cls) throws NoSuchMethodException {
            Method apply = cls.getMethod(spec_method, this.getParameterTypes());
            if (!apply.getReturnType().equals(this.getReturnType())) {
                throw new NoSuchMethodException("attempt to provide method with a different return-type. required: " + this.getReturnType() + " found: " + apply + ". Perhaps covariant return-types have been added to the Java Language Specification?");
            }
            return apply;
        }

        public String toString() {
            String argumentTypes = Specification.typeListSpec(this.getParameterTypes());
            return "/" + this.arity() + ":" + (Boolean.TYPE.equals(this.getReturnType()) ? "(" + (argumentTypes != null ? argumentTypes : "") + ")" : (argumentTypes != null ? argumentTypes : "{()}") + "->" + this.getReturnType().getName());
        }

        private static final String typeListSpec(Class[] v) {
            if (v == null || v.length == 0) {
                return null;
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < v.length - 1) {
                sb.append(v[i].getName() + "*");
                ++i;
            }
            if (v.length > 0) {
                sb.append(v[v.length - 1].getName());
            }
            return sb.toString();
        }

        public static final Specification getSpecification(Functor f) throws IntrospectionException {
            Specification spec = Specification.getStaticSpecification(f.getClass());
            if (spec != null) {
                return spec;
            }
            Method apply = Specification.searchMethod(f.getClass());
            return new Specification(apply.getParameterTypes(), apply.getReturnType());
        }

        public static final Object invoke(Functor f, Object[] args) throws IntrospectionException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
            Specification spec = Specification.getSpecification(f);
            try {
                Method apply = spec.getMethod(f.getClass());
                if (!apply.isAccessible()) {
                    apply.setAccessible(true);
                }
                Object r = apply.invoke((Object)f, args);
                return r;
            }
            catch (IllegalAccessException inner) {
                throw new IntrospectionException("invalid functor");
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
        }

        private static Specification getStaticSpecification(Class c) {
            try {
                Field spec = c.getField("callTypeDeclaration");
                int requiredModifier = 16;
                if ((spec.getModifiers() & requiredModifier) == requiredModifier && (1.class$orbital$logic$functor$Functor$Specification == null ? (1.class$orbital$logic$functor$Functor$Specification = 1.class$("orbital.logic.functor.Functor$Specification")) : 1.class$orbital$logic$functor$Functor$Specification).isAssignableFrom(spec.getType())) {
                    if (!spec.isAccessible()) {
                        spec.setAccessible(true);
                    }
                    return (Specification)spec.get(null);
                }
            }
            catch (NoSuchFieldException trial) {
            }
            catch (IllegalAccessException trial) {}
            return null;
        }

        private static Method searchMethod(Class c) throws IntrospectionException {
            Method found = null;
            Method[] methods = c.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (spec_method.equals(methods[i].getName())) {
                    if (found == null) {
                        found = methods[i];
                    } else {
                        throw new IntrospectionException("invalid functor: apply(...)-methods are ambiguous");
                    }
                }
                ++i;
            }
            if (found != null) {
                return found;
            }
            throw new IntrospectionException("invalid functor: no apply method found");
        }
    }

    public static interface Composite
    extends orbital.logic.Composite,
    Functor {
        public Notation getNotation();

        public void setNotation(Notation var1);
    }
}

