
//Title:       ITX Telephony Application
//Version:     
//Copyright:   Copyright (c) 2000
//Author:      Indrayana Rustandi
//Company:     Columbia University, Computer Science Dept

import java.io.*;
import cnrg.itx.signal.*;
import cnrg.itx.signal.SignalEvent.*;
import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import cnrg.itx.ds.*;

public class TelephonyAppDest extends AbstractSignalingObserver {
  DesktopSignaling signaling = new DesktopSignaling(this); // initialize
  Channel inChannel, outChannel;
  AudioConnection ac;
  SignalConnection sc;
  BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
  boolean loggedIn;
  boolean dialing = false;
  //boolean invited = false;

  public TelephonyAppDest() {
  }

  public static void main(String[] args) {
    TelephonyAppDest app = new TelephonyAppDest();
    app.promptLogin();
  }

  public void promptLogin() {
    try {
      System.out.println("Do you want to login?");
      System.out.println("1. Yes");
      System.out.println("2. No");
      if (Integer.parseInt(in.readLine()) == 1)
        login();
    } catch (Exception e) {
      e.printStackTrace();
    }
    System.out.println("Waiting for a call...");
  }

  public void login() {
    try {
      System.out.print("Please enter your user name: ");
      String userID = in.readLine();
      System.out.print("Please enter your password: ");
      String password = in.readLine();
      System.out.print("Please enter the path of the config file: ");
      String conf = in.readLine();

      signalingLogout();
      signaling = new DesktopSignaling(this, userID, password, "ITX App", conf);
      loggedIn = true;
    } catch (Exception e1) {
      e1.printStackTrace();
    }
  }

  public void hangup() {
    if (sc != null) {
      try {
        sc.close();
        signaling.Hangup(sc);
      } catch (Exception e1) {
        e1.printStackTrace();
        System.exit(-1);
      }
    }
    if (ac != null) {
      ac.close();
    }
  }

  public void logout() {
    signalingLogout();
    signaling = new DesktopSignaling(this);
  }

  public boolean isDialing() {
    return dialing;
  }

  public void signalingLogout() {
    if (signaling != null) {
      signaling.logout();
    }
    loggedIn = false;
  }

  // SignalingObserver methods
  public void onInvite(InviteSignalEvent ise) {
    UserID sender = ise.getSenderID();
    Location loc = ise.getSenderLoc();
    String msg;

    if (sender != null)
      msg = "User " + sender.toString();
    else {
      if (!loc.isPhone())
        msg = loc.getIP() + ":" + loc.getPort();
      else
        msg = loc.getValue();
    }
    msg += " has invited for a call.\nAccept?";

    System.out.println(msg);
    System.out.println("1. Yes");
    System.out.println("2. No");

    try {
      prepareChannel();
      ac = new AudioConnection(inChannel, outChannel);
      int retval = Integer.parseInt(in.readLine());

      if (retval == 1) {
        ise.accept(ac);
      }
      else if (retval == 2) {
        // FUTURE: provide a way to obtain reason from user
        ise.reject("I don't want to talk with you.");
        ac.close();
      }
    } catch (Exception e1) {
      e1.printStackTrace();
      ise.reject("Couldn't setup connection.");
      ac.close();
    }
  }

  public void onStartCall(SignalConnection sc) {
    this.sc = sc;
    try {
      System.out.println("Start call");
      System.out.println("Type enter to hangup");
      sc.open();
      in.readLine();
      hangup();
    } catch (Exception e) {
      e.printStackTrace();
      if (ac != null)
        ac.close();
    }
  }

  public void onAbortCall(AbortSignalEvent ase) {
    String reason = ase.getAbortReason();
    System.out.println("Call aborted.\nReason: " + reason);
    //JOptionPane.showMessageDialog(frame, "Call aborted.\nReason: " + reason, "Call Aborted", JOptionPane.PLAIN_MESSAGE);
    if (ac != null)
      ac.close();
  }

  public void onHangup(HangupSignalEvent hse) {
    ac.close();
    try {
      signaling.Hangup(hse.getSignalConnection());
    } catch (ConnectException e) {
      e.printStackTrace();
    }
  }

  private void prepareChannel() throws DataException {
    // easy to customize
    if (inChannel != null)
      inChannel.close();
    inChannel = new Channel();
    inChannel.setSource(new NetworkSource(inChannel, MicrophoneSource.SAMPLE_SIZE));
    inChannel.addDestination(new SpeakerDestination());

    //HALF-DUPLEX
    outChannel = null;
    /*
    if (outChannel != null)
      outChannel.close();
    outChannel = new Channel();
    outChannel.setSource(new MicrophoneSource(outChannel));
    outChannel.addDestination(new NetworkDestination());
    */
  }
}
