
//Title:       ITX Telephony Application
//Version:     
//Copyright:   Copyright (c) 2000
//Author:      Indrayana Rustandi
//Company:     Columbia University, Computer Science Dept

import java.io.*;
import cnrg.itx.signal.*;
import cnrg.itx.signal.SignalEvent.*;
import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import cnrg.itx.ds.*;

public class TelephonyApp extends AbstractSignalingObserver {
  DesktopSignaling signaling = new DesktopSignaling(this); // initialize
  Channel inChannel, outChannel;
  AudioConnection ac;
  SignalConnection sc;
  BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
  boolean loggedIn;
  boolean dialing = false;
  //boolean invited = false;

  public TelephonyApp() {
  }

  public static void main(String[] args) {
    boolean quit = false;
    TelephonyApp app = new TelephonyApp();
    while (!quit) {
      int selection = app.menu();
      switch (selection) {
        case 1:
          app.login();
          break;
        case 2:
          app.dial();
          break;
        case 3:
          app.logout();
          break;
        case 0:
        default:
          quit = true;
      }
    }

    System.exit(0);
  }

  public int menu() {
    try {
      System.out.println("0. Exit");
      System.out.println("1. Login");
      System.out.println("2. Dial");
      System.out.println("3. Logout");
      System.out.println();
      System.out.print("Please enter your choice: ");
      int selection = Integer.parseInt(in.readLine());
      return selection;
    } catch (Exception e) {
      e.printStackTrace();
      return 0;
    }
  }

  public void login() {
    try {
      System.out.print("Please enter your user name: ");
      String userID = in.readLine();
      System.out.print("Please enter your password: ");
      String password = in.readLine();
      System.out.print("Please enter the path of the config file: ");
      String conf = in.readLine();

      signalingLogout();
      signaling = new DesktopSignaling(this, userID, password, "ITX App", conf);
      loggedIn = true;
    } catch (Exception e1) {
      e1.printStackTrace();
      return;
    }
  }

  public void dial() {
    int type;
    try {
      if (loggedIn) {
        System.out.println("Please select the type of destination to dial:");
        System.out.println("1. Internet address");
        System.out.println("2. User");

        type = Integer.parseInt(in.readLine());
      }
      else {
        type = 1;
      }

      System.out.print("Please enter the destination user/address: ");
      String dest = in.readLine();
      setupDial(dest, type);
    } catch (Exception e1) {
      e1.printStackTrace();
      return;
    }
  }

  public void setupDial(String dest, int type) {
    if (type != 1 && type != 2)
      return;

    try {
      prepareChannel();
      ac = new AudioConnection(inChannel, outChannel);
    } catch (Exception e1) {
      e1.printStackTrace();
      return;
    }

    try {
      if (type == 1) {
        sc = signaling.Dial(new Location(Location.INTERNET_TYPE, dest, "ITX Dial"), inChannel, outChannel);
      }
      else if (type == 2) {
        if (!loggedIn) {
          System.out.println("Error: you cannot dial a user, because you are not logged in.");
          ac.close();
          return;
        }
        else {
          sc = signaling.Dial(dest, inChannel, outChannel);
        }
      }
      ac.open();
      dialing = true;
      in.readLine();
      hangup();
    } catch (Exception e1) {
      e1.printStackTrace();
      ac.close();
      return;
    }
  }

  public void hangup() {
    if (sc != null) {
      try {
        sc.close();
        signaling.Hangup(sc);
      } catch (Exception e1) {
        e1.printStackTrace();
        System.exit(-1);
      }
    }
    if (ac != null) {
      ac.close();
    }
  }

  public void logout() {
    signalingLogout();
    signaling = new DesktopSignaling(this);
  }

  public boolean isDialing() {
    return dialing;
  }

  public void signalingLogout() {
    if (signaling != null) {
      signaling.logout();
    }
    loggedIn = false;
  }

  // SignalingObserver methods
  public void onInvite(InviteSignalEvent ise) {
    UserID sender = ise.getSenderID();
    Location loc = ise.getSenderLoc();
    String msg;

    if (sender != null)
      msg = "User " + sender.toString();
    else {
      if (!loc.isPhone())
        msg = loc.getIP() + ":" + loc.getPort();
      else
        msg = loc.getValue();
    }
    msg += " has invited for a call.\nAccept?";

    System.out.println(msg);
    System.out.println("1. Yes");
    System.out.println("2. No");

    try {
      int retval = Integer.parseInt(in.readLine());

      if (retval == 1) {
        prepareChannel();
        ac = new AudioConnection(inChannel, outChannel);
        ise.accept(ac);
      }
      else if (retval == 2) {
        // FUTURE: provide a way to obtain reason from user
        ise.reject("I don't want to talk with you.");
      }
    } catch (Exception e1) {
      e1.printStackTrace();
      ise.reject("Couldn't setup connection.");
    }
  }

  public void onStartCall(SignalConnection sc) {
    this.sc = sc;
    try {
      sc.open();
    } catch (Exception e) {
      e.printStackTrace();
      ac.close();
    }
  }

  public void onAbortCall(AbortSignalEvent ase) {
    String reason = ase.getAbortReason();
    System.out.println("Call aborted.\nReason: " + reason);
    //JOptionPane.showMessageDialog(frame, "Call aborted.\nReason: " + reason, "Call Aborted", JOptionPane.PLAIN_MESSAGE);
    if (ac != null)
      ac.close();
  }

  public void onHangup(HangupSignalEvent hse) {
    ac.close();
    try {
      signaling.Hangup(hse.getSignalConnection());
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private void prepareChannel() throws DataException {
    // easy to customize
    inChannel = new Channel();
    inChannel.setSource(new NetworkSource(inChannel, MicrophoneSource.SAMPLE_SIZE));
    inChannel.addDestination(new SpeakerDestination());

    outChannel = new Channel();
    outChannel.setSource(new MicrophoneSource(outChannel));
    outChannel.addDestination(new NetworkDestination());
  }
}
