import java.io.*;
import java.util.*;
import cnrg.itx.signal.*;
import cnrg.itx.ds.*;
import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;

public class PC2PCSource extends AbstractSignalingObserver implements Observer {
  SignalConnection sc;
  AudioConnection ac;
  Channel inChannel, outChannel;

  public static void main(String[] args) {
    PC2PCSource source = new PC2PCSource();
    DesktopSignaling signal = new DesktopSignaling(source);
    SignalConnection sc;

    try {
      Location destLoc = source.setDestination();
      sc = signal.Dial(destLoc);
      source.openConnection(sc);
    } catch (Exception e) {
      System.out.println("Dial failed.");
      e.printStackTrace();
    }
  }

  public Location setDestination() throws IOException {
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    String hostName;
    String port;

    try {
      System.out.print("Please enter the host name of the destination: ");
      hostName = in.readLine();
      System.out.print("Please enter the port of the destination: ");
      port = in.readLine();
      String hostPort = hostName + ":" + port;
      return new Location(Location.INTERNET_TYPE, hostPort, "");
    } catch (IOException e) {
      throw e;
    }
  }

  public void openConnection(SignalConnection sc) {
    this.sc = sc;
    outChannel = sc.getOutputChannel();
    try {
      ac = new AudioConnection(null, outChannel);
      ac.addObserver(new PC2PCSource());
      ac.open();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public void update(Observable o, Object arg) {
    System.out.println(arg);
  }
}

