import cnrg.itx.signal.*;
import cnrg.itx.ds.*;
import cnrg.itx.signal.SignalEvent.*;
import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import java.util.*;
import java.io.*;

public class PC2PCDest extends AbstractSignalingObserver implements Observer {
  Location peerLoc;
  boolean call = false;

  public static void main(String[] args) {
    PC2PCDest dest = new PC2PCDest();
    DesktopSignaling signal = new DesktopSignaling(dest);
  }

  public void onInvite(InviteSignalEvent ise) {
    peerLoc = ise.getSenderLoc();
    System.out.println(peerLoc.getIP() + ":" + peerLoc.getPort());
    Connection c;

    try {
      Channel inChannel = new Channel();
      inChannel.setSource(new NetworkSource(inChannel, MicrophoneSource.SAMPLE_SIZE));
      inChannel.addDestination(new StreamDestination(new FileOutputStream("test.wav")));

      c = new AudioConnection(inChannel, null);
      ise.accept(c);
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(-1);
    }
  }

  public void onStartCall(SignalConnection sc) {
    try {
      sc.open();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public void update(Observable o, Object arg) {
    System.out.println(arg);
  }
}

