import java.io.*;
import java.util.*;
import cnrg.itx.ds.*;

public class ListUser {
  public static void main(String[] args) {
    DirectoryService ds;
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

    try {
      System.out.println("ITX User Administration");
      System.out.print("Please enter the path for the resolv.conf file (default D:\\ITX Application\\resolv.conf): ");
      String configPath = in.readLine();
      if (configPath == null)
        configPath = new String("D:\\ITX Application\\resolv.conf");
      ds = new DirectoryService(configPath);
    } catch (DirectoryServiceException e1) {
      System.out.println("Directory service exception!");
      e1.printStackTrace();
      return;
    } catch (IOException e2) {
      System.out.println("IO Exception!");
      e2.printStackTrace();
      return;
    }
      
    try {
      ListUser.login(ds);
    } catch (AuthenticationException e1) {
      System.out.println("Authentication Exception!");
      e1.printStackTrace();
      return;
    } catch (DirectoryServiceException e2) {
      System.out.println("Error, directory service is null!");
      return;
    } catch (IOException e3) {
      System.out.println("IO Exception!");
      e3.printStackTrace();
      return;
    }

    System.out.println("Login successful!");
    System.out.println();

    try {
      ListUser.listUser(ds);
    } catch (Exception e2) {
      e2.printStackTrace();
      return;
    }
  }

  public static void listUser(DirectoryService ds) throws Exception {
    try {
      Vector users = ds.dumpAllUsers();
      UserProperty user;
      for (int i = 0; i < users.size(); i++) {
        user = (UserProperty)users.elementAt(i);
        System.out.println(user.getUserID().toString() + " " +
                            user.getExtension() + " " + user.getCustomMessage());
      }
    } catch (Exception e) {
      throw e;
    }
  }

  public static void login(DirectoryService ds) throws IOException, AuthenticationException, DirectoryServiceException {
    if (ds == null)
      throw new DirectoryServiceException("DirectoryService is not initialized");

    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    UserID adminID;
    Password adminPass;

    try {
      System.out.print("Please enter administrator's ID: ");
      adminID = new UserID(in.readLine());
      System.out.print("Please enter administrator's password: ");
      adminPass = new Password(in.readLine());
    } catch (IOException e) {
      throw e;
    }

    try {
      ds.declareIdentity(adminID, adminPass);
    } catch (AuthenticationException e1) {
      throw e1;
    }
  }

  public static void addUser(DirectoryService ds) 
  throws Exception {
    if (ds == null)
      throw new DirectoryServiceException("DirectoryService is not initialized");

    UserID newUserID;
    Password newUserPass;
    Digits newUserExt;
    String newUserMsg;
    boolean digits = false;
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));    

    try {
      System.out.print("Please enter new user's ID: ");
      newUserID = new UserID(in.readLine());
      System.out.print("Please enter new user's password: ");
      newUserPass = new Password(in.readLine());
      System.out.print("Please enter new user's extension: ");
      newUserExt = new Digits(in.readLine());
      while (digits == false) {
        if (newUserExt.count() != 4) {
          System.out.println("Please enter a 4-digit extension.");
          System.out.print("Enter again: ");
          newUserExt = new Digits(in.readLine());
        }
        else
          digits = true;
       }
       System.out.print("Please enter a message for the new user (e.g. name): ");
       newUserMsg = in.readLine();
    } catch (IOException e) {
      throw e;
    }

    try {
      ds.addUser(newUserID, newUserExt, newUserPass, DirectoryService.USER_ACCESS_LEVEL, newUserMsg);
    } catch (Exception e) {
      throw e;
    }
  }
}     