/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.itx.dsadmin;

import cnrg.itx.ds.Digits;
import cnrg.itx.ds.DirectoryService;
import cnrg.itx.ds.Password;
import cnrg.itx.ds.RecordAlreadyExistsException;
import cnrg.itx.ds.UserID;
import edu.columbia.cs.itx.dsadmin.DSTableModel;
import edu.columbia.cs.itx.dsadmin.DSUserManagerException;
import edu.columbia.cs.itx.dsadmin.TableMap;
import edu.columbia.cs.itx.dsadmin.UserEditorDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DSUserManager
implements ActionListener {
    DSUserManager_Add addUserManager;
    JTable usersTable;
    TableModel sorter;
    TableModel usersTableModel;
    Frame owner;
    DirectoryService ds;

    public DSUserManager(Frame owner, JTable usersTable, DirectoryService ds) throws DSUserManagerException {
        if (usersTable == null || ds == null) {
            throw new DSUserManagerException("Table or DirectoryService cannot be null.");
        }
        this.owner = owner;
        this.ds = ds;
        this.usersTable = usersTable;
        this.sorter = usersTable.getModel();
        this.usersTableModel = ((TableMap)this.sorter).getModel();
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        String text = source.getText();
        if (text.equals("Add User")) {
            this.addUserManager = new DSUserManager_Add();
        } else if (text.equals("Remove User")) {
            this.removeUser();
        }
    }

    public void removeUser() {
        int selectedRow = this.usersTable.getSelectedRow();
        if (selectedRow == -1) {
            JOptionPane.showMessageDialog(this.owner, "Please select a user to remove.", "User Not Selected", 2);
        } else {
            String ext;
            String userID = (String)this.sorter.getValueAt(selectedRow, 0);
            int retval = this.warning(userID, ext = (String)this.sorter.getValueAt(selectedRow, 1));
            if (retval == 0) {
                try {
                    this.ds.removeUser(new Digits(ext));
                    this.dataUpdated();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public int warning(String userID, String ext) {
        String msg = String.valueOf(String.valueOf(String.valueOf(String.valueOf("Are you sure you want to remove user ").concat(String.valueOf(userID))).concat(String.valueOf(" with extension "))).concat(String.valueOf(ext))).concat(String.valueOf("?"));
        return JOptionPane.showConfirmDialog(this.owner, msg, "Warning! About to remove a user.", 0, 2);
    }

    public void dataUpdated() {
        try {
            Vector users = this.ds.dumpAllUsers();
            ((DSTableModel)this.usersTableModel).setUsers(users);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class DSUserManager_Add
    implements ActionListener {
        UserEditorDialog userEditorDialog;

        public DSUserManager_Add() {
            this.userEditorDialog = new UserEditorDialog(DSUserManager.this.owner, "Add a User", false);
            this.userEditorDialog.addAddButtonActionListener(this);
            ((Component)this.userEditorDialog).setVisible(true);
        }

        public void actionPerformed(ActionEvent e) {
            String id = this.userEditorDialog.getID();
            String ext = this.userEditorDialog.getExtension();
            String pass1 = this.userEditorDialog.getPassword();
            String pass2 = this.userEditorDialog.getVerifyingPassword();
            String custMsg = this.userEditorDialog.getCustomMessage();
            if (pass1.equals(pass2)) {
                int accessLevel;
                switch (this.userEditorDialog.getAccessLevelListIndex()) {
                    case 2: {
                        accessLevel = 100;
                        break;
                    }
                    case 1: {
                        accessLevel = 99;
                        break;
                    }
                    default: {
                        accessLevel = 9;
                    }
                }
                try {
                    DSUserManager.this.ds.addUser(new UserID(id), new Digits(ext), new Password(pass1), accessLevel, custMsg);
                    DSUserManager.this.dataUpdated();
                }
                catch (RecordAlreadyExistsException e1) {
                    String msg = String.valueOf(String.valueOf("User with extension ").concat(String.valueOf(ext))).concat(String.valueOf(" already exists."));
                    JOptionPane.showMessageDialog(DSUserManager.this.owner, msg, "Error: Duplicate User", 2);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(DSUserManager.this.owner, "Invalid password!", "Invalid Password", 2);
            }
            this.userEditorDialog.dispose();
            this.userEditorDialog = null;
        }
    }
}

