/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.itx.dsadmin;

import cnrg.itx.ds.DirectoryService;
import cnrg.itx.ds.DirectoryServiceException;
import edu.columbia.cs.itx.dsadmin.DSAuthenticator;
import edu.columbia.cs.itx.dsadmin.DSAuthenticatorException;
import edu.columbia.cs.itx.dsadmin.DSManagerMainFrame;
import edu.columbia.cs.itx.dsadmin.DSTableModel;
import edu.columbia.cs.itx.dsadmin.DSUserManager;
import edu.columbia.cs.itx.dsadmin.TableSorter;
import edu.columbia.cs.itx.dsadmin.event.DSAuthenticationEvent;
import edu.columbia.cs.itx.dsadmin.event.DSAuthenticationListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JOptionPane;

public class DSManager
implements ActionListener,
DSAuthenticationListener {
    private DirectoryService ds;
    DSManagerMainFrame frame = new DSManagerMainFrame();
    TableSorter sorter;
    DSTableModel dataModel;
    DSAuthenticator authenticator;
    DSUserManager userManager;
    boolean loggedIn = false;
    boolean dsInitialized = false;

    public DSManager() {
        this.frame.addWindowListener(null.new 1());
        this.sorter = new TableSorter();
        this.dataModel = new DSTableModel();
        this.sorter.setModel(this.dataModel);
        this.dataModel.addTableModelListener(this.sorter);
        this.frame.setTableModel(this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.frame.getTable());
        this.sorter.addTableModelListener(this.frame.getTable());
        this.frame.addLoginActionListener(this);
        this.frame.addAddUserActionListener(this.userManager);
        this.frame.addRemoveUserActionListener(this.userManager);
        this.frame.addConfigMenuActionListener(new ConfigMenuObserver());
        this.setLogin(false);
        ((Component)this.frame).setVisible(true);
    }

    public static void main(String[] args) {
        new DSManager();
    }

    public void login() {
        try {
            this.authenticator = new DSAuthenticator(this.frame, this.frame.getTable(), this.ds);
            this.authenticator.addDSAuthenticationListener(this);
        }
        catch (DSAuthenticatorException e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dsInitialized) {
            this.login();
        } else {
            String msg = "Please load a configuration file first.";
            JOptionPane.showMessageDialog(this.frame, msg, "Error: DirectoryService Not Initialized", 2);
        }
    }

    public void dsAuthenticated(DSAuthenticationEvent e) {
        this.setLogin(true);
    }

    public void setLogin(boolean b) {
        this.loggedIn = b;
        this.frame.setLoginEnabled(!this.loggedIn);
        this.frame.setAddUserEnabled(this.loggedIn);
        this.frame.setRemoveUserEnabled(this.loggedIn);
    }

    public void setDS(DirectoryService ds) {
        this.ds = ds;
        this.dsInitialized = true;
        try {
            this.frame.removeAddUserActionListener(this.userManager);
            this.frame.removeRemoveUserActionListener(this.userManager);
            this.userManager = new DSUserManager(this.frame, this.frame.getTable(), ds);
            this.frame.addAddUserActionListener(this.userManager);
            this.frame.addRemoveUserActionListener(this.userManager);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    class ConfigMenuObserver
    implements ActionListener {
        ConfigMenuObserver() {
        }

        public void actionPerformed(ActionEvent e) {
            String msg = "Please input the full path for the resolv.conf file.\n(e.g. C:\\ITX\\resolv.conf)";
            String path = JOptionPane.showInputDialog(DSManager.this.frame, msg, "Configuration File Path", 3);
            try {
                DSManager.this.ds = new DirectoryService(path);
                DSManager.this.setDS(DSManager.this.ds);
                DSManager.this.setLogin(false);
            }
            catch (DirectoryServiceException exp) {
                JOptionPane.showMessageDialog(DSManager.this.frame, "Fail to load DirectoryService.", "Error: DirectoryService Load Failed", 2);
            }
        }
    }

    class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }

        1() {
        }
    }
}

