/*
 * Decompiled with CFR 0.152.
 */
package edu.columbia.cs.itx.dsadmin;

import cnrg.itx.ds.AuthenticationException;
import cnrg.itx.ds.DirectoryService;
import cnrg.itx.ds.Password;
import cnrg.itx.ds.UserID;
import edu.columbia.cs.itx.dsadmin.DSAuthenticatorException;
import edu.columbia.cs.itx.dsadmin.DSTableModel;
import edu.columbia.cs.itx.dsadmin.LoginDialog;
import edu.columbia.cs.itx.dsadmin.TableMap;
import edu.columbia.cs.itx.dsadmin.event.AbstractDSAuthenticationModel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class DSAuthenticator
extends AbstractDSAuthenticationModel
implements ActionListener {
    private DirectoryService ds;
    private LoginDialog loginDialog;
    private UserID adminID;
    private Password adminPass;
    private Frame parent;
    private boolean authenticated = false;
    private TableModel sorter;
    private TableModel usersTableModel;

    public DSAuthenticator(Frame parent, JTable usersTable, DirectoryService ds) throws DSAuthenticatorException {
        if (ds == null) {
            throw new DSAuthenticatorException("Directory service not initialized.");
        }
        this.ds = ds;
        this.parent = parent;
        this.loginDialog = new LoginDialog(parent, "Administrator's Login", false);
        this.loginDialog.setFieldListener(this);
        this.loginDialog.setSubmitListener(this);
        ((Component)this.loginDialog).setVisible(true);
        this.sorter = usersTable.getModel();
        this.usersTableModel = ((TableMap)this.sorter).getModel();
    }

    public DirectoryService getDS() {
        return this.ds;
    }

    public void authenticate() {
        this.authenticated = false;
        this.loginDialog.hide();
        this.adminID = new UserID(this.loginDialog.getID());
        this.adminPass = new Password(this.loginDialog.getPass());
        try {
            this.ds.declareIdentity(this.adminID, this.adminPass);
            if (this.ds.getAccessLevel() != 100) {
                this.warning("You are not an administrator.\nPlease login with an administrator's ID.");
            } else {
                this.authenticated = true;
                this.fireAuthenticated(this);
                this.dataUpdated();
            }
        }
        catch (AuthenticationException exp1) {
            this.warning("Authentication fails.\nPlease try again.");
        }
        this.loginDialog.dispose();
        this.loginDialog = null;
    }

    public void actionPerformed(ActionEvent e) {
        this.authenticate();
    }

    private void warning(String msg) {
        JOptionPane.showMessageDialog(this.parent, msg, "Warning", 2);
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isFinished() {
        return this.loginDialog == null;
    }

    public void dataUpdated() {
        try {
            Vector users = this.ds.dumpAllUsers();
            ((DSTableModel)this.usersTableModel).setUsers(users);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

