import java.io.PrintWriter;
import antlr.collections.AST;

/**
 * The function data type (including internal functions)
 *
 * @author Hanhua Feng - hf2048@columbia.edu
 * @version $Id: MxFunction.java,v 1.9 2003/05/12 23:44:34 hanhua Exp $
 */
class MxFunction extends MxDataType {
    // we need a reference to the AST for the function entry
    String[] args;
    AST body;            // body = null means an internal function.
    MxSymbolTable pst;   // the symbol table of static parent 
    int id;              // for internal functions only
    
    public MxFunction( String name, String[] args, 
                       AST body, MxSymbolTable pst) {
        super( name );
        this.args = args;
        this.body = body;
        this.pst = pst;
    }

    public MxFunction( String name, int id ) {
        super( name );
        this.args = null;
        this.id = id;
        pst = null;
        body = null;
    }

    public final boolean isInternal() {
        return body == null;
    }

    public final int getInternalId() {
        return id;
    }

    public String typename() {
        return "function";
    }

    public MxDataType copy() {
        return new MxFunction( name, args, body, pst );
    }

    public void print( PrintWriter w ) {
        if ( body == null ) 
        {
            w.println( name + " = <internal-function> #" + id );
        }
        else
        {
            if ( name != null )
                w.print( name + " = " );
            w.print( "<function>(" );
            for ( int i=0; ; i++ )
            {
                w.print( args[i] );
                if ( i >= args.length - 1 )
                    break;
                w.print( "," );
            }
            w.println( ")" );
        }
    }

    public String[] getArgs() {
        return args;
    }

    public MxSymbolTable getParentSymbolTable() {
        return pst;
    }

    public AST getBody() {
        return body;
    }
}
