import java.applet.*;
import java.lang.*;
import java.net.*;
import java.awt.*;
import java.util.*;
import java.io.*;

public class LedPanel extends Canvas {
    final Applet caller;

    final static int showSecond = 0x1;
    final static int showTime = 0x2;
    final static int showAmPm = 0x4;
    final static int showDate = 0x8;
    final static int showYear = 0x10;
    final static int show2000 = 0x20;

    Image strip;
    int width = 15;
    int height = 15;
    int length;
    int leds[];

    public void setStrip( Applet caller, int i ) {
	strip = caller.getImage( caller.getDocumentBase(), 
				 "led_strip" + Integer.toString(i) + ".gif" );
	MediaTracker tracker = new MediaTracker( caller );
	tracker.addImage( strip, 0 );
	try
	{
	    tracker.waitForAll();
	}
	catch( InterruptedException e ) {}
		
	height = strip.getHeight( this );
    }

    public LedPanel( Applet caller, int length ) {
	if ( length <= 0 )
	    length = 1;
	else if ( length > 100 )
	    length = 100;

	this.length = length;
	leds = new int[length];

	for ( int i=0; i<length; i++ )
	    leds[i] = 12;

	this.caller = caller;
	setStrip( caller, 0 );
    }

    private void expandRect( Rectangle r, int n ) {
	r.x -= n;
	r.y -= n;
	r.width += n + n;
	r.height += n + n;
    }

    private void draw3dRect( Graphics g, Rectangle r, Color bright, Color dark ) {
	g.setColor( bright );
	g.drawLine( r.x, r.y, r.x+r.width-1, r.y );
	g.drawLine( r.x, r.y+1, r.x, r.y+r.height-1 );
	g.setColor( dark );
	g.drawLine( r.x+r.width-1, r.y+1, r.x+r.width-1, r.y+r.height-1 );
	g.drawLine( r.x+1, r.y+r.height-1, r.x+r.width-1, r.y+r.height-1 );
    }

    public void paintLed( Graphics g, int a[], int n, int x, int y ) {
	Rectangle r = new Rectangle( x, y, width*n+10, height+10 );
	Color old_color = g.getColor();
	draw3dRect( g, r, Color.white, Color.darkGray );
	expandRect( r, -1 );
	draw3dRect( g, r, Color.lightGray, Color.lightGray );
	expandRect( r, -1 );
	draw3dRect( g, r, Color.lightGray, Color.lightGray );
	expandRect( r, -1 );
	draw3dRect( g, r, Color.lightGray, Color.lightGray );
	expandRect( r, -1 );
	draw3dRect( g, r, Color.darkGray, Color.white );
	expandRect( r, -1 );
	for ( int i=0; i<n; i++ )
	{
	    int j = a[i];
	    if ( j < 0 || j > 15 )
		j = 12;
	    g.drawImage( strip, r.x+width*i, r.y, r.x+width*(i+1), r.y+r.height,
		       width*j, 0, width*(j+1), r.height, caller );
	}
	g.setColor( old_color );
    }

    public void show( int a[], int n ) {
	leds = a;
	length = n;
	repaint();
    }

    public void showInt( int value ) {
	boolean neg = value < 0;
	int a[] = new int[length];
	if ( neg )
	    value = -value;
	for ( int i=length-1; i>=0; i-- )
	{
	    a[i] = value % 10;
	    value /= 10;
	}
	if ( neg )
	    a[0] = 13;
	show( a, length );
    }

    public void showClock( long time, int format ) {
	int a[] = new int[16];
	int i = 0;
	Date d = new Date(time);
	int n;
	boolean pm = false;

	if ( 0 != ( format & showDate ) )
	{
	    if ( 0 != ( format & showYear ) )
	    {
		n = d.getYear();
		if ( 0 != ( format & show2000 ) )
		{
		    if ( n >= 100 )
		    {
			a[i] = 2; i++;
			a[i] = 0; i++;
		    }
		    else
		    {
			a[i] = 1; i++;
			a[i] = 9; i++;
		    }
		}
		a[i] = n / 10 % 10; i++;
		a[i] = n % 10; i++;
	    }

	    n = d.getMonth();
	    a[i] = (n+1) / 10; i++;
	    a[i] = (n+1) % 10; i++;

	    n = d.getDate();
	    a[i] = n/10; i++;
	    a[i] = n%10; i++;

	    if ( 0 != ( format & showTime ) )
	    {
		a[i] = 12; i++;
	    }
	}

	if ( 0 != ( format & showTime ) )
	{
	    n = d.getHours();
	    if ( 0 != ( format & showAmPm ) )
	    {
		if ( n >= 12 )
		    pm = true;
		if ( n >= 12 )
		{
		    a[i] = (n-12)/10; i++;
		    a[i] = (n-12)%10; i++;
		}
		else
		{
		    a[i] = n / 10; i++;
		    a[i] = n % 10; i++;
		}
	    }
	    else
	    {
		a[i] = n / 10; i++;
		a[i] = n % 10; i++;
	    }

	    a[i] = 11; i++;
	    n = d.getMinutes();
	    a[i] = n / 10; i++;
	    a[i] = n % 10; i++;

	    if ( 0 != ( format & showSecond ) )
	    {
		a[i] = 11; i++;
		n = d.getSeconds();
		a[i] = n / 10; i++;
		a[i] = n % 10; i++;
	    }

	    if ( 0 != ( format & showAmPm ) )
	    {
		a[i] = pm ? 15 : 14; i++;
	    }
	}

	show( a, i );
    }

    public void paint( Graphics g ) {
	Rectangle r = g.getClipBounds();
	paintLed( g, leds, length, r.x, r.y );
    }

    public void update( Graphics g ) {
	paint( g );
    }

    public Dimension minimumSize() {
	return new Dimension( width*length+10, height+10 );
    }

    public Dimension preferredSize() {
	return minimumSize();
    }
}
