import java.applet.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

import ImageButton;
import LedPanel;

public class JavaSame extends Applet implements MouseListener, ItemListener, Runnable {
    String version = "Java Same version 1.0, Bug report: abbelf@263.net";

    int sample = 900, factor = 4975631, module = 197567;

    int rows = 16, cols = 20;
    int maxBlockNum = 5;

    int levels [][] =
    { { 8, 16, 4, 5 }, { 10, 20, 5, 20 },
      { 10, 20, 6, 30 }, { 12, 24, 9, 144 } };

    final int blockNum = 0xff;
    final int selected = 0x100;
    final int redrawing = 0x200;

    int remained;
    int sel = 0;

    ImageButton st_btn;
    LedPanel led, clock, counter;
    Choice choice;
    Label about, label1, label2, label3, label4;
    TextField text1, text2, text3, text4;

    Thread timerThread;
    Thread registerThread;
    URL registerURL;

    boolean gameStarted = false;

    int iconWidth=24, iconHeight=24;
    int a[][] = new int[cols][rows];

    long startTime;
    int timeTick = 0;
    long clickTime = 0;

    int titleHeight = 80;

    Image mimg, face;

    Panel title = new Panel();
    Rectangle content = new Rectangle();

    Random rand_seed = new Random();

    public void randomSame( long seed ) {
	Random rand = new Random( seed );
	int range = rows * cols;
	int i, j;

	a = new int[cols][rows];

	for ( i=0; i<cols; i++ )
	    for ( j=0; j<rows; j++ )
	    {
		a[i][j] = ( ( rand.nextInt() & 0x3fffffff ) % maxBlockNum ) + 1;
	    }

	remained = cols * rows;
    }

    public void draw3dRect( Graphics g, Rectangle r ) {
	g.setColor( Color.white );
	g.drawLine( r.x, r.y, r.x+r.width-1, r.y );
	g.drawLine( r.x, r.y, r.x, r.y+r.height-2 );

	g.setColor( Color.gray );
	g.drawLine( r.x+r.width-1, r.y+1, r.x+r.width-1, r.y+r.height-1 );
        g.drawLine( r.x+1, r.y+r.height-1, r.x+r.width-1, r.y+r.height-1 );
    }

    public void drawI3dRect( Graphics g, Rectangle r ) {
	g.setColor( Color.gray );
	g.drawLine( r.x, r.y, r.x+r.width-1, r.y );
	g.drawLine( r.x, r.y, r.x, r.y+r.height-2 );

	g.setColor( Color.white );
	g.drawLine( r.x+r.width-1, r.y+1, r.x+r.width-1, r.y+r.height-1 );
        g.drawLine( r.x+1, r.y+r.height-1, r.x+r.width-1, r.y+r.height-1 );
    }

    public void expandRect( Rectangle r, int n ) {
	r.x -= n;
	r.y -= n;
	r.width += n + n;
	r.height += n + n;
    }

    public Point getMouseRowCol( Point mp ) {
	Point p = content.getLocation();
	return new Point( ( mp.x - p.x ) / iconWidth,
			  ( mp.y - p.y ) / iconHeight );
    }

    public void paintIcon( Graphics g, Rectangle r, int x, int y ) {
	g.drawImage( mimg, r.x, r.y, r.x+r.width, r.y+r.height,
		     x*iconWidth, y*iconHeight, 
		     (x+1)*iconWidth, (y+1)*iconHeight, this );
    }

    public void paintSame( Graphics g, int x, int y ) {
	Rectangle r = new Rectangle( x * iconWidth + content.x, 
				     y * iconHeight + content.y, 
				     iconWidth, iconHeight );

	if ( gameStarted )
	    paintIcon( g, r, a[x][y] & blockNum, 
		       0 != ( a[x][y] & selected ) ? 1 : 0 );
	else
	    paintIcon( g, r, a[x][y] & blockNum, 2 );
    }

    public void copyCol( Graphics g, int dst, int src ) {
	g.copyArea( src * iconWidth + content.x, content.y,
		    iconWidth, rows * iconHeight,
		    (dst - src) * iconWidth, 0 );
    }

    public void paintSames( Graphics g ) {
	for ( int i=0; i<cols; i++ )
	    for ( int j=0; j<rows; j++ )
		paintSame( g, i, j );
    }

    public void setGameParams() {
	Dimension w = getSize();
	String str;

	int maxcols, maxrows, cols, rows, num;
	maxcols = ( w.width - 10 ) / iconWidth;
	maxrows = ( w.height - titleHeight - 12 ) / iconHeight;

	str = text1.getText();
	rows = Integer.valueOf( str ).intValue();
	str = text2.getText();
	cols = Integer.valueOf( str ).intValue();
	str = text3.getText();
	num = Integer.valueOf( str ).intValue();

	if ( rows < 5 )
	    rows = 5;
	else if ( rows > maxrows )
	    rows = maxrows;
	if ( cols < 5 )
	    cols = 5;
	else if ( cols > maxcols )
	    cols = maxcols;
	if ( num >= 10 )
	    num = 9;
	else if ( num <= 2 )
	    num = 3;

	setSameParams( rows, cols, num );

	this.cols = cols;
	this.rows = rows;
	this.maxBlockNum = num;
    }

    private void callRegisterCgi() {
	try 
	{
	    DataInputStream dis = 
		new DataInputStream( registerURL.openStream() );
	    byte b[] = new byte[256];

	    while( dis.read( b ) >= 0 )
		;
	}
	catch ( IOException ioe ) {}

	try {
	    Thread.sleep( 2000 );
	}
	catch ( InterruptedException ie ) {}

	if ( ! gameStarted )
	    st_btn.setIcon( 1 );
    }

    private void registerScore() {
	String level_name[] = { "easy", "medium", "hard", "very_hard" };
	int i;

	for ( i=0; i<4; i++ )
	{
	    if ( levels[i][0] == rows && levels[i][1] == cols
		 && levels[i][2] == maxBlockNum && remained <= levels[i][3] )
	    {
		st_btn.setIcon( 3 );

		URL doc = getDocumentBase();
		StringBuffer user_name = new StringBuffer( text4.getText() );
		int n = user_name.length();
		if ( n > 0 )
		{
		    for ( int j=0; j<n; j++ )
		    {
			char c = user_name.charAt(j);
			if ( !( c <= 'Z'&& c >= 'A' ) 
			     && !( c <= 'z' && c >='a' )
			     && !( c <= '9' && c >='0' ) )
			    user_name.setCharAt( j, '_' );
		    }
		}
		else
		    user_name = new StringBuffer( "Anonymous" );
		
		String str = "/cgi-bin/reg-msg?" 
		    + Integer.toString( ( ( (int)( System.currentTimeMillis() 
				   / 1000 ) / sample * factor ) & 0x3fffffff ) % module )
                    + "+" + "same." + level_name[i]
		    + "+" + Integer.toString( remained )
		    + "+" + user_name.toString();

		try {
		    registerURL = new URL( doc.getProtocol(), doc.getHost(), 
				       doc.getPort(), str );
		    registerThread = new Thread( this, "register" );
		    registerThread.start();
		}
		catch ( MalformedURLException me ) {}

		return;
	    }
	}
    }

    public void restartGame() {
	setGameParams();

	randomSame( rand_seed.nextLong() );
	Dimension d = new Dimension( iconWidth*cols, iconHeight*rows );
	Dimension w = getSize();
	content.setBounds( (w.width-d.width)/2, 
			   (w.height-d.height-titleHeight)/2 + titleHeight, 
			   d.width, d.height );

	led.showInt( remained );

	gameStarted = true;
	startTime = System.currentTimeMillis();
	st_btn.setIcon( 0 );

	repaint();
    }

    public void stopGame( boolean suc ) {
	Graphics g = getGraphics();

	st_btn.setIcon( suc ? 1 : 2 );

	gameStarted = false;

	if ( suc )
	    registerScore();

	repaint();
    }

    public void init() {
	MediaTracker tracker = new MediaTracker(this);
	getGraphics().drawString( "Loading...", 0, 0 );
	mimg = getImage( getDocumentBase(), "same.gif" );
	face = getImage( getDocumentBase(), "face.gif" );
	tracker.addImage( mimg, 0 );
	tracker.addImage( face, 1 );
	try
	{
	    tracker.waitForAll();
	}
	catch( InterruptedException e ) {}

	led = new LedPanel( this, 4 );
	clock = new LedPanel( this, 5 );
	counter = new LedPanel( this, 3 );

	st_btn = new ImageButton( face, 4 );

	about = new Label( version );
	about.setAlignment( Label.CENTER );

	choice = new Choice();
	choice.addItem( "Easy" );
	choice.addItem( "Medium" );
	choice.addItem( "Hard" );
	choice.addItem( "Very Hard" );
	choice.addItem( "Custom" );

	label1 = new Label( "Rows" );
	label1.setAlignment( Label.RIGHT );
	label2 = new Label( "Columns" );
	label2.setAlignment( Label.RIGHT );
	label3 = new Label( "Styles" );
	label3.setAlignment( Label.RIGHT );
	label4 = new Label( "Your name" );
	label4.setAlignment( Label.RIGHT );

	text1 = new TextField( 2 );
	text2 = new TextField( 2 );
	text3 = new TextField( 3 );
	text4 = new TextField( 10 );
    }

    public void start() {
	setBackground( Color.lightGray );

	setLayout( null );

	add( title );

	title.setBounds( new Rectangle( 5, 5, getSize().width-10, titleHeight-5 ) );
	title.setBackground( Color.lightGray );
	title.setLayout( new FlowLayout( FlowLayout.CENTER ) );

	title.add( led );
	title.add( st_btn );
	title.add( counter );
	title.add( about );
	title.add( clock );
	title.add( choice );
	title.add( label1 );
	title.add( text1 );
	title.add( label2 );
	title.add( text2 );
	title.add( label3 );
	title.add( text3 );
	title.add( label4 );
	title.add( text4 );

	st_btn.addMouseListener( this );
	choice.addItemListener( this );
	addMouseListener( this );

	choice.select( 1 );
	setSameParams( levels[1][0], levels[1][1], levels[1][2], false );

	restartGame();

	if ( timerThread == null )
	{
	    timerThread = new Thread( this, "timer" );
	    timerThread.start();
	}
    }

    public void stop() {
	timerThread.stop();
	timerThread = null;
    }

    public void drawTitle( Graphics g ) {
	Rectangle r;
	r = title.getBounds();
	expandRect( r, 1 );
	drawI3dRect( g, r );
	r = new Rectangle( content );
	expandRect( r, 1 );
	drawI3dRect( g, r );
	expandRect( r, 1 );
	drawI3dRect( g, r );
	draw3dRect( g, new Rectangle( 2, 2, getSize().width-4, getSize().height-4 ) );
    }

    public void paintRemained( Graphics g ) {
	led.showInt( remained );
    }

    public void paint( Graphics g ) {
	drawTitle( g );
	paintSames( g );
	paintRemained( g );
    }

    public void checkStop() {
	int i, j, n;
	for ( i=0; i<cols-1; i++ )
	    for ( j=0; j<rows; j++ )
	    {
		n = a[i][j] & blockNum;
		if ( 0 == n )
		    continue;
		if ( n == ( a[i+1][j] & blockNum ) )
		    return;
	    }
	for ( i=0; i<cols; i++ )
	    for ( j=0; j<rows-1; j++ )
	    {
		n = a[i][j] & blockNum;
		if ( 0 == n )
		    continue;
		if ( n == ( a[i][j+1] & blockNum ) )
		    return;
	    }
	
	stopGame( true );
    }

    public void unselectBlocks() {
	int i, j;
	Graphics g = getGraphics();
	for ( i=0; i<cols; i++ )
	    for ( j=0; j<rows; j++ )
		if ( 0 != ( a[i][j] & selected ) )
		{
		    a[i][j] &= ~selected;
		    paintSame( g, i, j );
		}
	sel = 0;
    }

    public void removeSelectedBlocks() {
	int i, j, k, fs, nc, count=0;
	Graphics g = getGraphics();

	for ( i=0; i<cols; i++ )
	{
	    fs = -1;
	    for ( j=rows-1, k=rows-1; j>=0; j-- )
	    {
		if ( 0 == ( a[i][j] & blockNum ) )
		    break;

		if ( 0 != ( a[i][j] & selected ) )
		{
		    if ( fs < 0 )
			fs = j;
		    count++;
		}
		else
		{
		    a[i][k] = a[i][j];
		    k--;
		}
	    }
	    for ( ; k>j; k-- )
		a[i][k] = 0;
	    for ( k=fs; k>j; k-- )
		paintSame( g, i, k );
	}

	for ( nc = cols-1; nc >= 0; nc-- )
	    if ( 0 != ( a[nc][rows-1] & blockNum ) )
		break;

	for ( i=0, k=0; i<=nc; i++ )
	{
	    if ( i != k )
	    {
		for ( j=0; j<rows; j++ )
		    a[k][j] = a[i][j];
		copyCol( g, k, i );
	    }
	    if ( 0 != ( a[i][rows-1] & blockNum ) )
		k++;
	}

	for ( ; k<=nc; k++ )
	    for ( j=0; j<rows; j++ )
	    {
		a[k][j] = 0;
		paintSame( g, k, j );
	    }

	remained -= count;
	paintRemained( g );
	sel = 0;

	checkStop();
    }

    public void selectBlocks( Graphics g, int x, int y, int n ) {
	if ( ( a[x][y] & blockNum ) == n && 0 == ( a[x][y] & selected ) )
	{
	    a[x][y] |= selected;
	    paintSame( g, x, y );
	    sel++;
	    
	    if ( x > 0 )
		selectBlocks( g, x-1, y, n );
	    if ( x < cols-1 )
		selectBlocks( g, x+1, y, n );
	    if ( y > 0 )
		selectBlocks( g, x, y-1, n );
	    if ( y < rows-1 )
		selectBlocks( g, x, y+1, n );
	}
    }

    public void processMouseEvent( boolean dblclk, int x, int y ) {
	if ( 0 == ( a[x][y] & blockNum ) )
	    return;

	if ( dblclk )
	{
	    if ( 0 != ( a[x][y] & selected ) && sel > 1 )
		removeSelectedBlocks();
	}
	else
	{
	    if ( 0 == ( a[x][y] & selected ) )
	    {
		unselectBlocks();
		selectBlocks( getGraphics(), x, y, a[x][y] & blockNum );
	    }
	}
    }

    public void processTimerEvent() {
	long tm = System.currentTimeMillis();
	if ( gameStarted && startTime > 0 )
	    counter.showInt( (int)((tm - startTime)/1000) );
	if ( 0 == timeTick % 10 )
	    clock.showClock( tm, LedPanel.showTime );
	timeTick++;
    }

    public void mouseClicked( MouseEvent e ) {
	if ( st_btn == e.getComponent() )
	    restartGame();
    }
    public void mousePressed( MouseEvent e ) {
	if ( gameStarted && this == e.getComponent() )
	    mouseEvent( e );
    }
    public void mouseReleased( MouseEvent e ) {}
    public void mouseEntered( MouseEvent e ) {}
    public void mouseExited( MouseEvent e ) {}

    public void mouseEvent( MouseEvent e ) {
	Point mp = e.getPoint();

	if ( content.contains( mp ) )
	{
	    Point p = getMouseRowCol( mp );
	    if ( p.x < cols && p.y < rows )
	    {
		long tm = System.currentTimeMillis();
		boolean b = tm < clickTime + 500;
		processMouseEvent( b, p.x, p.y );
		if ( b )
		    clickTime = 0;
		else
		    clickTime = tm;
	    }
	}
    }

    private void setSameParams( int rows, int cols, int num ) {
	if ( rows > 0 )
	    text1.setText( Integer.toString( rows ) );
	if ( cols > 0 )
	    text2.setText( Integer.toString( cols ) );
	if ( num > 0 )
	    text3.setText( Integer.toString( num ) );
    }

    private void setSameParams( int rows, int cols, int num, boolean enabled ) {
	setSameParams( rows, cols, num );
	text1.setEnabled( enabled );
	text2.setEnabled( enabled );
	text3.setEnabled( enabled );
    }

    public void itemStateChanged( ItemEvent e ) {
	if ( choice == e.getItemSelectable() ) 
	{
	    int n = choice.getSelectedIndex();
	    switch( n )
	    {
	    case 0:
	    case 1:
	    case 2:
	    case 3:
		setSameParams( levels[n][0], levels[n][1], levels[n][2], false );
		break;
	    case 4:
		setSameParams( 0, 0, 0, true );
		break;
	    }
	}
    }

    public void run() {
	String name = Thread.currentThread().getName();
	if ( name.equals( "timer" ) )
	{
	    while ( timerThread != null )
	    {
		processTimerEvent();
		try 
		{
		    Thread.sleep( 1000 );
		}
		catch( InterruptedException e ) {}
	    }
	}
	else if ( name.equals( "register" ) )
	{
	    callRegisterCgi();
	} 
    }
}
