import java.applet.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

import ImageButton;
import LedPanel;

public class JavaMine extends Applet implements MouseListener, ItemListener, Runnable {
    String version = "Java Mine version 1.1.2, Bug report: abbelf@263.net";

    int sample = 900, factor = 4975631, module = 197567;

    int rows = 16, cols = 20;
    int maxMineNum = 10;

    int levels [][] =
    { { 8, 8, 10, 15000 }, { 16, 16, 40, 100000 },
      { 16, 30, 99, 200000 }, { 18, 35, 130, 300000 } };

    ImageButton st_btn;
    LedPanel led, clock, counter;
    Choice choice;
    Label about, label1, label2, label3, label4;
    TextField text1, text2, text3, text4;

    Thread timerThread;
    Thread registerThread;
    URL registerURL;

    final static int hasMine = 0x100;
    final static int beMined = 0x200;
    final static int beMarked = 0x400;
    final static int beQuoted = 0x800;
    final static int mineNum = 0xff;

    boolean gameStarted = false;

    int unmarked = 0;
    int unmined = 0;
    int marked = 0;

    int iconWidth=16, iconHeight=16;
    int a[][] = new int[cols][rows];

    long startTime;
    int timeTick = 0;

    int titleHeight = 80;

    Image mimg, face;

    boolean mk1 = false, mk3 = false;

    Panel title = new Panel();
    Rectangle content = new Rectangle();

    Random rand_seed = new Random();

    public void randomMine( long seed, int n ) {
	Random rand = new Random( seed );
	int range = rows * cols;
	int i, j;

	if ( n >= range )
	    return;

	unmarked = n;
	unmined = range;
	marked = 0;

	a = new int[cols][rows];

	for ( i=0; i<cols; i++ )
	    for ( j=0; j<rows; j++ )
		a[i][j] = 0;

	for ( ; n>0; )
	{
	    i = ( rand.nextInt() & 0x3fffffff )  % range;
	    if ( 0 == ( a[i%cols][i/cols] & hasMine ) )
	    {
		a[i%cols][i/cols] |= hasMine;
		n--;
	    }
	}
    }

    public void draw3dRect( Graphics g, Rectangle r ) {
	g.setColor( Color.white );
	g.drawLine( r.x, r.y, r.x+r.width-1, r.y );
	g.drawLine( r.x, r.y, r.x, r.y+r.height-2 );

	g.setColor( Color.gray );
	g.drawLine( r.x+r.width-1, r.y+1, r.x+r.width-1, r.y+r.height-1 );
        g.drawLine( r.x+1, r.y+r.height-1, r.x+r.width-1, r.y+r.height-1 );
    }

    public void drawI3dRect( Graphics g, Rectangle r ) {
	g.setColor( Color.gray );
	g.drawLine( r.x, r.y, r.x+r.width-1, r.y );
	g.drawLine( r.x, r.y, r.x, r.y+r.height-2 );

	g.setColor( Color.white );
	g.drawLine( r.x+r.width-1, r.y+1, r.x+r.width-1, r.y+r.height-1 );
        g.drawLine( r.x+1, r.y+r.height-1, r.x+r.width-1, r.y+r.height-1 );
    }

    public void expandRect( Rectangle r, int n ) {
	r.x -= n;
	r.y -= n;
	r.width += n + n;
	r.height += n + n;
    }

    public Point getMouseRowCol( Point mp ) {
	Point p = content.getLocation();
	return new Point( ( mp.x - p.x ) / iconWidth,
			  ( mp.y - p.y ) / iconHeight );
    }

    public void paintIcon( Graphics g, Rectangle r, int n ) {
	g.drawImage( mimg, r.x, r.y, r.x+r.width, r.y+r.height,
		     n*iconWidth, 0, (n+1)*iconWidth, iconHeight, this );
    }

    public void paintMine( Graphics g, int x, int y ) {
	Rectangle r = new Rectangle( x * iconWidth + content.x, 
				     y * iconHeight + content.y, 
				     iconWidth, iconHeight );

	if ( 0 != ( a[x][y] & beMined ) )
	{
	    if ( 0 != ( a[x][y] & hasMine ) )
		paintIcon( g, r, 9 );
	    else if ( 0 != ( a[x][y] & beMarked ) )
		paintIcon( g, r, 10 );
	    else
		paintIcon( g, r, a[x][y]&mineNum );
	}
	else if ( 0 != ( a[x][y] & beMarked ) )
	{
	    paintIcon( g, r, 12 );
	}
	else if ( 0 != ( a[x][y] & beQuoted ) )
	{
	    paintIcon( g, r, 13 );
	}
	else
	{
	    paintIcon( g, r, 11 );
	}
    }

    public void paintUnmarked( Graphics g ) {
	led.showInt( unmarked );
    }

    public int countMineByBit( int x, int y, int b ) {
	int n = 0;
	if ( x > 0 && y > 0 && 0 != ( a[x-1][y-1] & b ) )
	    n++;
	if ( y > 0 && 0 != ( a[x][y-1] & b ) )
	    n++;
	if ( x < cols-1 && y > 0 && 0 != ( a[x+1][y-1] & b ) )
	    n++;
	if ( x > 0 && 0 != ( a[x-1][y] & b ) )
	    n++;
	if ( x < cols-1 && 0 != ( a[x+1][y] & b ) )
	    n++;
	if ( x > 0 && y < rows-1 && 0 != ( a[x-1][y+1] & b ) )
	    n++;
	if ( y < rows-1 && 0 != ( a[x][y+1] & b ) )
	    n++;
	if ( x < cols-1 && y < rows-1 && 0 != ( a[x+1][y+1] & b ) )
	    n++;
	return n;
    }

    public int countMine( int x, int y ) {
	return countMineByBit( x, y, hasMine );
    }

    public int countMineOrMarked( int x, int y ) {
	return countMineByBit( x, y, beMarked );
    }

    public void miningRound( int x, int y ) {
	if ( x > 0 )
	{
	    if ( 0 == (a[x-1][y]&beMarked) )
		mining( x-1, y );
	    if ( y > 0 )
		if ( 0 == (a[x-1][y-1]&beMarked) )
		    mining( x-1, y-1 );
	    if ( y < rows-1 )
		if ( 0 == (a[x-1][y+1]&beMarked) )
		    mining( x-1, y+1 );
	}
	if ( x < cols-1 )
	{
	    if ( 0 == (a[x+1][y]&beMarked) )
		mining( x+1, y );
	    if ( y > 0 )
		if ( 0 == (a[x+1][y-1]&beMarked) )
		    mining( x+1, y-1 );
	    if ( y < rows-1 )
		if ( 0 == (a[x+1][y+1]&beMarked) )
		    mining( x+1, y+1 );
	}
	if ( y > 0 )
	    if ( 0 == (a[x][y-1]&beMarked) )
		mining( x, y-1 );
	if ( y < rows-1 )
	    if ( 0 == (a[x][y+1]&beMarked) )
		mining( x, y+1 );
    }

    public void mining( int x, int y ) {
	if ( x < 0 || x >= cols || y < 0 || y >= rows )
	    return;
	if ( 0 != ( a[x][y] & beMined ) )
	    return;
	a[x][y] |= beMined;
	a[x][y] &= ~beQuoted;
	if ( 0 == ( a[x][y] & hasMine ) )
	{
	    int i = countMine( x, y );
	    a[x][y] |= i;
	    if ( 0 == i )
	    {
		miningRound( x, y );
	    }
	}
        paintMine( getGraphics(), x, y );

	unmined--;

	if ( 0 == startTime )
	    startTime = System.currentTimeMillis();

	if ( 0 != ( a[x][y] & hasMine ) )
	    stopGame( false );
	else if ( unmined == marked + unmarked )
	    stopGame( true );
    }

    public void marking( int x, int y ) {
	if ( x < 0 || x >= cols || y < 0 || y >= rows || 0 != ( a[x][y] & beMined ) )
	    return;
	Graphics g = getGraphics();

	if ( 0 != ( a[x][y] & beMarked ) )
	{
	    a[x][y] |= beQuoted;
	    a[x][y] &= ~beMarked;
	    unmarked++;
	    marked--;
	    paintUnmarked( g );
	}
	else if ( 0 != ( a[x][y] & beQuoted ) )
	{
	    a[x][y] &= ~beQuoted;
	}
	else
	{
	    a[x][y] |= beMarked;
	    unmarked--;
	    marked++;
	    paintUnmarked( g );
	}
	paintMine( g, x, y );
    }

    public void paintMines( Graphics g ) {
	for ( int i=0; i<cols; i++ )
	    for ( int j=0; j<rows; j++ )
		paintMine( g, i, j );
    }

    public void setGameParams() {
	Dimension w = getSize();
	String str;

	int maxcols, maxrows, cols, rows, num;
	maxcols = ( w.width - 10 ) / iconWidth;
	maxrows = ( w.height - titleHeight - 12 ) / iconHeight;

	str = text1.getText();
	rows = Integer.valueOf( str ).intValue();
	str = text2.getText();
	cols = Integer.valueOf( str ).intValue();
	str = text3.getText();
	num = Integer.valueOf( str ).intValue();

	if ( rows < 5 )
	    rows = 5;
	else if ( rows > maxrows )
	    rows = maxrows;
	if ( cols < 5 )
	    cols = 5;
	else if ( cols > maxcols )
	    cols = maxcols;
	if ( num < 1 || num > cols * rows * 2 / 3 )
	    num = cols * rows * 2 / 3;

	setMineParams( rows, cols, num );

	this.cols = cols;
	this.rows = rows;
	this.maxMineNum = num;
    }

    private void callRegisterCgi() {
	try 
	{
	    DataInputStream dis = 
		new DataInputStream( registerURL.openStream() );
	    byte b[] = new byte[256];

	    while( dis.read( b ) >= 0 )
		;
	}
	catch ( IOException ioe ) {}

	try {
	    Thread.sleep( 2000 );
	}
	catch ( InterruptedException ie ) {}

	if ( ! gameStarted )
	    st_btn.setIcon( 1 );
    }

    private void registerScore() {
	String level_name[] = { "easy", "medium", "hard", "very_hard" };
	int i;
	long tm = System.currentTimeMillis() - startTime;
	if ( tm > 1000000 || tm <= 0 )
	    return;
	for ( i=0; i<4; i++ )
	{
	    if ( levels[i][0] == rows && levels[i][1] == cols
		 && levels[i][2] == maxMineNum && tm <= levels[i][3] )
	    {
		st_btn.setIcon( 3 );

		URL doc = getDocumentBase();
		StringBuffer user_name = new StringBuffer( text4.getText() );
		int n = user_name.length();
		if ( n > 0 )
		{
		    for ( int j=0; j<n; j++ )
		    {
			char c = user_name.charAt(j);
			if ( !( c <= 'Z'&& c >= 'A' ) 
			     && !( c <= 'z' && c >='a' )
			     && !( c <= '9' && c >='0' ) )
			    user_name.setCharAt( j, '_' );
		    }
		}
		else
		    user_name = new StringBuffer( "Anonymous" );
		
		String str = "/cgi-bin/reg-msg?" 
		    + Integer.toString( ( ( (int)( System.currentTimeMillis() 
				   / 1000 ) / sample * factor ) & 0x3fffffff ) % module )
                    + "+" + "mine." + level_name[i]
		    + "+" + Double.toString( ((double)tm) / 1000.0 )
		    + "+" + user_name.toString();

		try {
		    registerURL = new URL( doc.getProtocol(), doc.getHost(), 
				       doc.getPort(), str );
		    registerThread = new Thread( this, "register" );
		    registerThread.start();
		}
		catch ( MalformedURLException me ) {}

		return;
	    }
	}
    }

    public void restartGame() {
	setGameParams();

	randomMine( rand_seed.nextLong(), maxMineNum );
	Dimension d = new Dimension( iconWidth*cols, iconHeight*rows );
	Dimension w = getSize();
	content.setBounds( (w.width-d.width)/2, 
			   (w.height-d.height-titleHeight)/2 + titleHeight, 
			   d.width, d.height );
	startTime = 0;
	counter.showInt( 0 );

	gameStarted = true;
	st_btn.setIcon( 0 );

	repaint();
    }

    public void stopGame( boolean suc ) {
	Graphics g = getGraphics();

	st_btn.setIcon( suc ? 1 : 2 );

	gameStarted = false;

	if ( suc )
	    registerScore();

	for ( int i=0; i<cols; i++ )
	    for ( int j=0; j<rows; j++ )
	    {
		if ( 0 != ( a[i][j] & hasMine ) )
		{
		    if ( suc )
		    {
			if ( 0 == ( a[i][j] & beMarked ) )
			{
			    unmarked--;
			    marked++;
			    a[i][j] |= beMarked;
			    a[i][j] &= ~(beQuoted);
			}
		    }
		    else
		    {
			a[i][j] |= beMined;
			a[i][j] &= ~(beMarked|beQuoted);
		    }
		    paintMine( g, i, j );
		}
	    }

	paintUnmarked( g );
    }

    public void init() {
	MediaTracker tracker = new MediaTracker(this);
	getGraphics().drawString( "Loading...", 0, 0 );
	mimg = getImage( getDocumentBase(), "mine.gif" );
	face = getImage( getDocumentBase(), "face.gif" );
	tracker.addImage( mimg, 0 );
	tracker.addImage( face, 1 );
	try
	{
	    tracker.waitForAll();
	}
	catch( InterruptedException e ) {}

	led = new LedPanel( this, 3 );
	clock = new LedPanel( this, 5 );
	counter = new LedPanel( this, 3 );

	st_btn = new ImageButton( face, 4 );

	about = new Label( version );
	about.setAlignment( Label.CENTER );

	choice = new Choice();
	choice.addItem( "Easy" );
	choice.addItem( "Medium" );
	choice.addItem( "Hard" );
	choice.addItem( "Very Hard" );
	choice.addItem( "Custom" );

	label1 = new Label( "Rows" );
	label1.setAlignment( Label.RIGHT );
	label2 = new Label( "Columns" );
	label2.setAlignment( Label.RIGHT );
	label3 = new Label( "Mines" );
	label3.setAlignment( Label.RIGHT );
	label4 = new Label( "Your name" );
	label4.setAlignment( Label.RIGHT );

	text1 = new TextField( 2 );
	text2 = new TextField( 2 );
	text3 = new TextField( 3 );
	text4 = new TextField( 10 );
    }

    public void start() {
	setBackground( Color.lightGray );

	setLayout( null );

	add( title );

	title.setBounds( new Rectangle( 5, 5, getSize().width-10, titleHeight-5 ) );
	title.setBackground( Color.lightGray );
	title.setLayout( new FlowLayout( FlowLayout.CENTER ) );

	title.add( led );
	title.add( st_btn );
	title.add( counter );
	title.add( about );
	title.add( clock );
	title.add( choice );
	title.add( label1 );
	title.add( text1 );
	title.add( label2 );
	title.add( text2 );
	title.add( label3 );
	title.add( text3 );
	title.add( label4 );
	title.add( text4 );

	st_btn.addMouseListener( this );
	choice.addItemListener( this );
	addMouseListener( this );

	choice.select( 1 );
	setMineParams( levels[1][0], levels[1][1], levels[1][2], false );

	restartGame();

	if ( timerThread == null )
	{
	    timerThread = new Thread( this, "timer" );
	    timerThread.start();
	}
    }

    public void stop() {
	timerThread.stop();
	timerThread = null;
    }

    public void drawTitle( Graphics g ) {
	Rectangle r;
	r = title.getBounds();
	expandRect( r, 1 );
	drawI3dRect( g, r );
	r = new Rectangle( content );
	expandRect( r, 1 );
	drawI3dRect( g, r );
	expandRect( r, 1 );
	drawI3dRect( g, r );
	draw3dRect( g, new Rectangle( 2, 2, getSize().width-4, getSize().height-4 ) );
    }

    public void paint( Graphics g ) {
	drawTitle( g );
	paintMines( g );
	paintUnmarked( g );
    }

    public void autoMining( int x, int y ) {
	if ( 0 != ( a[x][y] & mineNum ) && (a[x][y]&mineNum) == countMineOrMarked(x,y) )
	    miningRound( x, y );
    }

    public void processMouseEvent( MouseEvent e, boolean p, int x, int y ) {
	int m = e.getModifiers();
	if ( 0 != ( m & MouseEvent.BUTTON3_MASK ) )
	{
	    if ( p )
	    {
		marking( x, y );
		mk3 = true;
	    }
	    else
	    {
		if ( mk1 && mk3 )
		    autoMining( x, y );
		mk1 = mk3 = false;
	    }
	}
	if ( 0 != ( m & MouseEvent.BUTTON1_MASK ) )
	{
	    if ( p )
	    {
		mk1 = true;
	    }
	    else
	    {
		if ( 0 == ( a[x][y] & beMarked ) && !mk3 && mk1 )
		    mining( x, y );
		mk1 = mk3 = false;
	    }
	}
	if ( 0 != ( m & MouseEvent.BUTTON2_MASK ) )
	{
	    if ( p )
		;
	    else
		autoMining( x, y );
	}
    }

    public void processTimerEvent() {
	long tm = System.currentTimeMillis();
	if ( gameStarted && startTime > 0 )
	    counter.showInt( (int)((tm - startTime)/1000) );
	if ( 0 == timeTick % 10 )
	    clock.showClock( tm, LedPanel.showTime );
	timeTick++;
    }

    public void mouseClicked( MouseEvent e ) {
	if ( st_btn == e.getComponent() )
	    restartGame();
    }
    public void mousePressed( MouseEvent e ) {
	if ( gameStarted && this == e.getComponent() )
	    mouseEvent( e, true );
    }
    public void mouseReleased( MouseEvent e ) {
	if ( gameStarted && this == e.getComponent() )
	    mouseEvent( e, false );
    }
    public void mouseEntered( MouseEvent e ) {}
    public void mouseExited( MouseEvent e ) {}

    public void mouseEvent( MouseEvent e, boolean isPress ) {
	Point mp = e.getPoint();

	if ( content.contains( mp ) )
	{
	    Point p = getMouseRowCol( mp );
	    if ( p.x < cols && p.y < rows )
	    {
		processMouseEvent( e, isPress, p.x, p.y );
	    }
	}
    }

    private void setMineParams( int rows, int cols, int num ) {
	if ( rows > 0 )
	    text1.setText( Integer.toString( rows ) );
	if ( cols > 0 )
	    text2.setText( Integer.toString( cols ) );
	if ( num > 0 )
	    text3.setText( Integer.toString( num ) );
    }

    private void setMineParams( int rows, int cols, int num, boolean enabled ) {
	setMineParams( rows, cols, num );
	text1.setEnabled( enabled );
	text2.setEnabled( enabled );
	text3.setEnabled( enabled );
    }

    public void itemStateChanged( ItemEvent e ) {
	if ( choice == e.getItemSelectable() ) 
	{
	    int n = choice.getSelectedIndex();
	    switch( n )
	    {
	    case 0:
	    case 1:
	    case 2:
	    case 3:
		setMineParams( levels[n][0], levels[n][1], levels[n][2], false );
		break;
	    case 4:
		setMineParams( 0, 0, 0, true );
		break;
	    }
	}
    }

    public void run() {
	String name = Thread.currentThread().getName();
	if ( name.equals( "timer" ) )
	{
	    while ( timerThread != null )
	    {
		processTimerEvent();
		try 
		{
		    Thread.sleep( 1000 );
		}
		catch( InterruptedException e ) {}
	    }
	}
	else if ( name.equals( "register" ) )
	{
	    callRegisterCgi();
	} 
    }
}
