import java.awt.*;
import java.awt.event.*;

public class ImageButton extends Canvas implements MouseListener {
    
    private Image image;
    Dimension iconDim = new Dimension( 16, 16 );
    int iconNum = 1;
    int iconCur = 0;
    boolean pressed = false;
    
    public ImageButton() {
	addMouseListener( this );
    }

    public ImageButton( Image image, int n ) {
	setImage( image, n );
	addMouseListener( this );
    }

    public Image getImage() {
	return image;
    }

    public void setImage( Image image, int n ) {
	if ( n <= 0 )
	    return;

	if ( !image.equals( this.image ) || n != iconNum ) 
	{
	    this.image = image;
	    iconNum = n;
	    iconCur = 0;
	    if ( image != null )
		iconDim.setSize( image.getWidth(this)/n, image.getHeight(this) );
	    else
		iconDim.setSize( 16, 16 );

	    repaint();
	}
    }

    public void setIcon( int i ) {
	if ( i != iconCur ) 
	{
	    iconCur = i;
	    repaint();
	}
    }

    public Dimension getMinimumSize() {
	return new Dimension( iconDim.width+4, iconDim.height+4 );
    }

    public Dimension getPreferredSize() {
	return getMinimumSize();
    }

    public void paint( Graphics g ) {
	Color b = getBackground();
	Rectangle r = g.getClipBounds();

	super.paint(g);

	// Draw the image.
	// Scale it so it fits in the clip rectangle and centre it.
	if( image != null && r.width>4 && r.height>4 ) 
	{
	    g.drawImage ( image, 
			  (r.width-iconDim.width)/2, (r.height-iconDim.height)/2,
			  (r.width+iconDim.width)/2, (r.height+iconDim.height)/2,
			  iconCur*iconDim.width, 0, 
			  (iconCur+1)*iconDim.width, iconDim.height,
			  this );
	}

	// Draw the button bevel.
	// We need to draw the lines twice to make them thicker.
	g.setColor( pressed ? b.darker() : b.brighter() );
	
	g.drawLine( 0, r.height-1, 0, 0 );
	g.drawLine( 1, r.height-2, 1, 1 );
	g.drawLine( 0, 0, r.width-1, 0 );
	g.drawLine( 1, 1, r.width-2, 1 );
	g.setColor( pressed ? b.brighter() : b.darker() );
	g.drawLine( r.width-1, 0, r.width-1, r.height-1 );
	g.drawLine( r.width-2, 1, r.width-2, r.height-2 );
	g.drawLine( r.width-1, r.height-1, 0, r.height-1 );
	g.drawLine( r.width-2, r.height-2, 1, r.height-2 );
     }

    public void mouseClicked( MouseEvent e ) {}
    public void mousePressed( MouseEvent e ) {
	if ( this == e.getComponent() && !pressed )
	{
	    pressed = true;
	    repaint();
	}
    }
    public void mouseReleased( MouseEvent e ) {
	if ( this == e.getComponent() && pressed )
	{
	    pressed = false;
	    repaint();
	}
    }
    public void mouseEntered( MouseEvent e ) {}
    public void mouseExited( MouseEvent e ) {
	if ( this == e.getComponent() && pressed )
	{
	    pressed = false;
	    repaint();
	}
    }

}

