/*
 * Decompiled with CFR 0.152.
 */
package jamaica;

public class Range
implements Cloneable {
    private int number;
    private int base;
    private int stride;

    public Range(int first, int last) {
        this.base = first;
        this.number = last - this.base + 1;
        if (this.number < 0) {
            this.number = -this.number;
            this.stride = -1;
        } else {
            this.stride = 1;
        }
    }

    public Range(int first, int size, int interval) {
        this.base = first;
        this.number = size;
        this.stride = interval;
    }

    public final int first() {
        return this.base;
    }

    public final int size() {
        return this.number;
    }

    public final int last() {
        return this.base + (this.number - 1) * this.stride;
    }

    public final int next(int n) {
        return n + this.stride;
    }

    public final int interval() {
        return this.stride;
    }

    public final boolean contain(int n) {
        n -= this.base;
        if (this.stride >= 0) {
            return n >= 0 && n < this.number * this.stride && 0 == n % this.stride;
        }
        return n <= 0 && n > this.number * this.stride && 0 == -n % -this.stride;
    }

    public final boolean in(int lower, int upper) {
        if (this.stride >= 0) {
            return this.base >= lower && (this.number - 1) * this.stride + this.base <= upper;
        }
        return this.base <= upper && (this.number - 1) * this.stride + this.base >= lower;
    }

    public int inf() {
        if (this.stride >= 0) {
            return this.base;
        }
        return this.base + (this.number - 1) * this.stride;
    }

    public int sup() {
        if (this.stride <= 0) {
            return this.base;
        }
        return this.base + (this.number - 1) * this.stride;
    }

    public boolean empty() {
        return this.number <= 0;
    }

    public Range intersect(Range x) {
        throw new UnsupportedOperationException("intersect");
    }

    public Range unionClosure(Range x) {
        throw new UnsupportedOperationException("unionClosure");
    }

    public Range sub(Range x) {
        throw new UnsupportedOperationException("sub");
    }

    public String toString() {
        if (1 == this.stride) {
            if (1 == this.number) {
                return Integer.toString(this.base);
            }
            return Integer.toString(this.base) + ":" + this.last();
        }
        return Integer.toString(this.base) + ":" + (this.stride >= 0 ? "+" + this.stride : "-" + -this.stride) + ":" + this.number;
    }
}

