/*
 * Decompiled with CFR 0.152.
 */
package jamaica;

import jamaica.Matrix;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Plotter
extends JPanel {
    JFrame frame;
    Font tick_font;
    Font label_font;
    static final int nr_curve = 16;
    Insets border = new Insets(32, 64, 32, 64);
    int tick_width = 6;
    int grid_density = 100;
    int tick_density = 5;
    Color tick_color = new Color(0x555555);
    Color grid_color = new Color(0xAAAAAA);
    Color border_color = new Color(0xBBBB00);
    Color[] def_color = new Color[16];
    String xlabel = null;
    String ylabel = null;
    float[] range;
    float[][] curve = new float[16][];
    Color[][] curve_color = new Color[16][];
    int[] curve_flags = new int[16];
    static final int FL_STYLEMASK = 240;
    static final int FL_LINESTYLE = 128;
    static final int FL_POINTSTYLE = 64;
    static final int FL_RANGEMASK = 3;
    private static int frame_counter;
    private static final double log10;

    public Plotter(JFrame frame) {
        this.frame = frame;
        this.tick_font = new Font("Monospaced", 0, 10);
        this.label_font = new Font(null, 0, 12);
        this.range = new float[24];
        int i = 0;
        while (i < 24) {
            this.range[i] = 0.0f;
            this.range[i + 1] = 1.0f;
            i += 2;
        }
    }

    public static Plotter create(String title, int width, int height) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame(title);
        Plotter pane = new Plotter(frame);
        frame.getContentPane().add((Component)pane, "Center");
        ++frame_counter;
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame_counter--;
            }
        });
        pane.newsize(width, height);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        return pane;
    }

    private void newsize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.frame.pack();
    }

    private boolean addData(Matrix mat, int idx) {
        int m = mat.height();
        int n = mat.width();
        if (1 == n) {
            return false;
        }
        this.curve[idx] = new float[m + m + m];
        int i = 0;
        while (i < m) {
            this.curve[idx][i + i + i] = (float)mat.get(i, 0);
            this.curve[idx][i + i + i + 1] = (float)mat.get(i, 1);
            if (n == 3) {
                this.curve[idx][i + i + i + 2] = (float)mat.get(i, 2);
            }
            ++i;
        }
        return true;
    }

    private boolean addData(double[] x, Matrix mat, int idx) {
        int m = mat.height();
        int n = mat.width();
        int j = 0;
        while (j < n) {
            this.curve[idx + j] = new float[m + m + m];
            int i = 0;
            while (i < m) {
                this.curve[idx + j][i + i + i] = (float)x[i];
                this.curve[idx + j][i + i + i + 1] = (float)mat.get(i, j);
                ++i;
            }
            ++j;
        }
        return true;
    }

    private void addColorTable(int[] colortbl, int idx) {
        if (null != colortbl) {
            this.curve_color[idx] = new Color[colortbl.length];
            int i = 0;
            while (i < colortbl.length) {
                this.curve_color[idx][i] = new Color(colortbl[i]);
                ++i;
            }
        } else {
            this.curve_color[idx] = null;
        }
    }

    public void overdraw(Matrix mat, int def_color, int[] colortbl, int idx) {
        if (!this.addData(mat, idx)) {
            return;
        }
        this.addColorTable(colortbl, idx);
        this.def_color[idx] = new Color(def_color);
        this.curve_flags[idx] = 128;
        this.repaint();
    }

    public void draw(Matrix mat, double[] rgs, int def_color, int[] colortbl) {
        this.removeAllCurve();
        this.setAllRanges((float)rgs[0], (float)rgs[1], 0);
        this.setAllRanges((float)rgs[2], (float)rgs[3], 1);
        if (mat.width() >= 3) {
            this.setAllRanges((float)rgs[4], (float)rgs[5], 2);
        }
        this.overdraw(mat, def_color, colortbl, 0);
    }

    public void draw(Matrix mat, int def_color, int[] colortbl) {
        double[] rgs = new double[6];
        int n = mat.width();
        if (n > 3) {
            n = 3;
        }
        int i = 0;
        while (i < n) {
            rgs[i + i] = mat.min(i);
            rgs[i + i + 1] = mat.max(i);
            ++i;
        }
        this.draw(mat, rgs, def_color, colortbl);
    }

    public void draw(Matrix mat, double[] rgs, int def_color) {
        this.draw(mat, rgs, def_color, null);
    }

    public void draw(Matrix mat, int def_color) {
        this.draw(mat, def_color, null);
    }

    public void multidraw(double[] x, Matrix mat, double min, double max, int[] colors) {
        this.removeAllCurve();
        if (!this.addData(x, mat, 0)) {
            return;
        }
        if (x[0] < x[x.length - 1]) {
            this.setAllRanges((float)x[0], (float)x[x.length - 1], 0);
        } else {
            this.setAllRanges((float)x[x.length - 1], (float)x[0], 0);
        }
        this.setAllRanges((float)min, (float)max, 1);
        this.setAllRanges(0.0f, 0.0f, 2);
        int i = 0;
        while (i < mat.width()) {
            this.def_color[i] = new Color(colors[i]);
            this.addColorTable(null, i);
            this.curve_flags[i] = 128;
            ++i;
        }
        this.repaint();
    }

    public void multidraw(double[] x, Matrix mat, int[] colors) {
        this.multidraw(x, mat, mat.min(), mat.max(), colors);
    }

    public void setStyle(int idx, int flags) {
        if (idx < 0) {
            int i = 0;
            while (i < 16) {
                int n = i;
                this.curve_flags[n] = this.curve_flags[n] & 0xFFFFFF0F;
                int n2 = i++;
                this.curve_flags[n2] = this.curve_flags[n2] | flags & 0xF0;
            }
        } else {
            int n = idx;
            this.curve_flags[n] = this.curve_flags[n] & 0xFFFFFF0F;
            int n3 = idx;
            this.curve_flags[n3] = this.curve_flags[n3] | flags & 0xF0;
        }
    }

    final void setRange(float min, float max, int dimid, int rangeid) {
        this.range[dimid * 8 + rangeid * 2] = min;
        this.range[dimid * 8 + rangeid * 2 + 1] = max;
    }

    final void useRange(int idx, int rangeid) {
        int n = idx;
        this.curve_flags[n] = this.curve_flags[n] & 0xFFFFFFFC;
        int n2 = idx;
        this.curve_flags[n2] = this.curve_flags[n2] | rangeid & 3;
    }

    private void removeAllCurve() {
        int i = 0;
        while (i < 16) {
            this.curve[i] = null;
            this.curve_color[i] = null;
            ++i;
        }
    }

    private final void setAllRanges(float min, float max, int dimid) {
        float f = min;
        this.range[dimid * 8 + 6] = f;
        this.range[dimid * 8 + 4] = f;
        this.range[dimid * 8 + 2] = f;
        this.range[dimid * 8 + 0] = f;
        float f2 = max;
        this.range[dimid * 8 + 7] = f2;
        this.range[dimid * 8 + 5] = f2;
        this.range[dimid * 8 + 3] = f2;
        this.range[dimid * 8 + 1] = f2;
    }

    private static final int closestUnit(double x) {
        int order;
        double y = Math.log(x) / log10;
        if ((y -= (double)(order = (int)Math.floor(y))) < 0.1) {
            return (order << 8) + 1;
        }
        if (y < 0.4) {
            return (order << 8) + 2;
        }
        if (y < 0.8) {
            return (order << 8) + 5;
        }
        return (order + 1 << 8) + 1;
    }

    private static final double decimalToDouble(int n, int order) {
        return Math.pow(10.0, order) * (double)n;
    }

    /*
     * Unable to fully structure code
     */
    private static final String decimalToString(int n, int order) {
        if (0 != n) ** GOTO lbl5
        return new String("0");
lbl-1000:
        // 1 sources

        {
            n /= 10;
            ++order;
lbl5:
            // 2 sources

            ** while (0 == n % 10)
        }
lbl6:
        // 1 sources

        str = new StringBuffer(64);
        if (order > 4) {
            str.append(n).append('E').append(order);
        } else if (order >= 0) {
            str.append(n);
            i = 0;
            while (i < order) {
                str.append('0');
                ++i;
            }
        } else {
            str.append(Math.abs(n));
            j = str.length();
            if (j > -order) {
                str.insert(j + order, '.');
            } else if (j > -order - 3) {
                while (j < -order) {
                    str.insert(0, '0');
                    ++j;
                }
                str.insert(0, "0.");
            } else {
                if (j > 1) {
                    str.insert(1, ".");
                }
                str.append('E').append(order + j - 1);
            }
            if (n < 0) {
                str.insert(0, '-');
            }
        }
        return str.toString();
    }

    private void paintRulers(Graphics g, int x, int y, int length, int breath, int breath_extend, double min, double max, double density, boolean is_vert, boolean with_label) {
        FontMetrics fm = g.getFontMetrics();
        int label_ypos = is_vert ? (fm.getAscent() - fm.getDescent()) / 2 : (breath > 0 ? breath_extend + fm.getAscent() : breath_extend - fm.getDescent());
        double factor = (double)length / (max - min);
        int unit = Plotter.closestUnit(density / factor);
        int order = unit >> 8;
        int lsd = unit & 0xF;
        int larger1 = 5 == lsd ? 2 : 5;
        int larger2 = 10;
        double dt = Plotter.decimalToDouble(lsd, order);
        int i = (int)Math.ceil(min / dt);
        double t = (double)i * dt;
        while (t <= max) {
            int offset = (int)Math.round((t - min) * factor);
            int ext = 0;
            boolean pe = false;
            boolean ne = false;
            if (0 == i % larger2) {
                ext = breath_extend;
                if (with_label) {
                    String label = Plotter.decimalToString(i * lsd, order);
                    if (is_vert) {
                        int w = breath_extend < 0 ? -fm.stringWidth(label) - 1 : 2;
                        g.drawString(label, x + breath_extend + w, y + length - 1 - offset + label_ypos);
                    } else {
                        g.drawString(label, x + offset - fm.stringWidth(label) / 2, y + label_ypos);
                    }
                }
            } else {
                ext = 0 == i % larger1 ? (breath_extend + breath) / 2 : breath;
            }
            if (is_vert) {
                int y1 = y + length - 1 - offset;
                g.drawLine(x, y1, x + ext, y1);
            } else {
                g.drawLine(x + offset, y, x + offset, y + ext);
            }
            t += dt;
            ++i;
        }
    }

    private void paintBorder(Graphics g, int win_width, int win_height) {
        int x0 = this.border.left - 1;
        int x1 = win_width - this.border.right;
        int y0 = this.border.top - 1;
        int y1 = win_height - this.border.bottom;
        g.drawLine(x0, y0, x1, y0);
        g.drawLine(x1, y0, x1, y1);
        g.drawLine(x1, y1, x0, y1);
        g.drawLine(x0, y1, x0, y0);
    }

    private void paintCurve(Graphics g, float[] curve, Color[] color, Color def_color, int width, int height, int flags) {
        int idx = flags & 3;
        if (this.range[idx] >= this.range[idx + 1] || this.range[idx + 8] >= this.range[idx + 9]) {
            return;
        }
        double xfactor = (float)width / (this.range[idx + 1] - this.range[idx]);
        double yfactor = (float)height / (this.range[idx + 9] - this.range[idx + 8]);
        double zfactor = 0.0;
        if (null != color) {
            if (this.range[idx + 17] <= this.range[idx + 16]) {
                color = null;
            } else {
                zfactor = (float)color.length / (this.range[idx + 17] - this.range[idx + 16]);
            }
        }
        g.setColor(def_color);
        int x = this.border.left + (int)Math.round((double)(curve[0] - this.range[idx]) * xfactor);
        int y = this.border.top + height - 1 - (int)Math.round((double)(curve[1] - this.range[idx + 8]) * yfactor);
        if (0 != (flags & 0x40)) {
            g.drawArc(x - 1, y - 1, 2, 2, 0, 360);
        }
        int i = 3;
        while (i < curve.length - 2) {
            double z;
            int x1 = this.border.left + (int)Math.round((double)(curve[i] - this.range[idx]) * xfactor);
            int y1 = this.border.top + height - 1 - (int)Math.round((double)(curve[i + 1] - this.range[idx + 8]) * yfactor);
            double d = z = 0 != (flags & 0x40) ? (double)curve[i + 2] : (double)(curve[i + 2] + curve[i - 1]) * 0.5;
            if (null != color) {
                int ci = (int)Math.round((z - (double)this.range[idx + 16]) * zfactor);
                if (ci < 0) {
                    ci = 0;
                } else if (ci >= color.length) {
                    ci = color.length - 1;
                }
                g.setColor(color[ci]);
            }
            if (0 != (flags & 0x80)) {
                g.drawLine(x, y, x1, y1);
            }
            if (0 != (flags & 0x40)) {
                g.drawArc(x1 - 1, y1 - 1, 2, 2, 0, 360);
            }
            x = x1;
            y = y1;
            i += 3;
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int win_width = this.getWidth() - insets.left - insets.right;
        int win_height = this.getHeight() - insets.top - insets.bottom;
        int width = win_width - this.border.left - this.border.right;
        int height = win_height - this.border.top - this.border.bottom;
        g.setColor(this.border_color);
        this.paintBorder(g, win_width, win_height);
        g.setColor(this.tick_color);
        g.setFont(this.tick_font);
        this.paintRulers(g, this.border.left, this.border.top - 1, width, -this.tick_width, -2 * this.tick_width, this.range[2], this.range[3], this.tick_density, false, true);
        this.paintRulers(g, this.border.left, win_height - this.border.bottom, width, this.tick_width, 2 * this.tick_width, this.range[4], this.range[5], this.tick_density, false, true);
        this.paintRulers(g, this.border.left - 1, this.border.top, height, -this.tick_width, -2 * this.tick_width, this.range[12], this.range[13], this.tick_density, true, true);
        this.paintRulers(g, win_width - this.border.right, this.border.top, height, this.tick_width, 2 * this.tick_width, this.range[10], this.range[11], this.tick_density, true, true);
        Shape clip = g.getClip();
        g.setClip(this.border.left, this.border.top, width, height);
        g.setColor(this.grid_color);
        this.paintRulers(g, this.border.left, this.border.top, width, height, height, this.range[0], this.range[1], this.grid_density, false, false);
        this.paintRulers(g, this.border.left, this.border.top, height, width, width, this.range[8], this.range[9], this.grid_density, true, false);
        float[] rg = new float[6];
        int i = 0;
        while (i < 16) {
            if (null != this.curve[i]) {
                int idx = (this.curve_flags[i] & 3) << 1;
                this.paintCurve(g, this.curve[i], this.curve_color[i], this.def_color[i], width, height, this.curve_flags[i]);
            }
            ++i;
        }
        g.setClip(clip);
    }

    public static int frameCount() {
        return frame_counter;
    }

    public static void main(String[] args) {
        Matrix mat = new Matrix(128, 3);
        double[] x = new double[128];
        int i = 0;
        while (i < 128) {
            x[i] = 0.01 * (double)i - 0.5;
            mat.set(i, 0, Math.sin(0.1 * (double)i) * 1.0);
            mat.set(i, 1, Math.sin(0.115 * (double)i) * 0.75 + 10.0);
            mat.set(i, 2, Math.sin(0.02 * (double)i) * 2.0 + 5.0);
            ++i;
        }
        Plotter p = Plotter.create("test", 512, 384);
        p.multidraw(x, mat, -12.0, 12.0, new int[]{0, 255, 65280});
        p.setStyle(1, 192);
        p.overdraw(mat, 6785296, null, 3);
    }

    static {
        nr_curve = 16;
        FL_STYLEMASK = 240;
        FL_LINESTYLE = 128;
        FL_POINTSTYLE = 64;
        FL_RANGEMASK = 3;
        frame_counter = 0;
        log10 = Math.log(10.0);
    }
}

