/*
 * Decompiled with CFR 0.152.
 */
package jamaica;

import jamaica.BitArray;
import jamaica.Matrix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Painter
extends JPanel {
    private static int[] grayscale = null;
    private JFrame frame;
    private Image image = null;
    public static final int CM_BLACKWHITE = 0;
    public static final int CM_GRAYSCALE = 1;
    public static final int CM_COLORS = 2;
    public static final int CM_DARKCOLORS = 3;
    public static final int CM_HOTCOLORS = 4;
    public static final int CM_WARMCOLORS = 5;
    public static final int CM_COLDCOLORS = 6;
    private static int frame_counter;

    public Painter(JFrame frame) {
        this.frame = frame;
    }

    public static final int color(double r, double g, double b) {
        return (0xFF & (int)(b * 255.0)) + ((0xFF & (int)(g * 255.0)) << 8) + ((0xFF & (int)(r * 255.0)) << 16);
    }

    public static final int[] colorMap(int type) {
        int[] cm;
        switch (type) {
            case 0: {
                cm = new int[]{0, 0xFFFFFF};
                break;
            }
            case 1: {
                cm = new int[256];
                int i = 0;
                while (i < 256) {
                    cm[i] = i << 16 | i << 8 | i;
                    ++i;
                }
                break;
            }
            case 2: {
                cm = new int[192];
                int i = 0;
                while (i < 64) {
                    cm[i] = i << 18 | 63 - i << 10 | 0xFF;
                    ++i;
                }
                int i2 = 0;
                while (i2 < 64) {
                    cm[i2 + 64] = i2 << 10 | 63 - i2 << 2 | 0xFF0000;
                    ++i2;
                }
                int i3 = 0;
                while (i3 < 64) {
                    cm[i3 + 128] = i3 << 2 | 63 - i3 << 18 | 0xFF00;
                    ++i3;
                }
                break;
            }
            case 3: {
                cm = new int[192];
                int i = 0;
                while (i < 64) {
                    cm[i] = i << 18 | 63 - i << 10;
                    ++i;
                }
                int i4 = 0;
                while (i4 < 64) {
                    cm[i4 + 64] = i4 << 2 | 63 - i4 << 18;
                    ++i4;
                }
                int i5 = 0;
                while (i5 < 64) {
                    cm[i5 + 128] = i5 << 10 | 63 - i5 << 2;
                    ++i5;
                }
                break;
            }
            case 4: {
                cm = new int[128];
                int i = 0;
                while (i < 64) {
                    cm[i] = 0xFF0000 | i << 10;
                    ++i;
                }
                int i6 = 0;
                while (i6 < 64) {
                    cm[i6 + 64] = 0xFFFF00 | i6 << 2;
                    ++i6;
                }
                break;
            }
            case 5: {
                cm = new int[64];
                int i = 0;
                while (i < 64) {
                    cm[i] = 0xFF00 | i << 2;
                    ++i;
                }
                break;
            }
            case 6: {
                cm = new int[32];
                int i = 0;
                while (i < 32) {
                    cm[i] = 63 - i << 18 | i << 2;
                    ++i;
                }
                break;
            }
            default: {
                return new int[]{0};
            }
        }
        return cm;
    }

    public static final int[] colorMap(Matrix map) {
        int n = map.width();
        int[] cm = new int[n];
        int i = 0;
        while (i < n) {
            cm[i] = Painter.color(map.get(2, i), map.get(1, i), map.get(0, i));
            ++i;
        }
        return cm;
    }

    public static Painter create(String title, int width, int height) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame frame = new JFrame(title);
        Painter pane = new Painter(frame);
        frame.getContentPane().add((Component)pane, "Center");
        ++frame_counter;
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame_counter--;
            }
        });
        pane.newsize(width, height);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        return pane;
    }

    void newsize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.image = new BufferedImage(width, height, 1);
        this.frame.pack();
    }

    public void draw(Matrix mat, double min, double max, int[] rgbtable) {
        int n = mat.width();
        int m = mat.height();
        int[] row = new int[n + n + n];
        this.newsize(n, m);
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        double factor = max > min ? (double)rgbtable.length / (max - min) : 0.0;
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                int k = (int)Math.round((mat.get(i, j) - min) * factor);
                if (k < 0) {
                    k = 0;
                }
                if (k >= rgbtable.length) {
                    k = rgbtable.length - 1;
                }
                row[j + j + j] = rgbtable[k] >> 16 & 0xFF;
                row[j + j + j + 1] = rgbtable[k] >> 8 & 0xFF;
                row[j + j + j + 2] = rgbtable[k] & 0xFF;
                ++j;
            }
            raster.setPixels(0, i, n, 1, row);
            ++i;
        }
        this.repaint();
    }

    private int[] getGrayScale() {
        if (null == grayscale) {
            grayscale = Painter.colorMap(1);
        }
        return grayscale;
    }

    public void draw(Matrix mat, double min, double max) {
        this.draw(mat, min, max, this.getGrayScale());
    }

    public void draw(Matrix mat, int[] rgbtable) {
        this.draw(mat, mat.min(), mat.max(), rgbtable);
    }

    public void draw(Matrix mat) {
        this.draw(mat, mat.min(), mat.max());
    }

    public void overdraw(Matrix mat, BitArray bmk, double min, double max, int[] rgbtable, int x, int y) {
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        int n = mat.width();
        int m = mat.height();
        int[] rgb = new int[3];
        double factor = max > min ? (double)rgbtable.length / (max - min) : 0.0;
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                if (bmk == null || mat.getBitMask(bmk, i, j)) {
                    int k = (int)Math.round((mat.get(i, j) - min) * factor);
                    if (k < 0) {
                        k = 0;
                    }
                    if (k >= rgbtable.length) {
                        k = rgbtable.length - 1;
                    }
                    rgb[0] = rgbtable[k] >> 16 & 0xFF;
                    rgb[1] = rgbtable[k] >> 8 & 0xFF;
                    rgb[2] = rgbtable[k] & 0xFF;
                    raster.setPixel(x + j, y + i, rgb);
                }
                ++j;
            }
            ++i;
        }
        this.repaint();
    }

    public void overdraw(Matrix mat, BitArray bmk, int[] rgbtable, int x, int y) {
        this.overdraw(mat, bmk, mat.min(), mat.max(), rgbtable, x, y);
    }

    public void overdraw(Matrix mat, int[] rgbtable, int x, int y) {
        this.overdraw(mat, null, mat.min(), mat.max(), rgbtable, x, y);
    }

    public void overdraw(Matrix mat, BitArray bmk, int[] rgbtable) {
        this.overdraw(mat, bmk, mat.min(), mat.max(), rgbtable, 0, 0);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        if (null != this.image) {
            g.drawImage(this.image, 0, 0, width, height, this);
        }
    }

    public static int frameCount() {
        return frame_counter;
    }

    public static void main(String[] args) {
        Painter.create("test", 200, 200).draw(Matrix.random(128, 512));
    }

    static {
        CM_BLACKWHITE = 0;
        CM_GRAYSCALE = 1;
        CM_COLORS = 2;
        CM_DARKCOLORS = 3;
        CM_HOTCOLORS = 4;
        CM_WARMCOLORS = 5;
        CM_COLDCOLORS = 6;
        frame_counter = 0;
    }
}

