/*
 * Decompiled with CFR 0.152.
 */
package jamaica;

import jamaica.BitArray;
import jamaica.Matrix;
import jamaica.Range;
import jamaica.TestError;

public class MatrixTest {
    static Range xr;
    static Range yr;

    static final int rand(int n) {
        return (int)Math.floor(Math.random() * (double)n);
    }

    static final void randRange(int rows, int cols) {
        int i = MatrixTest.rand(cols - 1);
        xr = new Range(i, MatrixTest.rand(cols - i) + 1, 1);
        i = MatrixTest.rand(rows - 1);
        yr = new Range(i, MatrixTest.rand(rows - i) + 1, 1);
    }

    public static void verifyMatrix(Matrix x, int rows, int cols) {
        if (rows != x.m || cols != x.n) {
            throw new TestError("Invalid dimensions: " + x.m + "*" + x.n + " [should be " + rows + "*" + cols + " ]");
        }
        if (x.a == null) {
            throw new TestError("Null data");
        }
        int[] corners = new int[]{x.r, x.r + (rows - 1) * x.ms, x.r + (cols - 1) * x.ns, x.r + (rows - 1) * x.ms + (cols - 1) * x.ns};
        int i = 0;
        while (i < 4) {
            if (corners[i] < 0 || corners[i] >= x.a.length) {
                throw new TestError("Boundary error: " + x.m + "*" + x.n + ", " + "length=" + x.a.length + ", r=" + x.r + ", ms=" + x.ms + ", ns=" + x.ns);
            }
            ++i;
        }
    }

    public static void compareMatrix(Matrix x, Matrix y, int nd) {
        MatrixTest.verifyMatrix(x, x.height(), x.width());
        MatrixTest.verifyMatrix(y, y.height(), y.width());
        int n = x.ne(y, 1.0E-10).count();
        int nx = x.eq(y, 1.0E-10).count();
        if (n != nd || nx != x.height() * x.width() - nd) {
            System.out.println("X = ");
            x.print(10, 4, 2);
            System.out.println("Y = ");
            y.print(10, 4, 2);
            BitArray ba = n != nd ? x.ne(y, 1.0E-10) : x.eq(y, 1.0E-10);
            System.out.print(n != nd ? "  NE: " : "  EQ: ");
            int i = 0;
            while (i < ba.length()) {
                System.out.print(ba.get(i) ? "1" : "0");
                ++i;
            }
            System.out.println();
            throw new TestError("Two matrices are different: " + n + " diff (" + nx + " same) [should be " + nd + " diff (" + (x.height() * x.width() - nd) + " same)");
        }
    }

    public static String testConstructor(int rows, int cols) {
        Matrix A = new Matrix(rows, cols);
        MatrixTest.verifyMatrix(A, rows, cols);
        Matrix B = new Matrix(rows, cols, 3.0);
        MatrixTest.verifyMatrix(B, rows, cols);
        Matrix C = new Matrix(A);
        MatrixTest.verifyMatrix(C, rows, cols);
        Matrix D = Matrix.random(rows, cols);
        MatrixTest.verifyMatrix(C, rows, cols);
        A.assign(B);
        MatrixTest.compareMatrix(C, B, 0);
        C.assign(3.0);
        MatrixTest.compareMatrix(A, B, 0);
        A.assign(D);
        MatrixTest.compareMatrix(C, D, 0);
        MatrixTest.compareMatrix(D, D.copy(), 0);
        A.refer(D);
        C.refer(D.copy());
        A.set(rows / 2, cols / 2, 0.73);
        MatrixTest.compareMatrix(A.copy(), C, 1);
        return null;
    }

    public static String testReadWrite(int rows, int cols) {
        Matrix A = new Matrix(rows, cols);
        Matrix B = Matrix.random(rows, cols);
        int j = 0;
        while (j < cols) {
            int i = 0;
            while (i < rows) {
                A.set(i, j, B.get(i, j));
                ++i;
            }
            ++j;
        }
        int j2 = 0;
        while (j2 < cols) {
            int i = 0;
            while (i < rows) {
                if (A.get(i, j2) != B.get(i, j2)) {
                    return "Read/Write failed";
                }
                ++i;
            }
            ++j2;
        }
        MatrixTest.compareMatrix(A, B, 0);
        int j3 = 0;
        while (j3 < cols) {
            int i = 0;
            while (i < rows) {
                A.setAdd(i, j3, A.get(i, j3));
                B.setMul(i, j3, 2.0);
                ++i;
            }
            ++j3;
        }
        MatrixTest.compareMatrix(A, B, 0);
        int j4 = 0;
        while (j4 < cols) {
            int i = 0;
            while (i < rows) {
                A.setSub(i, j4, B.get(i, j4));
                ++i;
            }
            ++j4;
        }
        MatrixTest.compareMatrix(A, new Matrix(A.m, A.n), 0);
        return null;
    }

    public static String testSlicing(int rows, int cols) {
        Matrix A = Matrix.random(rows, cols);
        MatrixTest.randRange(rows, cols);
        MatrixTest.compareMatrix(A.slice(yr, xr), A.transpose().slice(xr, yr).transpose(), 0);
        MatrixTest.compareMatrix(A.transpose().copy().slice(xr, yr), A.copy().slice(yr, xr).transpose(), 0);
        Matrix B = A.copy();
        A.slice(yr, xr).assign(3.4);
        MatrixTest.compareMatrix(A, B, xr.size() * yr.size());
        B.transpose().slice(xr, yr).assign(-3.4).selfneg();
        MatrixTest.compareMatrix(A, B, 0);
        B.slice(yr, xr).assign(0.0);
        MatrixTest.compareMatrix(A, B, xr.size() * yr.size());
        int i = xr.first();
        while (i <= xr.last()) {
            int j = yr.first();
            while (j <= yr.last()) {
                if (B.get(j, i) != 0.0) {
                    return "Wrong result [" + j + "," + i + "] = " + B.get(j, i) + " should be 0.";
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static String testArithmetic(int rows, int cols) {
        Matrix A = Matrix.random(rows, cols);
        Matrix B = A.uminus();
        MatrixTest.compareMatrix(A.selfneg(), B, 0);
        MatrixTest.compareMatrix(A, B.assign(1.23), rows * cols);
        B = A.copy();
        B.selfadd(A);
        B.selfadd(B);
        MatrixTest.compareMatrix(A.plus(A.times(3.0)), B, 0);
        B.selfsub(B.minus(A));
        MatrixTest.compareMatrix(A, B, 0);
        B.selfemul(new Matrix(rows, cols, 3.0));
        MatrixTest.compareMatrix(A.minus(A.times(2.0).uminus()), B, 0);
        B = Matrix.random(cols, MatrixTest.rand(rows + cols) + 1);
        int n = Math.max(Math.max(rows, cols), B.width());
        int i = 1;
        while (i < n) {
            i <<= 1;
        }
        n = i;
        Matrix A1 = new Matrix(n, n);
        Matrix B1 = new Matrix(n, n);
        A1.slice(new Range(0, rows, 1), new Range(0, cols, 1)).assign(A);
        B1.slice(new Range(0, cols, 1), new Range(0, B.width(), 1)).assign(B);
        Matrix C = A.transpose().copy();
        MatrixTest.compareMatrix(A.selfrmul(B), A1.strassen(B1).slice(new Range(0, rows, 1), new Range(0, B.width(), 1)), 0);
        MatrixTest.compareMatrix(C.selflmul(B.transpose()).transpose(), B1.transpose().strassen(A1.transpose()).slice(new Range(0, B.width(), 1), new Range(0, rows, 1)).transpose(), 0);
        return null;
    }

    public static String testInversion(int rows, int cols) {
        Matrix B = Matrix.random(rows, cols);
        Matrix A = Matrix.random(rows, rows);
        MatrixTest.compareMatrix(B, A.times(B.ldivide(A)), 0);
        return null;
    }

    public static String testRelational(int rows, int cols) {
        Matrix A = Matrix.random(rows, cols);
        A.set(0, cols - 1, 0.5);
        MatrixTest.compareMatrix(A.copy().assign(A.gt(0.5), 1.0), A.copy().assign(A.ge(0.5), 1.0), 1);
        MatrixTest.compareMatrix(A.copy().assign(A.lt(0.5), 1.0), A.copy().assign(A.le(0.5), 1.0), 1);
        MatrixTest.compareMatrix(A.copy().assign(A.eq(0.5), 10.0), A.copy().assign(A.ne(0.5), 10.0), rows * cols);
        Matrix B = A.copy();
        B.assign(A.gt(0.5), 0.0);
        B.assign(A.lt(0.5), 0.0);
        MatrixTest.compareMatrix(B, new Matrix(rows, cols), 1);
        B = A.times(3.0);
        B.assign(A.eq(0.5), 0.0);
        B.assign(A.ne(0.5), 0.0);
        MatrixTest.compareMatrix(B, new Matrix(rows, cols), 0);
        B = Matrix.random(rows, cols);
        B.set(rows / 2, cols / 2, A.get(rows / 2, cols / 2));
        MatrixTest.compareMatrix(B.copy().assign(B.gt(A).not(), -1.0), B.copy().assign(B.le(A), -1.0), 0);
        MatrixTest.compareMatrix(B.copy().assign(B.gt(A).not(), -1.0), B.copy().assign(B.lt(A), -1.0), 1);
        MatrixTest.compareMatrix(B.copy().assign(B.ge(A).not(), -1.0), B.copy().assign(B.lt(A), -1.0), 0);
        MatrixTest.compareMatrix(B.copy().assign(B.ne(A).not(), -1.0), B.copy().assign(B.eq(A), -1.0), 0);
        MatrixTest.compareMatrix(B.copy().assign(B.ne(A, 0.1).not(), -1.0), B.copy().assign(B.eq(A, 0.1), -1.0), 0);
        return null;
    }

    public static String testException(int rows, int cols) {
        return null;
    }

    public static void main(String[] args) {
        int rows = 1;
        while (rows < 100) {
            int cols = 1;
            while (cols < 100) {
                System.out.println("Test " + rows + "*" + cols + "...");
                String r = MatrixTest.testConstructor(rows, cols);
                if (r != null) {
                    System.out.println(r);
                }
                if ((r = MatrixTest.testReadWrite(rows, cols)) != null) {
                    System.out.println(r);
                }
                if ((r = MatrixTest.testSlicing(rows, cols)) != null) {
                    System.out.println(r);
                }
                if ((r = MatrixTest.testArithmetic(rows, cols)) != null) {
                    System.out.println(r);
                }
                if ((r = MatrixTest.testInversion(rows, cols)) != null) {
                    System.out.println(r);
                }
                if ((r = MatrixTest.testRelational(rows, cols)) != null) {
                    System.out.println(r);
                }
                cols += MatrixTest.rand(cols) + 1;
            }
            rows += MatrixTest.rand(rows) + 1;
        }
    }
}

