/*
 * Decompiled with CFR 0.152.
 */
package jamaica;

import jamaica.BitArray;
import jamaica.Range;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class Matrix
implements Cloneable {
    double[] a;
    int m;
    int n;
    int r;
    int ms;
    int ns;
    public static final int DT_BYTE = 1;
    public static final int DT_SHORT = 2;
    public static final int DT_INT = 3;
    public static final int DT_FLOAT = 4;
    public static final int DT_DOUBLE = 5;
    private static int[] dt_size;

    public Matrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.r = 0;
        this.ms = 1;
        this.ns = m;
        this.a = new double[m * n];
    }

    public Matrix(int m, int n, double s) {
        this.m = m;
        this.n = n;
        this.r = 0;
        this.ms = 1;
        this.ns = m;
        this.a = new double[m * n];
        int i = 0;
        while (i < this.a.length) {
            this.a[i] = s;
            ++i;
        }
    }

    public Matrix(int m, int n, double[] array, boolean byrow) {
        this.m = m;
        this.n = n;
        this.r = 0;
        if (byrow) {
            this.ms = n;
            this.ns = 1;
        } else {
            this.ms = 1;
            this.ns = m;
        }
        this.a = array;
    }

    public Matrix(Matrix x) {
        this.m = x.m;
        this.n = x.n;
        this.r = x.r;
        this.ms = x.ms;
        this.ns = x.ns;
        this.a = x.a;
    }

    public Matrix(Matrix x, Range mr, Range nr) {
        if (!mr.in(0, x.m - 1) || !nr.in(0, x.n - 1)) {
            throw new IllegalArgumentException("Invalid range: " + x.m + "*" + x.n + " [" + mr.toString() + "," + nr.toString() + "]");
        }
        this.a = x.a;
        this.m = mr.size();
        this.n = nr.size();
        this.r = x.r + mr.first() * x.ms + nr.first() * x.ns;
        this.ms = x.ms * mr.interval();
        this.ns = x.ns * nr.interval();
    }

    public static Matrix eye(int n) {
        Matrix x = new Matrix(n, n);
        int i = 0;
        while (i < n) {
            x.set(i, i, 1.0);
            ++i;
        }
        return x;
    }

    public static Matrix random(int m, int n) {
        Matrix x = new Matrix(m, n);
        int j = 0;
        while (j < n) {
            int i = 0;
            while (i < m) {
                x.set(i, j, Math.random());
                ++i;
            }
            ++j;
        }
        return x;
    }

    public static Matrix indgen(int m, int n, double s, double dm, double dn) {
        Matrix x = new Matrix(m, n);
        int j = 0;
        while (j < n) {
            double p = s;
            int i = 0;
            while (i < m) {
                x.set(i, j, p);
                ++i;
                p += dm;
            }
            s += dn;
            ++j;
        }
        return x;
    }

    private final String dimErrMsg() {
        return "Invalid dimensions: " + this.m + "*" + this.n;
    }

    private final String dimErrMsg(Matrix b) {
        return "Dimensions not match: " + this.m + "*" + this.n + " <=> " + b.m + "*" + b.n;
    }

    final boolean getBitMask(BitArray bmk, int i, int j) {
        return bmk.get(i + j * this.m);
    }

    private final void setBitMask(BitArray bmk, int i, int j) {
        bmk.set(i + j * this.m);
    }

    public final int height() {
        return this.m;
    }

    public final int width() {
        return this.n;
    }

    public final double get(int i, int j) {
        return this.a[this.r + i * this.ms + j * this.ns];
    }

    public final void set(int i, int j, double x) {
        this.a[this.r + i * this.ms + j * this.ns] = x;
    }

    public final void setAdd(int i, int j, double x) {
        int n = this.r + i * this.ms + j * this.ns;
        this.a[n] = this.a[n] + x;
    }

    public final void setSub(int i, int j, double x) {
        int n = this.r + i * this.ms + j * this.ns;
        this.a[n] = this.a[n] - x;
    }

    public final void setMul(int i, int j, double x) {
        int n = this.r + i * this.ms + j * this.ns;
        this.a[n] = this.a[n] * x;
    }

    public final void setDiv(int i, int j, double x) {
        int n = this.r + i * this.ms + j * this.ns;
        this.a[n] = this.a[n] / x;
    }

    public final void swapRows(int i1, int i2) {
        int j = 0;
        while (j < this.n) {
            double x = this.get(i1, j);
            this.set(i1, j, this.get(i2, j));
            this.set(i2, j, x);
            ++j;
        }
    }

    public final void swapColumns(int j1, int j2) {
        int i = 0;
        while (i < this.m) {
            double x = this.get(i, j1);
            this.set(i, j1, this.get(i, j2));
            this.set(i, j2, x);
            ++i;
        }
    }

    public final Matrix copy() {
        int p;
        Matrix x = new Matrix(this.m, this.n);
        int c = 0;
        int q = p = this.r;
        int j = 0;
        while (j < this.n) {
            q = p;
            int i = 0;
            while (i < this.m) {
                x.a[c++] = this.a[q];
                q += this.ms;
                ++i;
            }
            p += this.ns;
            ++j;
        }
        return x;
    }

    public Object clone() {
        return this.copy();
    }

    public Matrix refer(Matrix b) {
        this.m = b.m;
        this.n = b.n;
        this.r = b.r;
        this.ms = b.ms;
        this.ns = b.ns;
        this.a = b.a;
        return this;
    }

    public Matrix assign(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.set(i, j, b.get(i, j));
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix assign(BitArray bmk, Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.getBitMask(bmk, i, j)) {
                    this.set(i, j, b.get(i, j));
                }
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix assign(double f) {
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.set(i, j, f);
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix assign(BitArray bmk, double f) {
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.getBitMask(bmk, i, j)) {
                    this.set(i, j, f);
                }
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix slice(Range mr, Range nr) {
        return new Matrix(this, mr, nr);
    }

    public double min() {
        double d = Double.MAX_VALUE;
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) < d) {
                    d = this.get(i, j);
                }
                ++i;
            }
            ++j;
        }
        return d;
    }

    public double max() {
        double d = Double.MIN_VALUE;
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) > d) {
                    d = this.get(i, j);
                }
                ++i;
            }
            ++j;
        }
        return d;
    }

    public double min(int column) {
        double d = Double.MAX_VALUE;
        int i = 0;
        while (i < this.m) {
            if (this.get(i, column) < d) {
                d = this.get(i, column);
            }
            ++i;
        }
        return d;
    }

    public double max(int column) {
        double d = Double.MIN_VALUE;
        int i = 0;
        while (i < this.m) {
            if (this.get(i, column) > d) {
                d = this.get(i, column);
            }
            ++i;
        }
        return d;
    }

    public Matrix transpose() {
        Matrix x = new Matrix(this);
        int t = x.m;
        x.m = x.n;
        x.n = t;
        t = x.ms;
        x.ms = x.ns;
        x.ns = t;
        return x;
    }

    public Matrix flip() {
        Matrix x = new Matrix(this);
        x.r += (x.m - 1) * x.ms;
        x.ms = -x.ms;
        return x;
    }

    public Matrix mirror() {
        Matrix x = new Matrix(this);
        x.r += (x.n - 1) * x.ns;
        x.ns = -x.ns;
        return x;
    }

    public Matrix selfneg() {
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.set(i, j, -this.get(i, j));
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix uminus() {
        Matrix x = new Matrix(this.m, this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                x.set(i, j, -this.get(i, j));
                ++i;
            }
            ++j;
        }
        return x;
    }

    public Matrix plus(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        Matrix x = new Matrix(this.m, this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                x.set(i, j, this.get(i, j) + b.get(i, j));
                ++i;
            }
            ++j;
        }
        return x;
    }

    public Matrix selfadd(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.setAdd(i, j, b.get(i, j));
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix minus(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        Matrix x = new Matrix(this.m, this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                x.set(i, j, this.get(i, j) - b.get(i, j));
                ++i;
            }
            ++j;
        }
        return x;
    }

    public Matrix selfsub(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.setSub(i, j, b.get(i, j));
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix times(double f) {
        Matrix x = new Matrix(this.m, this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                x.set(i, j, this.get(i, j) * f);
                ++i;
            }
            ++j;
        }
        return x;
    }

    public Matrix etimes(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        Matrix x = new Matrix(this.m, this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                x.set(i, j, this.get(i, j) * b.get(i, j));
                ++i;
            }
            ++j;
        }
        return x;
    }

    public Matrix times(Matrix b) {
        if (this.n != b.m) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        Matrix x = new Matrix(this.m, b.n);
        int j = 0;
        while (j < b.n) {
            int i = 0;
            while (i < this.m) {
                double t = 0.0;
                int k = 0;
                while (k < this.n) {
                    t += this.get(i, k) * b.get(k, j);
                    ++k;
                }
                x.set(i, j, t);
                ++i;
            }
            ++j;
        }
        return x;
    }

    public Matrix selfmul(double f) {
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.setMul(i, j, f);
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix selfemul(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.setMul(i, j, b.get(i, j));
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix selflmul(Matrix b) {
        return this.refer(b.times(this));
    }

    public Matrix selfrmul(Matrix b) {
        return this.refer(this.times(b));
    }

    public Matrix edivide(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        Matrix x = new Matrix(this.m, this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                x.set(i, j, this.get(i, j) / b.get(i, j));
                ++i;
            }
            ++j;
        }
        return x;
    }

    public Matrix ldivide(Matrix b) {
        return b.solve(this);
    }

    public Matrix rdivide(Matrix b) {
        return b.transpose().solve(this.transpose()).transpose();
    }

    public Matrix selfediv(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                this.setDiv(i, j, b.get(i, j));
                ++i;
            }
            ++j;
        }
        return this;
    }

    public Matrix selfldiv(Matrix b) {
        return this.refer(this.ldivide(b));
    }

    public Matrix selfrdiv(Matrix b) {
        return this.refer(this.rdivide(b));
    }

    public BitArray gt(double f) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) > f) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray gt(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) > b.get(i, j)) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray ge(double f) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) >= f) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray ge(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) >= b.get(i, j)) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray lt(double f) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) < f) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray lt(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) < b.get(i, j)) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray le(double f) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) <= f) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray le(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) <= b.get(i, j)) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray eq(double f) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) == f) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray eq(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) == b.get(i, j)) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray eq(double f, double eps) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (Math.abs(this.get(i, j) - f) < eps) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray eq(Matrix b, double eps) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (Math.abs(this.get(i, j) - b.get(i, j)) < eps) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray ne(double f) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) != f) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray ne(Matrix b) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (this.get(i, j) != b.get(i, j)) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray ne(double f, double eps) {
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (Math.abs(this.get(i, j) - f) >= eps) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public BitArray ne(Matrix b, double eps) {
        if (this.m != b.m || this.n != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        BitArray bmk = new BitArray(this.m * this.n);
        int j = 0;
        while (j < this.n) {
            int i = 0;
            while (i < this.m) {
                if (Math.abs(this.get(i, j) - b.get(i, j)) >= eps) {
                    this.setBitMask(bmk, i, j);
                }
                ++i;
            }
            ++j;
        }
        return bmk;
    }

    public Matrix solve(Matrix b) {
        if (b.m != this.m) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        Matrix x = new Matrix(b.m, b.n);
        if (this.m == this.n) {
            int[] index = new int[this.m];
            Matrix lum = this.copy();
            lum.lud(index);
            int k = 0;
            while (k < this.n) {
                int j = 0;
                while (j < b.n) {
                    x.set(k, j, b.get(index[k], j));
                    ++j;
                }
                ++k;
            }
            int k2 = 0;
            while (k2 < this.n) {
                int i = k2 + 1;
                while (i < this.n) {
                    int j = 0;
                    while (j < b.n) {
                        x.setSub(i, j, x.get(k2, j) * lum.get(i, k2));
                        ++j;
                    }
                    ++i;
                }
                ++k2;
            }
            int k3 = this.n - 1;
            while (k3 >= 0) {
                double d = lum.get(k3, k3);
                if (d == 0.0) {
                    throw new RuntimeException("Singular");
                }
                d = 1.0 / d;
                int j = 0;
                while (j < b.n) {
                    x.setMul(k3, j, d);
                    ++j;
                }
                int i = 0;
                while (i < k3) {
                    int j2 = 0;
                    while (j2 < b.n) {
                        x.setSub(i, j2, x.get(k3, j2) * lum.get(i, k3));
                        ++j2;
                    }
                    ++i;
                }
                --k3;
            }
        } else {
            return null;
        }
        return x;
    }

    public double det() {
        if (this.m != this.n) {
            throw new IllegalArgumentException(this.dimErrMsg());
        }
        int[] index = new int[this.m];
        Matrix lum = this.copy();
        double x = lum.lud(index);
        int j = 0;
        while (j < this.n) {
            x *= lum.get(j, j);
            ++j;
        }
        return x;
    }

    public int rank() {
        throw new UnsupportedOperationException("rank");
    }

    public int rank(double eps) {
        throw new UnsupportedOperationException("rank");
    }

    public Matrix invert() {
        return this.solve(Matrix.eye(this.n));
    }

    public int lud(int[] index) {
        if (this.m < this.n) {
            throw new IllegalArgumentException(this.dimErrMsg());
        }
        int sign = 1;
        int i = 0;
        while (i < this.m) {
            index[i] = i;
            ++i;
        }
        int j = 0;
        while (j < this.n) {
            double x;
            double sum;
            int i2 = 0;
            while (i2 < j) {
                sum = this.get(i2, j);
                int k = 0;
                while (k < i2) {
                    sum -= this.get(i2, k) * this.get(k, j);
                    ++k;
                }
                this.set(i2, j, sum);
                ++i2;
            }
            double maxv = 0.0;
            int maxidx = -1;
            int i3 = j;
            while (i3 < this.m) {
                sum = this.get(i3, j);
                int k = 0;
                while (k < j) {
                    sum -= this.get(i3, k) * this.get(k, j);
                    ++k;
                }
                this.set(i3, j, sum);
                x = Math.abs(sum);
                if (x >= maxv) {
                    maxv = x;
                    maxidx = i3;
                }
                ++i3;
            }
            if (maxidx != j) {
                int t = index[j];
                index[j] = index[maxidx];
                index[maxidx] = t;
                sign = -sign;
                this.swapRows(j, maxidx);
            }
            if (this.get(j, j) != 0.0) {
                x = 1.0 / this.get(j, j);
                int i4 = j + 1;
                while (i4 < this.n) {
                    this.setMul(i4, j, x);
                    ++i4;
                }
            }
            ++j;
        }
        return sign;
    }

    public final Matrix strassen(Matrix b) {
        if (this.m != this.n || this.n != b.m || b.m != b.n) {
            throw new IllegalArgumentException(this.dimErrMsg(b));
        }
        if (1 == this.n) {
            return new Matrix(1, 1, this.get(0, 0) * b.get(0, 0));
        }
        if (0 != (this.n & 1)) {
            throw new IllegalArgumentException("Strassen's algorithm is not applicable for matrix " + this.n + "*" + this.n);
        }
        Range r1 = new Range(0, this.n >> 1, 1);
        Range r2 = new Range(this.n >> 1, this.n >> 1, 1);
        Matrix x = new Matrix(this.n, this.n);
        Matrix a11 = this.slice(r1, r1);
        Matrix a12 = this.slice(r1, r2);
        Matrix a21 = this.slice(r2, r1);
        Matrix a22 = this.slice(r2, r2);
        Matrix b11 = b.slice(r1, r1);
        Matrix b12 = b.slice(r1, r2);
        Matrix b21 = b.slice(r2, r1);
        Matrix b22 = b.slice(r2, r2);
        Matrix p1 = a11.plus(a22).strassen(b11.plus(b22));
        Matrix p2 = a21.plus(a22).strassen(b11);
        Matrix p3 = a11.strassen(b12.minus(b22));
        Matrix p4 = a22.strassen(b21.minus(b11));
        Matrix p5 = a11.plus(a12).strassen(b22);
        Matrix p6 = a21.minus(a11).strassen(b11.plus(b12));
        Matrix p7 = a12.minus(a22).strassen(b21.plus(b22));
        x.slice(r1, r1).assign(p1).selfadd(p4).selfsub(p5).selfadd(p7);
        x.slice(r1, r2).assign(p3).selfadd(p5);
        x.slice(r2, r1).assign(p2).selfadd(p4);
        x.slice(r2, r2).assign(p1).selfadd(p3).selfsub(p2).selfadd(p6);
        return x;
    }

    public static Matrix load(String fn, int type, int m, int n, long skip) throws IOException {
        if (m <= 0 && n <= 0) {
            return null;
        }
        RandomAccessFile file = new RandomAccessFile(fn, "r");
        long l = file.length() - skip;
        if (l < 0L) {
            file.close();
            return null;
        }
        l /= (long)dt_size[type];
        if (m <= 0) {
            m = (int)(l / (long)n);
        } else if (n <= 0) {
            n = (int)(l / (long)m);
        }
        if (m <= 0 || n <= 0) {
            file.close();
            return null;
        }
        if (skip != 0L) {
            file.seek(skip);
        }
        Matrix x = new Matrix(m, n);
        switch (type) {
            case 1: {
                int j = 0;
                while (j < n) {
                    int i = 0;
                    while (i < m) {
                        x.set(i, j, 0xFF & file.readByte());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 2: {
                int j = 0;
                while (j < n) {
                    int i = 0;
                    while (i < m) {
                        x.set(i, j, file.readShort());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 3: {
                int j = 0;
                while (j < n) {
                    int i = 0;
                    while (i < m) {
                        x.set(i, j, file.readInt());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 4: {
                int j = 0;
                while (j < n) {
                    int i = 0;
                    while (i < m) {
                        x.set(i, j, file.readFloat());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 5: {
                int j = 0;
                while (j < n) {
                    int i = 0;
                    while (i < m) {
                        x.set(i, j, file.readDouble());
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            default: {
                file.close();
                throw new IllegalArgumentException("Illegal data type");
            }
        }
        file.close();
        return x;
    }

    public static Matrix load(String fn, int type, int m, int n) throws IOException {
        return Matrix.load(fn, type, m, n, 0L);
    }

    public void save(String fn, int type, long skip) throws IOException {
        RandomAccessFile file = new RandomAccessFile(fn, "rw");
        if (skip != 0L) {
            file.seek(skip);
        }
        switch (type) {
            case 1: {
                int j = 0;
                while (j < this.n) {
                    int i = 0;
                    while (i < this.m) {
                        file.writeByte((byte)this.get(i, j));
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 2: {
                int j = 0;
                while (j < this.n) {
                    int i = 0;
                    while (i < this.m) {
                        file.writeShort((short)this.get(i, j));
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 3: {
                int j = 0;
                while (j < this.n) {
                    int i = 0;
                    while (i < this.m) {
                        file.writeInt((int)this.get(i, j));
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 4: {
                int j = 0;
                while (j < this.n) {
                    int i = 0;
                    while (i < this.m) {
                        file.writeFloat((float)this.get(i, j));
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 5: {
                int j = 0;
                while (j < this.n) {
                    int i = 0;
                    while (i < this.m) {
                        file.writeDouble(this.get(i, j));
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            default: {
                file.close();
                throw new IllegalArgumentException("Illegal data type");
            }
        }
        file.close();
    }

    public void save(String fn, int type) throws IOException {
        this.save(fn, type, 0L);
    }

    public void print(int width, int precision, int indent) {
        this.print(new PrintWriter(System.out, true), width, precision, indent);
    }

    public void print(NumberFormat format, int width, int indent) {
        this.print(new PrintWriter(System.out, true), format, width, indent);
    }

    public void print(PrintWriter output, int width, int precision, int indent) {
        DecimalFormat fmt = new DecimalFormat();
        fmt.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        fmt.setMinimumIntegerDigits(1);
        fmt.setMaximumFractionDigits(precision);
        fmt.setMinimumFractionDigits(precision);
        fmt.setGroupingUsed(false);
        this.print(output, fmt, width, indent);
    }

    public void print(PrintWriter output, NumberFormat format, int width, int indent) {
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                String str = format.format(this.get(i, j));
                int space = width - str.length();
                if (0 == j) {
                    space += indent;
                } else {
                    output.print(' ');
                    --space;
                }
                while (space > 0) {
                    output.print(' ');
                    --space;
                }
                output.print(str);
                ++j;
            }
            output.println();
            ++i;
        }
    }

    static {
        DT_BYTE = 1;
        DT_SHORT = 2;
        DT_INT = 3;
        DT_FLOAT = 4;
        DT_DOUBLE = 5;
        dt_size = new int[]{0, 1, 2, 4, 4, 8};
    }
}

