/*
 * Decompiled with CFR 0.152.
 */
package jamaica;

public class BitArray
implements Cloneable {
    int size;
    int[] barray;

    public BitArray(int n) {
        this.size = n;
        this.barray = new int[(this.size + 31) / 32];
    }

    private BitArray(int n, int[] a) {
        this.size = n;
        this.barray = a;
    }

    public final BitArray copy() {
        return new BitArray(this.size, (int[])this.barray.clone());
    }

    public Object clone() {
        return this.copy();
    }

    public final int length() {
        return this.size;
    }

    public final void set(int bit) {
        int n = bit / 32;
        this.barray[n] = this.barray[n] | 1 << bit % 32;
    }

    public final void clear(int bit) {
        int n = bit / 32;
        this.barray[n] = this.barray[n] & ~(1 << bit % 32);
    }

    public final void flip(int bit) {
        int n = bit / 32;
        this.barray[n] = this.barray[n] ^ 1 << bit % 32;
    }

    public final void clear() {
        int i = 0;
        while (i < this.barray.length) {
            this.barray[i] = 0;
            ++i;
        }
    }

    public final boolean get(int bit) {
        return 0 != (this.barray[bit / 32] & 1 << bit % 32);
    }

    public final BitArray not() {
        BitArray x = this.copy();
        int i = 0;
        while (i < this.barray.length) {
            x.barray[i] = ~this.barray[i];
            ++i;
        }
        return x;
    }

    public final BitArray or(BitArray b) {
        int xr;
        int xq;
        BitArray y;
        BitArray x;
        if (this.size >= b.size) {
            x = this.copy();
            y = b;
            xq = b.size / 32;
            xr = b.size % 32;
        } else {
            x = b.copy();
            y = this;
            xq = this.size / 32;
            xr = this.size % 32;
        }
        int i = 0;
        while (i < xq) {
            int n = i;
            x.barray[n] = x.barray[n] | y.barray[i];
            ++i;
        }
        if (0 != xr) {
            int n = xq;
            x.barray[n] = x.barray[n] | y.barray[xq] & (1 << xr) - 1;
        }
        return x;
    }

    public final BitArray and(BitArray b) {
        int xr;
        int xq;
        BitArray y;
        BitArray x;
        if (this.size >= b.size) {
            x = this.copy();
            y = b;
            xq = b.size / 32;
            xr = b.size % 32;
        } else {
            x = b.copy();
            y = this;
            xq = this.size / 32;
            xr = this.size % 32;
        }
        int i = 0;
        while (i < xq) {
            int n = i;
            x.barray[n] = x.barray[n] & y.barray[i];
            ++i;
        }
        if (0 != xr) {
            int n = xq;
            x.barray[n] = x.barray[n] & (y.barray[xq] | ~((1 << xr) - 1));
        }
        return x;
    }

    public final BitArray xor(BitArray b) {
        int xr;
        int xq;
        BitArray y;
        BitArray x;
        if (this.size >= b.size) {
            x = this.copy();
            y = b;
            xq = b.size / 32;
            xr = b.size % 32;
        } else {
            x = b.copy();
            y = this;
            xq = this.size / 32;
            xr = this.size % 32;
        }
        int i = 0;
        while (i < xq) {
            int n = i;
            x.barray[n] = x.barray[n] ^ y.barray[i];
            ++i;
        }
        if (0 != xr) {
            int n = xq;
            x.barray[n] = x.barray[n] ^ y.barray[xq] & (1 << xr) - 1;
        }
        return x;
    }

    static final int countBits(int x) {
        int y = x;
        y = ((y & 0xAAAAAAAA) >>> 1) + (y & 0x55555555);
        y = ((y & 0xCCCCCCCC) >>> 2) + (y & 0x33333333);
        y = ((y & 0xF0F0F0F0) >>> 4) + (y & 0xF0F0F0F);
        y = ((y & 0xFF00FF00) >>> 8) + (y & 0xFF00FF);
        y = ((y & 0xFFFF0000) >>> 16) + (y & 0xFFFF);
        return y;
    }

    public final int count() {
        int cnt = 0;
        int xq = this.size / 32;
        int xr = this.size % 32;
        int i = 0;
        while (i < xq) {
            cnt += BitArray.countBits(this.barray[i]);
            ++i;
        }
        if (0 != xr) {
            cnt += BitArray.countBits(this.barray[xq] & (1 << xr) - 1);
        }
        return cnt;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < this.size) {
            if (this.get(i)) {
                str.append('1');
            } else {
                str.append('0');
            }
            ++i;
        }
        return str.toString();
    }
}

