/* $Id: zip.h,v 1.4 2002/03/19 03:49:13 hanhua Exp $ */
#ifndef _ZIP_H
#define _ZIP_H

#include <stdio.h>
#include "htutil.h"

#define ZIP_STORAGE ((void *)(storage_counter+1))

/* a zipentry saves information of a file/dir(entry) inside the zip file */
typedef struct tag_zipentry {
    int file_num;  /* 0:a file. >0:the num of files this entry (for dir) */

    /* prev and next are pointers to siblings in a same parent dir */
    /* hash_next is used by hash table to resolve collision */
    struct tag_zipentry *prev, *next, *hash_next;
    /* a pointer to the first file entry in the dir, NULL for a file entry */
    struct tag_zipentry *files;

    char *name;            /* the file/dir name */
    size_t data_off;       /* data offset in file (invalid for dirs) */
    unsigned long crc32;   /* invalid for directories */
    unsigned long co_size; /* compressed size (invalid for directories) */
    unsigned long un_size; /* uncompressed size (invalid for directories) */
    int method;            /* compression method */
    time_t time;           /* last mod file time and date */
} zipentry;

/* zip hash structure is to save the whole file structure in the zip file*/
typedef struct {
    int item_num;
    int table_size;
    zipentry **table;
    int root_file_num;
    zipentry *root_files;
} ziphash;

/* zipfile structure manages an openned zip file */
typedef struct {
    int entry_num;
    size_t first_entry_off;
    size_t dir_size;

    int loaded_num;
    size_t cur_entry_off;

    FILE *fp;
    ziphash dir;
} zipfile;

/* zipsession structure manages each session of file reading */
typedef struct {
    zipfile *file;
    zipentry *entry;
    size_t start;
    size_t offset;
    size_t unc_off;  /* uncompressed offset = offset if STORED */
    int state;
    void *param;
    /* unsigned long adler; */
} zipsession;


/* initiating the hash table in the zipfile structure, called by zip_open */
int zip_hashtable_init( ziphash *hash, int size );

/* cleaning up the hash table and all zipentries managed by this table */
void zip_hashtable_cleanup( ziphash *hash );

/* adding a zipentry to the hash table */
void zip_hashtable_add( ziphash *hash, zipentry *entry );

/* openning a zip file */
zipfile *zip_open( const char *path );

/* closing a zip file */
void zip_close( zipfile *zf );

/* loading num entries from the openned zipfile */
int zip_loadentry( zipfile *zf, int num );

/* searching a file(or dir) in the hash table, returning NULL if failed */
zipentry *zip_search( zipfile *zf, const char *file );

/* searching a dir in hash table and returning its first child */
zipentry *zip_readdir( zipfile *zf, const char *path );

/* openning a session in order to read specified file in a zip file */
zipsession *zip_session_open( zipfile *zf, zipentry *ze );

/* closing a reading session */
void zip_session_close( zipsession *zs );

/* decompressing and reading a block from a file in a zip file */
size_t zip_session_read( void *buf, size_t size, zipsession *zs );

/* seeking to specified position of a file in a zip file */
void zip_session_seek( zipsession *zs, size_t offset );

#endif /* _ZIP_H */
