/*
 * winskt.c: windows sockets
 *
 * Hanhua Feng
 *
 * $Id: winskt.c,v 1.7 2003/05/21 14:59:39 hanhua Exp $
 */
#include <stdio.h>
#include <string.h>
#include <winsock2.h>
#include <windows.h>
#include <winuser.h>
#include <shlobj.h>
#include <shellapi.h>
#include "htutil.h"
#include "htconfig.h"
#include "htzipd.h"

#define WM_SOCKET  WM_USER
#define WM_TRAYMSG WM_USER+1

static int bytes_sent=0, bytes_recv=0, conns_accepted=0;
static BOOL flag_on = FALSE, flag_trayicon;
char work_dir[MAX_PATH] = "c:/webhome";
char index_file[32];
HICON hicon;
htman man;

void enable_conn_input( htman *man, taskentry *tsk )
{
    tsk->sys.flags |= CONN_IO_CHANGE;
    tsk->sys.flags |= CONN_INPUT;
}

void disable_conn_input( htman *man, taskentry *tsk )
{
    tsk->sys.flags |= CONN_IO_CHANGE;
    tsk->sys.flags &= ~CONN_INPUT;
}

void enable_conn_output( htman *man, taskentry *tsk )
{
    tsk->sys.flags |= CONN_IO_CHANGE;
    tsk->sys.flags |= ~CONN_OUTPUT;
}

void disable_conn_output( htman *man, taskentry *tsk )
{
    tsk->sys.flags |= CONN_IO_CHANGE;
    tsk->sys.flags &= ~CONN_OUTPUT;
}

static void exec_conn_change( htman *man, taskentry *tsk )
{
    DWORD n = 0;
    if ( tsk->sys.flags & CONN_IO_CHANGE )
    {
        if ( tsk->sys.flags & CONN_INPUT )
            n |= FD_READ;
        if ( tsk->sys.flags & CONN_INPUT )
            n |= FD_WRITE;
        n |= FD_CLOSE;
        WSAAsyncSelect( tsk->sys.sock, man->sys.hwnd, WM_SOCKET, n );
        tsk->sys.flags &= ~CONN_IO_CHANGE;
    }
}

void end_conn( htman *man, taskentry *tsk )
{
    WSAAsyncSelect( tsk->sys.sock, man->sys.hwnd, 0, 0 );
    closesocket( tsk->sys.sock );
}

enum { ID_ROOT_LABEL, ID_ROOT_EDIT, ID_ROOT_BROWSE,
    ID_INDEX_LABEL, ID_INDEX_EDIT,
    ID_PORT_LABEL, ID_PORT_EDIT,
    ID_START_BUTTON, ID_CLEAN_CACHE, ID_CLOSE_BUTTON, ID_ABOUT_BUTTON,
    ID_USAGE_LABEL, ID_IOBYTES_LABEL, ID_CONN_LABEL, ID_HELP_LABEL,
    ID_SENT_LABEL, ID_SENT_EDIT, ID_RECV_LABEL, ID_RECV_EDIT,
    ID_ONLINE_LABEL, ID_ONLINE_EDIT, ID_TOTAL_LABEL, ID_TOTAL_EDIT,
    ID_STORAGE_LABEL, ID_STORAGE_EDIT,
    ID_STORAGE_LABEL1, ID_STORAGE_EDIT1,
    ID_STORAGE_LABEL2, ID_STORAGE_EDIT2,
    ID_STORAGE_LABEL3, ID_STORAGE_EDIT3,
    ID_STORAGE_LABEL4, ID_STORAGE_EDIT4,
    ID_NUM, ID_TIMER };

#define FULL_APP_NAME APPLICATION_NAME " HTTP Server " VERSION

const char *szClassName = APPLICATION_NAME "/" VERSION;
const char *szWindowName = FULL_APP_NAME;
const char *szHelpInfo = FULL_APP_NAME "\n"
        "Copyright(C) 2002 by Hanhua Feng\n"
        "Bug report: hhfeng@mail.com";

int httpd_start( int port, char *work_dir, char *index_file )
{
    int i;
    WSADATA wsad;
    struct sockaddr_in sktin;

    if ( WSAStartup( MAKEWORD( 2, 0 ), &wsad ) )
        return -1;

    man.sys.sock = WSASocket( AF_INET, SOCK_STREAM, 0, NULL, 0, 0 );

    if ( INVALID_SOCKET == man.sys.sock )
    {
        MessageBox( man.sys.hwnd, "WSASocket() Failed.", "Error", MB_OK );

        WSACleanup();
        return -1;
    }

    sktin.sin_family = AF_INET;
    sktin.sin_port = htons( port );
    sktin.sin_addr.s_addr = INADDR_ANY;

    if ( bind( man.sys.sock, (struct sockaddr *)&sktin, sizeof(sktin) ) )
    {
        MessageBox( man.sys.hwnd, "bind() Failed.", "Error", MB_OK );

        WSACleanup();
        return -1;
    }

    for ( i=0; work_dir[i]; i++ )
        if ( '\\' == work_dir[i] )
            work_dir[i] = '/';

    CONFIG_INIT();
    validate_config( CONFIG, work_dir );
    CONFIG_OF(index_file) = index_file;

    htman_init( &man, work_dir );

    listen( man.sys.sock, 5 );

    WSAAsyncSelect( man.sys.sock, man.sys.hwnd, WM_SOCKET, FD_ACCEPT );

    return 0;
}

void httpd_stop( void )
{
    WSACleanup();

    htman_cleanup( &man );
    CONFIG_CLEANUP();
}


LRESULT SocketMsgProc( HWND hwnd, WPARAM wparam, LPARAM lparam )
{
    struct sockaddr_in sktin;
    int sktin_len, rv;
    SOCKET sock = (SOCKET)wparam;
    taskentry *tsk;
    const char *p;
    WSABUF buffer;
    DWORD n, flags;

    switch ( WSAGETSELECTEVENT( lparam ) )
    {
    case FD_READ:
        p = int_to_hex_str( sock );
        HASH_FIND( man.tasks, p, tsk );
        if ( !tsk )
        {
#ifdef DEBUG
            // MessageBox( hwnd, "Socket Reading Error", p, MB_OK );
#endif
            break;
        }
        buffer.len = tsk->in_buf_size - tsk->in_head;
        buffer.buf = tsk->in_buf + tsk->in_head;
        flags = 0;
        if ( WSARecv( sock, &buffer, 1, &n, &flags, NULL, NULL ) )
            break;

        bytes_recv += n;

        tsk->in_head += n;

        if ( REQ_END != exec_task( &man, tsk ) )
            exec_conn_change( &man, tsk );
        break;

    case FD_WRITE:
        p = int_to_hex_str( sock );
        HASH_FIND( man.tasks, p, tsk );
        if ( !tsk )
        {
#ifdef DEBUG
            /* MessageBox( hwnd, "Socket Writing Error", p, MB_OK ); */
#endif
            break;
        }

        if ( 0 == tsk->out_len )
            break;

        buffer.len = tsk->out_len;
        buffer.buf = tsk->out_buf;
        if ( WSASend( sock, &buffer, 1, &n, 0, NULL, NULL ) )
            break;

        bytes_sent += n;

        if ( n < tsk->out_len )
        {
            tsk->out_len -= n;
            memmove( tsk->out_buf, tsk->out_buf + n, tsk->out_len );
        }
        else
            tsk->out_len = 0;

        if ( tsk->state == TASK_OUTPUT_END || tsk->state == TASK_NOFILE
             || tsk->out_len < (size_t) tsk->sys.mss )
        {
            rv = exec_task( &man, tsk );
            if ( REQ_END == rv )
                break;
        }

        if ( tsk->out_len > 0 )
            tsk->sys.flags |= CONN_IO_CHANGE;
        exec_conn_change( &man, tsk );
        break;

    case FD_ACCEPT:
        if ( sock != man.sys.sock )
        {
            MessageBox( man.sys.hwnd,
                "Accept", "Invalid accepted socket", MB_OK );
            break;
        }

        sktin_len = sizeof(sktin);
        sock = WSAAccept( man.sys.sock, (struct sockaddr *)&sktin,
                          &sktin_len, 0, 0 );
        if ( INVALID_SOCKET == sock )
        {
            if ( WSAGetLastError() == WSATRY_AGAIN )
                WSAAsyncSelect( man.sys.sock, man.sys.hwnd,
                                WM_SOCKET, FD_ACCEPT );
            break;
        }

        conns_accepted++;

        tsk = task_new( int_to_hex_str( sock ) );
        if ( !tsk )
            return -1;
        tsk->sys.sock = sock;

        /* MSS: maximum segment size */
        tsk->sys.mss = 1436;
        tsk->sys.flags = 0;
        start_task( &man, tsk );
        exec_conn_change( &man, tsk );
        break;

    case FD_CLOSE:
        p = int_to_hex_str( sock );
        HASH_FIND( man.tasks, p, tsk );
        if ( !tsk )
        {
#ifdef DEBUG
            // MessageBox( hwnd, "Socket Closing Error", p, MB_OK );
#endif
            break;
        }

        end_task( &man, tsk );
        break;

    default:
        break;
    }
    return 0;
}

LRESULT CALLBACK WinProc( HWND hwnd, UINT msg,
                          WPARAM wparam, LPARAM lparam )
{
    int i, port;
    char buf[MAX_PATH];
    BROWSEINFO bi;
    LPITEMIDLIST lpiil;


    switch ( msg )
    {
    case WM_CREATE:
        SetTimer( hwnd, ID_TIMER, 1000, NULL );
        break;

    case WM_CLOSE:
        ShowWindow( hwnd, SW_HIDE );
        break;

    case WM_TRAYMSG:
        if ( lparam == WM_LBUTTONDOWN )
            ShowWindow( hwnd, SW_SHOW );
        break;

    case WM_DESTROY:
        KillTimer( hwnd, ID_TIMER );
        PostQuitMessage(0);
        break;

    case WM_COMMAND:
        switch ( LOWORD(wparam) )
        {
        case ID_CLOSE_BUTTON:
            if ( IDYES == MessageBox( hwnd,
                "Close " APPLICATION_NAME " " VERSION "?", "Close",
                MB_YESNO | MB_DEFBUTTON2 ) )
            {
                DestroyWindow( hwnd );
            }
            break;

        case ID_ABOUT_BUTTON:
            MessageBox( hwnd, szHelpInfo, "About", MB_OK | MB_ICONINFORMATION );
            break;

        case ID_ROOT_BROWSE:
            bi.hwndOwner = hwnd;
            bi.pidlRoot = NULL;
            bi.pszDisplayName = buf;
            bi.lpszTitle = "Root folder of the web server";
            bi.ulFlags = BIF_DONTGOBELOWDOMAIN | BIF_RETURNONLYFSDIRS;
            bi.lpfn = NULL;
            bi.lParam = 0;
            bi.iImage = 0;
            lpiil = SHBrowseForFolder( &bi );
            if ( lpiil )
            {
                if ( SHGetPathFromIDList( lpiil, work_dir ) )
                    SetDlgItemText( hwnd, ID_ROOT_EDIT, work_dir );
                CoTaskMemFree( lpiil );
            }
            break;

        case ID_CLEAN_CACHE:
            resource_collect( &man, 1 );
            break;

        case ID_START_BUTTON:
            if ( flag_on )
            {
                SetDlgItemText( hwnd, ID_START_BUTTON, "Start " FULL_APP_NAME );

                EnableWindow( GetDlgItem(hwnd, ID_PORT_EDIT), TRUE );
                EnableWindow( GetDlgItem(hwnd, ID_ROOT_EDIT), TRUE );
                EnableWindow( GetDlgItem(hwnd, ID_ROOT_BROWSE), TRUE );
                EnableWindow( GetDlgItem(hwnd, ID_INDEX_EDIT), TRUE );
                EnableWindow( GetDlgItem(hwnd, ID_CLOSE_BUTTON), TRUE );
                EnableWindow( GetDlgItem(hwnd, ID_CLEAN_CACHE), FALSE );

                SetDlgItemText( hwnd, ID_HELP_LABEL, FULL_APP_NAME );

                httpd_stop();
            }
            else
            {
                GetDlgItemText( hwnd, ID_PORT_EDIT, buf, sizeof(buf) );
                GetDlgItemText( hwnd, ID_ROOT_EDIT,
                                work_dir, sizeof(work_dir) );
                GetDlgItemText( hwnd, ID_INDEX_EDIT,
                                index_file, sizeof(index_file) );

                port = atoi( buf );

                if ( httpd_start( port, work_dir, index_file ) < 0 )
                    break;

                if ( port == 80 )
                    strcpy( buf, "For help: http://127.0.0.1/?help" );
                else
                    sprintf( buf, "For help: http://127.0.0.1:%d/?help", port );

                SetDlgItemText( hwnd, ID_HELP_LABEL, buf );

                SetDlgItemText( hwnd, ID_START_BUTTON, "Stop " FULL_APP_NAME );

                EnableWindow( GetDlgItem(hwnd, ID_PORT_EDIT), FALSE );
                EnableWindow( GetDlgItem(hwnd, ID_ROOT_EDIT), FALSE );
                EnableWindow( GetDlgItem(hwnd, ID_ROOT_BROWSE), FALSE );
                EnableWindow( GetDlgItem(hwnd, ID_INDEX_EDIT), FALSE );
                EnableWindow( GetDlgItem(hwnd, ID_CLOSE_BUTTON), FALSE );
                EnableWindow( GetDlgItem(hwnd, ID_CLEAN_CACHE), TRUE );
            }

            flag_on = !flag_on;
            break;

        default:
            break;
        }
        break;

    case WM_SOCKET:
        return SocketMsgProc( hwnd, wparam, lparam );

    case WM_TIMER:
        resource_collect( &man, 0 );

        sprintf( buf, "%d", bytes_sent );
        SetDlgItemText( hwnd, ID_SENT_EDIT, buf );
        sprintf( buf, "%d", bytes_recv );
        SetDlgItemText( hwnd, ID_RECV_EDIT, buf );
        sprintf( buf, "%d", man.tasks.num );
        SetDlgItemText( hwnd, ID_ONLINE_EDIT, buf );
        sprintf( buf, "%d", conns_accepted );
        SetDlgItemText( hwnd, ID_TOTAL_EDIT, buf );

        for ( i=0; i<STORAGE_NUM; i++ )
        {
            sprintf( buf, "%d", storage_counter[i] );
            SetDlgItemText( hwnd, ID_STORAGE_EDIT+i+i, buf );
        }
        break;

    default:
        return DefWindowProc( hwnd, msg, wparam, lparam );
    }

    return 0;
}

BOOL InitWindow( HINSTANCE hinst )
{
    WNDCLASS wc;

    wc.style        = 0;
    wc.lpfnWndProc  = WinProc;
    wc.cbClsExtra   = 0;
    wc.cbWndExtra   = 0;
    wc.hInstance    = hinst;
    wc.hIcon        = LoadIcon( hinst, MAKEINTRESOURCE(1) );
    wc.hCursor      = LoadCursor( 0, IDC_ARROW );
    wc.hbrBackground = (HBRUSH)(COLOR_BTNFACE + 1);
    wc.lpszMenuName = 0;
    wc.lpszClassName = szClassName;

    hicon = wc.hIcon;

    return RegisterClass( &wc );
}

#define WIN_WIDTH 454
#define WIN_HEIGHT 300

void CreateControls( HINSTANCE hinst, HWND hwnd, HFONT hfont )
{
    char buf[32];
    int i;
    static char *storage_label[STORAGE_NUM] = {
        "files", "blocks", "Confs", "Caches", "Tasks"
    };

    CreateWindowEx(
        0, "STATIC", "#1",
        WS_CHILD | SS_ICON | SS_CENTERIMAGE | WS_VISIBLE,
        10, 10, 40, 24+30,
        hwnd, (HMENU)-1, hinst, 0 );

    CreateWindowEx(
        0, "STATIC", "Root Directory",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        60, 10+3, 95, 24,
        hwnd, (HMENU)ID_ROOT_LABEL, hinst, 0 );

    CreateWindowEx(
        WS_EX_CLIENTEDGE, "EDIT", "",
        WS_CHILD | WS_TABSTOP | ES_LEFT,
        155, 10, WIN_WIDTH-235, 24,
        hwnd, (HMENU)ID_ROOT_EDIT, hinst, 0 );

    CreateWindowEx(
        0, "BUTTON", "Browse",
        WS_CHILD | WS_TABSTOP | BS_PUSHBUTTON | BS_CENTER | BS_TEXT,
        WIN_WIDTH-75, 10, 60, 24,
        hwnd, (HMENU)ID_ROOT_BROWSE, hinst, 0 );

    CreateWindowEx(
        0, "STATIC", "Default page",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        60, 40+3, 95, 24,
        hwnd, (HMENU)ID_INDEX_LABEL, hinst, 0 );

    CreateWindowEx(
        WS_EX_CLIENTEDGE, "EDIT", "",
        WS_CHILD | WS_TABSTOP | ES_LEFT,
        155, 40, WIN_WIDTH-155-140-25, 24,
        hwnd, (HMENU)ID_INDEX_EDIT, hinst, 0 );

    CreateWindowEx(
        0, "STATIC", "Port",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        WIN_WIDTH-140, 40+3, 35, 24,
        hwnd, (HMENU)ID_PORT_LABEL, hinst, 0 );

    CreateWindowEx(
        WS_EX_CLIENTEDGE, "EDIT", "",
        WS_CHILD | WS_TABSTOP | ES_LEFT,
        WIN_WIDTH-95, 40, 80, 24,
        hwnd, (HMENU)ID_PORT_EDIT, hinst, 0 );


    CreateWindowEx(
        0, "STATIC", "Memory Usage",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        10+20, 90+3, 130, 24,
        hwnd, (HMENU)ID_USAGE_LABEL, hinst, 0 );
    CreateWindowEx(
        0, "STATIC", "Statistics",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        160+30, 90+3, 130, 24,
        hwnd, (HMENU)ID_IOBYTES_LABEL, hinst, 0 );
    CreateWindowEx(
        0, "STATIC", "Connections",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        310+30, 90+3, 130, 24,
        hwnd, (HMENU)ID_CONN_LABEL, hinst, 0 );
    CreateWindowEx(
        0, "STATIC", "",
        WS_CHILD | SS_CENTER,
        180, 180+3, WIN_WIDTH-195, 24,
        hwnd, (HMENU)ID_HELP_LABEL, hinst, 0 );


    CreateWindowEx(
        0, "STATIC", "Sent",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        160, 120+3, 40, 24,
        hwnd, (HMENU)ID_SENT_LABEL, hinst, 0 );

    CreateWindowEx(
        WS_EX_CLIENTEDGE, "EDIT", "0",
        WS_CHILD | ES_LEFT | ES_READONLY,
        210, 120, 80, 24,
        hwnd, (HMENU)ID_SENT_EDIT, hinst, 0 );

    CreateWindowEx(
        0, "STATIC", "Recv",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        160, 150+3, 40, 24,
        hwnd, (HMENU)ID_RECV_LABEL, hinst, 0 );

    CreateWindowEx(
        WS_EX_CLIENTEDGE, "EDIT", "0",
        WS_CHILD | ES_LEFT | ES_READONLY,
        210, 150, 80, 24,
        hwnd, (HMENU)ID_RECV_EDIT, hinst, 0 );

    CreateWindowEx(
        0, "STATIC", "Online",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        310, 120+3, 40, 24,
        hwnd, (HMENU)ID_ONLINE_LABEL, hinst, 0 );

    CreateWindowEx(
        WS_EX_CLIENTEDGE, "EDIT", "0",
        WS_CHILD | ES_LEFT | ES_READONLY,
        360, 120, 80, 24,
        hwnd, (HMENU)ID_ONLINE_EDIT, hinst, 0 );

    CreateWindowEx(
        0, "STATIC", "Total",
        WS_CHILD | SS_SIMPLE | SS_LEFT,
        310, 150+3, 40, 24,
        hwnd, (HMENU)ID_TOTAL_LABEL, hinst, 0 );

    CreateWindowEx(
        WS_EX_CLIENTEDGE, "EDIT", "0",
        WS_CHILD | ES_LEFT | ES_READONLY,
        360, 150, 80, 24,
        hwnd, (HMENU)ID_TOTAL_EDIT, hinst, 0 );

    for ( i=0; i<STORAGE_NUM; i++ )
    {
        CreateWindowEx(
            0, "STATIC", storage_label[i],
            WS_CHILD | SS_SIMPLE | SS_LEFT,
            10, 120+3+i*30, 50, 24,
            hwnd, (HMENU)(ID_STORAGE_LABEL+i+i), hinst, 0 );

        CreateWindowEx(
            WS_EX_CLIENTEDGE, "EDIT", "0",
            WS_CHILD | ES_LEFT | ES_READONLY,
            60, 120+i*30, 80, 24,
            hwnd, (HMENU)(ID_STORAGE_EDIT+i+i), hinst, 0 );
    }

    CreateWindowEx(
        0, "BUTTON", "Clean Cache",
        WS_CHILD | WS_TABSTOP | BS_PUSHBUTTON | BS_CENTER | BS_TEXT,
        180, 240, 100, 24,
        hwnd, (HMENU)ID_CLEAN_CACHE, hinst, 0 );

    CreateWindowEx(
        0, "BUTTON", "Start " FULL_APP_NAME,
        WS_CHILD | WS_TABSTOP | BS_PUSHBUTTON | BS_CENTER | BS_TEXT,
        180, 210, WIN_WIDTH-195, 24,
        hwnd, (HMENU)ID_START_BUTTON, hinst, 0 );

    CreateWindowEx(
        0, "BUTTON", "Close",
        WS_CHILD | WS_TABSTOP | BS_PUSHBUTTON | BS_CENTER | BS_TEXT,
        380, 240, WIN_WIDTH-395, 24,
        hwnd, (HMENU)ID_CLOSE_BUTTON, hinst, 0 );

    CreateWindowEx(
        0, "BUTTON", "About",
        WS_CHILD | WS_TABSTOP | BS_PUSHBUTTON | BS_CENTER | BS_TEXT,
        290, 240, 80, 24,
        hwnd, (HMENU)ID_ABOUT_BUTTON, hinst, 0 );

    for ( i=0; i<ID_NUM; i++ )
    {
        SendDlgItemMessage( hwnd, i, WM_SETFONT, (WPARAM)hfont,
                            MAKELPARAM( TRUE, 0 ) );
        ShowWindow( GetDlgItem( hwnd, i ), SW_SHOW );
    }

    CONFIG_INIT();
    validate_config( CONFIG, work_dir );
    sprintf( buf, "%d", CONFIG_OF(server_port) );
    SetDlgItemText( hwnd, ID_ROOT_EDIT, work_dir );
    SetDlgItemText( hwnd, ID_PORT_EDIT, buf );
    SetDlgItemText( hwnd, ID_INDEX_EDIT, CONFIG_OF(index_file) );
    CONFIG_CLEANUP();

    EnableWindow( GetDlgItem(hwnd, ID_CLEAN_CACHE), FALSE );
}

int WINAPI WinMain( HINSTANCE hinst, HINSTANCE hinstPrev,
                    LPSTR lpcmd, int nCmdShow )
{
    static NOTIFYICONDATA nid;
    HWND hwnd;
    MSG msg;
    HFONT hfont;
    HANDLE hmutex;

    if ( !InitWindow( hinst ) )
        return FALSE;

    hmutex = CreateMutex(NULL, FALSE, szClassName );
    if( GetLastError() == ERROR_ALREADY_EXISTS )
    {
        if ( hmutex )
            CloseHandle( hmutex );
        MessageBox( NULL,
                    "You can't start the second copy of this application.",
                    FULL_APP_NAME, MB_OK | MB_ICONEXCLAMATION );
        return FALSE;
    }

    hwnd = CreateWindow(
        szClassName, szWindowName,
        WS_CAPTION | WS_SYSMENU
        | DS_3DLOOK | DS_MODALFRAME,
        ( GetSystemMetrics( SM_CXMAXIMIZED ) - WIN_WIDTH ) / 2,
        ( GetSystemMetrics( SM_CYMAXIMIZED ) - WIN_HEIGHT ) / 2,
        WIN_WIDTH, WIN_HEIGHT,
        NULL, NULL, hinst, 0 );

    hfont = CreateFont(
        16, 0, 0, 0, FW_MEDIUM, FALSE, FALSE, FALSE,
        DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
        DEFAULT_QUALITY, FF_DONTCARE, "Times" );

    CreateControls( hinst, hwnd, hfont );

    if ( !hwnd )
        return FALSE;

    man.sys.hwnd = hwnd;
    ShowWindow( hwnd, SW_SHOW );

    nid.cbSize = sizeof(nid);
    nid.hWnd = hwnd;
    nid.uID = 0;
    nid.uFlags = NIF_ICON | NIF_TIP | NIF_MESSAGE;
    nid.uCallbackMessage = WM_TRAYMSG;
    nid.hIcon = hicon;
    strcpy( nid.szTip, FULL_APP_NAME );

    flag_trayicon = Shell_NotifyIcon( NIM_ADD, &nid );

    while ( GetMessage( &msg, NULL, 0, 0 ) )
    {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
    }

    if ( flag_trayicon )
        Shell_NotifyIcon( NIM_DELETE, &nid );

    DeleteObject( hfont );

    if ( flag_on )
        httpd_stop();

    if ( hmutex )
        CloseHandle( hmutex );

    return msg.wParam;
}

