/*
 * mkrc.c: the helper program that generate resource file from images
 *
 * Hanhua Feng
 * $Id: mkrc.c,v 1.8 2003/05/21 14:59:39 hanhua Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int main( int argc, char *argv[] )
{
    char fnw[256] = "";
    char fnh[256];
    char path[256] = "";
    char buf[4096];
    char *p, *pt, *pa, *pb, *fnr = 0;
    size_t len, p_len;
    FILE *fpr, *fpw, *fph;
    int i, help, flag;   /* flag to indicate whether it is in {} or not */
    int use_cr = 0, win32 = 0, retval = 0;

    help = 0;
    for ( i=1; i<argc; i++ )
    {
        if ( '-' == argv[i][0] )
        {
            switch( argv[i][1] )
            {
            case 'r': use_cr = 1; break;
            case 'w': win32 = 1; break;
            default: break;
            }
        }
        else if ( !fnr )
            fnr = argv[i];
        else if ( '\0' == fnw[0] )
        {
            strncpy( fnw, argv[i], sizeof(fnw)-8 );
            fnw[sizeof(fnw)-8] = '\0';
        }
        else
            help = 1;
    }

    if ( !fnr || help )
    {
        printf( "Usage:\t%s <source> [<dest>]\n", argv[0] );
        return -1;
    }

    fpr = fopen( fnr, "rt" );
    if ( !fpr )
    {
        printf( "%s: no such file.\n", fnr );
        return -1;
    }


    if ( fnw[0] )
    {
        len = strlen( fnw );
        p = fnw + len;
    }
    else
    {
        len = strlen( fnr );
        if ( len >= sizeof(fnw)-12 )
        {
            printf( "%s: file name too long.\n", fnr );
            return -1;
        }

        strcpy( fnw, fnr );
        p = strrchr( fnw, '/' );
        if ( !p )
            p = strrchr( fnw, '\\' );
        if ( !p )
            p = fnw;
        else
        {
            p++;

            memcpy( path, fnw, p-fnw );
            path[p-fnw] = '\0';
        }

        p_len = strlen(p);
        memmove( p+3, p, p_len+1 );
        memcpy( p, "rc_", 3 );

        len += 3;
        p = strrchr( p+3, '.' );
        if ( !p )
            p = fnw + len;
    }

    strcpy( p, ".h" );
    strcpy( fnh, fnw );
    if ( win32)
    {
        strcpy( p, ".rc" );
    }
    else
    {
        strcpy( p, ".c" );
    }

    fph = fopen( fnh, "wt" );
    if ( !fph )
    {
        printf( "%s: unwritable.\n", fnw );
        fclose( fpr );
        return -1;
    }

    fpw = fopen( fnw, "wt" );
    if ( !fpw )
    {
        printf( "%s: unwritable.\n", fnw );
        fclose( fph );
        fclose( fpr );
        return -1;
    }

    if ( win32)
    {
        /* ... */
    }
    else
    {
        fprintf( fph,
                 "/* %s\n * This file is generated by " __FILE__ "\n *"
                 "$Id: mkrc.c,v 1.8 2003/05/21 14:59:39 hanhua Exp $"
                 "\n */\n\n",
                 fnh );

        fprintf( fph, "#define RC_GET(x) (rc_##x)\n"
                      "#define RC_SIZE(x) (sizeof(rc_##x))\n\n" );

        fprintf( fpw,
                 "/* %s\n * This file is generated by " __FILE__ "\n * "
                 "$Id: mkrc.c,v 1.8 2003/05/21 14:59:39 hanhua Exp $"
                 "\n */\n\n",
                 fnw );
    }

    for ( flag = 0; fgets( buf, sizeof(buf), fpr ); )
    {
        len = strlen( buf );
        if ( '\n' == buf[len-1] || '\r' == buf[len-1] )
            buf[len-1] = '\0';

        if ( '@' == buf[0] )
        {
            if ( flag )
            {
                flag = 0;
                if ( win32 )
                {
                    /* ... */
                }
                else
                {
                    fprintf( fpw, ";\n\n" );
                }
            }

            for ( p=buf+1; isascii(*p) && isspace(*p); p++ )
                ;
            for ( pt = p; ( isascii(*pt) && isalnum(*pt) ) || '_' == (*pt); pt++ )
                ;
            for ( pa = pt; isascii(*pa) && isspace(*pa); pa++ )
                ;
            if ( (*pa) == '@' )
            {
                pa++;
                for ( ; isascii(*pa) && isspace(*pa); pa++ )
                    ;
                for ( pb = pa; isascii(*pb) && isprint(*pb) && !isspace(*pb); )
                    pb++;
                *pb = '\0';
                if ( !(*pa) )
                    pa = 0;
            }
            else
                pa = 0;

            *pt = '\0';

            if ( !(*p) )
                continue;


            if ( pa )
            {
                /* in a binary file */
                if ( win32 )
                {
                    /* ... */
                }
                else
                {
                    int i, j, sz, n;
                    FILE *fpa;
                    unsigned char buf[16];

                    flag = 0;

                    fpa = fopen( pa, "rb" );
                    if ( !fpa && path[0] )
                    {
                        char fn_buf[512];
                        strcpy( fn_buf, path );
                        strncat( fn_buf, pa, sizeof(fn_buf)-sizeof(path) );
                        fpa = fopen( fn_buf, "rb" );
                    }
                    if ( !fpa )
                    {
                        fprintf( stderr, "Warning: file %s not found.\n", pa );
                        retval++;
                        continue;
                    }

                    fseek( fpa, 0, SEEK_END );
                    sz = ftell( fpa );
                    fseek( fpa, 0, SEEK_SET );

                    fprintf( fpw, "const unsigned char rc_%s[%d] = {\n",
                             p, sz );
                    for ( i=0; i<sz; i += n )
                    {
                        n = fread( buf, 1, sizeof(buf), fpa );
                        if ( 0 == n )
                        {
                            fprintf( stderr, "Warning: %s size not match.\n",
                                     pa );
                            break;
                        }
                        fprintf( fpw, "    " );
                        for ( j=0; ; j++ )
                        {
                            fprintf( fpw, "%d", buf[j] );
                            if ( j >= n-1 )
                                break;
                            fprintf( fpw, "," );
                        }

                        if ( i + n >= sz )
                            fprintf( fpw, "\n" );
                        else
                            fprintf( fpw, ",\n" );
                    }
                    fprintf( fpw, "};\n\n" );

                    fclose( fpa );

                    fprintf( fph, "extern const unsigned char rc_%s[%d];\n",
                             p, sz );
                }
            }
            else
            {
                if ( win32 )
                {
                    /* ... */
                }
                else
                {
                    fprintf( fph, "extern const char *rc_%s;\n", p );
                    fprintf( fpw, "const char *rc_%s =", p );
                }

                flag = 1;
            }
        }
        else if ( flag )
        {
            if ( win32 )
            {
            }
            else
            {
               fprintf( fpw, "\n    \"%s\\n\"", buf );
            }
        }
    }

    if ( flag )
    {
        if ( win32 )
        {
        }
        else
        {
            fprintf( fpw, ";\n\n" );
        }
    }

    fclose( fpw );
    fclose( fph );
    fclose( fpr );

    return retval;
}
