# Makfile for Borland C 5.5.1
SRCDIR   = ..

TARGET   = htzipd.exe
MOBJECTS = error.o file.o htconfig.o htmlgen.o htproc.o \
           httpd.o htutil.o mime.o task.o winskt.o zip.o
OBJECTS  = $(MOBJECTS) rc_template.o

RC       = windres
CC       = gcc
CFLAGS   = -I. -Wall -DWIN32 -mwindows -mwin32 -g -DDEBUG
LD       = gcc
LFLAGS   = -L. -lz -lws2_32 -lole32

.SUFFIXES: .c

%.o: $(SRCDIR)/%.c
	$(CC) -c $(CFLAGS) $<

all: $(TARGET)

htzipd.o: $(SRCDIR)/main.rc
	$(RC) --include-dir=$(SRCDIR) -o $@ $(SRCDIR)/main.rc

$(MOBJECTS): $(SRCDIR)/rc_template.h

$(SRCDIR)/rc_template.c $(SRCDIR)/rc_template.h: $(SRCDIR)/mkrc.c $(SRCDIR)/template.txt
	$(CC) -o mkrc.exe $(SRCDIR)/mkrc.c
	.\mkrc.exe $(SRCDIR)/template.txt

$(TARGET): $(OBJECTS) htzipd.o
	$(LD) -o $(TARGET) $Q $(CFLAGS) $(OBJECTS) htzipd.o $(LFLAGS)

clean:
	del *.o
	del $(TARGET)
	del mkrc.exe
