#ifndef _HTCONFIG_H
#define _HTCONFIG_H

#define CONFIG_STORAGE ((void *)(storage_counter+2))

typedef struct tag_configentry {
    char *name;      /* lower case only */
    const char *rname;     /* real name, lower or upper case */
    char *value;
    const char *def;       /* if this is set, use this default value */
    int family;
    struct tag_configentry *hash_next, *prev, *next;
} configentry;

#define MAX_DIRTABLE_NUM 17

enum { FAM_HTTPD=0, FAM_DIR, FAM_INDEX, FAMILY_NUM };


typedef struct {
    int num;
    int tablesize;
    configentry **table;

    configentry *family[FAMILY_NUM];

    /* httpd */
    int server_port;
    const char *server_name;
    int conn_timeout;

    /* directory */
    const char *uri_mapping[MAX_DIRTABLE_NUM*2+2];
    const char *allow_path[MAX_DIRTABLE_NUM+1];

    /* index */
    const char *index_file;
    const char *readme_file;
    const char *index_templ;
    const char *index_templ_dir;
    const char *index_templ_file;
    const char *index_templ_other;
    const char *index_templ_zip;

} htconfig;


#define TAG_SERVER_PORT "ServerPort"
#define TAG_SERVER_NAME "ServerName"
#define TAG_CONNECTION_TIMEOUT "ConnectionTimeOut"
#define TAG_URI_MAPPING "URIMapping"
#define TAG_ALLOW_PATH  "AllowPath"
#define TAG_INDEX_FILE  "IndexFile"
#define TAG_README_FILE "ReadMeFile"
#define TAG_INDEX_TEMPLATE       "IndexTemplate"
#define TAG_INDEX_TEMPLATE_FILE  "IndexTemplateFile"
#define TAG_INDEX_TEMPLATE_DIR   "IndexTemplateDir"
#define TAG_INDEX_TEMPLATE_OTHER "IndexTemplateOther"
#define TAG_INDEX_TEMPLATE_ZIP   "IndexTemplateZip"


int load_config_file( htconfig *conf, const char *file );
int save_config_file( htconfig *conf, const char *file );
void validate_config( htconfig *conf, const char *work_dir );


extern htconfig config;

#define CONFIG_OF(x) (config.x)
#define CONFIG_OF_STR(x,p)                          \
    do {                                            \
        configentry *ce; HASH_FIND(config,x,ce);    \
        if ( ce ) p=ce->def ? ce->def : ce->name;   \
        else p = 0;                                 \
    } while(0)

#define CONFIG_INIT() HASH_INIT(config,100)
#define CONFIG_CLEANUP()                                            \
    do { configentry *ce;                                           \
        HASH_CLEANUP_WITH(config,ce,(htfree(CONFIG_STORAGE,ce)));   \
    } while (0)

#define CONFIG (&config)

#endif
