/*
 * genio.c: general socket i/o and main routine
 *
 * Hanhua Feng
 * $Id: genio.c,v 1.4 2003/05/21 14:59:39 hanhua Exp $
 */
#include <stdio.h>
#include <string.h>
#include "htutil.h"
#include "htconfig.h"
#include "htzipd.h"

void enable_conn_input( htman *man, taskentry *tsk )
{
#ifdef DEBUG
    fprintf( stderr, ">>> Task %s: reading input.\n", tsk->name );
#endif
}

void disable_conn_input( htman *man, taskentry *tsk )
{
#ifdef DEBUG
    fprintf( stderr, ">>> Task %s: input end.\n", tsk->name );
#endif
}

void enable_conn_output( htman *man, taskentry *tsk )
{
#ifdef DEBUG
    fprintf( stderr, ">>> Task %s: sending output.\n", tsk->name );
#endif
}

void disable_conn_output( htman *man, taskentry *tsk )
{
#ifdef DEBUG
    fprintf( stderr, ">>> Task %s: output end.\n", tsk->name );
#endif
}

int conn_flag = 1;

void end_conn( htman *man, taskentry *tsk )
{
    conn_flag = 0;

#ifdef DEBUG
    fprintf( stderr, ">>> Task %s: terminating current session.\n",
             tsk->name );
#endif
}

htman man;

int main( int argc, char *argv[] )
{
    int n;
    taskentry *tsk;

    if ( argc < 2 )
        return 0;

    fprintf( stderr, ">>> Initiating structure htman...\n" );
    htman_init( &man, argv[1] );

    fprintf( stderr, ">>> Initiating configuration...\n" );
    CONFIG_INIT();
    validate_config( CONFIG, argv[1] );

    fprintf( stderr, ">>> Creating task...\n" );
    start_task( &man, tsk = task_new( int_to_hex_str(0) ) );

    while ( conn_flag )
    {
        fprintf( stderr, ">>> reading stdin...\n" );
        do
        {
            if ( !fgets( tsk->in_buf + tsk->in_head,
                         tsk->in_buf_size - tsk->in_head, stdin ) )
            {
                end_task( &man, tsk );
                break;
            }

            tsk->in_head += strlen( tsk->in_buf + tsk->in_head );
            n = exec_task( &man, tsk );
            if ( n == REQ_ERR )
            {
                fprintf( stderr, ">>>Task %s: error in request.\n",
                         tsk->name );
                break;
            }
        }
        while( n != REQ_OK );

        if ( !conn_flag )
            break;

        fprintf( stderr, ">>> writing stdout...\n" );
        do
        {
            n = exec_task( &man, tsk );
            if ( n == REQ_CONT || n == REQ_END )
            {
                fwrite( tsk->out_buf, 1, tsk->out_len, stdout );
                tsk->out_len = 0;
            }
        } while ( n != REQ_CONT );
    }

    fprintf( stderr, ">>> cleaning up...\n" );
    CONFIG_CLEANUP();
    htman_cleanup( &man );

    return 0;
}
