# Makfile for Borland C 5.5.1

SRCDIR   = ..

TARGET   = htzipd.exe
MOBJECTS = error.obj file.obj htconfig.obj htmlgen.obj htproc.obj \
           httpd.obj htutil.obj mime.obj task.obj winskt.obj zip.obj
OBJECTS  = $(MOBJECTS) rc_template.obj

RC       = brcc32
CC       = bcc32
LD       = ilink32

!ifdef DEBUG
CFLAGS   = -v -DWIN32 -w-8060 -w-8057 -I. -W -DDEBUG
LFLAGS   = -aa -Gn -v -x
!else
CFLAGS   = -DWIN32 -w-8060 -w-8057 -I. -W -O2
LFLAGS   = -aa -Gn -x
!endif

.autodepend

.SUFFIXES: .c

{$(SRCDIR)\}.c.obj:
    @$(CC) -c $(CFLAGS) $<

all: $(TARGET)

htzipd.res: $(SRCDIR)\main.rc
    @$(RC) -fo$@ -I$(MAKEDIR)\..\include $(SRCDIR)\main.rc

$(TARGET): $(OBJECTS) htzipd.res
    @$(LD) $(LFLAGS) c0w32.obj $(OBJECTS), $@, , ZLIBBC32.lib import32.lib ws2_32.lib cw32.lib, , htzipd.res

$(MOBJECTS): $(SRCDIR)\rc_template.h

$(SRCDIR)\rc_template.c $(SRCDIR)\rc_template.h: $(SRCDIR)\mkrc.c $(SRCDIR)\template.txt
    @$(CC) $(SRCDIR)\mkrc.c
    .\mkrc $(SRCDIR)\template.txt

clean:
    del *.obj
    del *.exe
    del *.td?
    del *.tr2
    del *.res
