/*
 * Decompiled with CFR 0.152.
 */
package net.lamot.java.jskype.windows;

import java.util.Vector;
import net.lamot.java.jskype.general.AbstractMessenger;

public class Messenger
extends AbstractMessenger {
    private static Vector listeners = new Vector();
    private static Messenger _instance = null;

    public boolean initialize() {
        System.out.println("Messenger.initialize()");
        _instance = this;
        try {
            System.loadLibrary("JSkype");
            Messenger.nativeInit();
        }
        catch (UnsatisfiedLinkError x) {
            x.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean sendMessage(String message) {
        System.out.println("Messenger.sendMessage()");
        try {
            Messenger.nativeSendMessage(message.trim() + " ");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void destroy() {
        System.out.println("Messenger.destroy()");
        try {
            Messenger.nativeDestroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static synchronized native int nativeSendMessage(String var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeDestroy() throws UnsatisfiedLinkError;

    private static synchronized native int nativeInit() throws UnsatisfiedLinkError;

    public static void onCallback(int skypeID, String message) {
        System.out.println("Messenger.onWindowsMessage(); Message from Skype(" + skypeID + "): " + message);
        _instance.onMessageReceived(message);
    }

    public static void onSkypeFound() {
        System.out.println("Skype instance found");
        _instance.onMessageReceived("SkypeControlAPI");
    }
}

