/*
 * Decompiled with CFR 0.152.
 */
package net.lamot.java.jskype.swtclient;

import net.lamot.java.jskype.general.AbstractMessenger;
import net.lamot.java.jskype.general.MessageListenerInterface;
import net.lamot.java.jskype.swtclient.Popup;
import net.lamot.java.jskype.windows.Messenger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class swtChatWindow
implements MessageListenerInterface {
    private static swtChatWindow _instance = null;
    private static Shell shell = null;
    private static final int WINDOW_WIDTH = 500;
    private static final int WINDOW_HEIGHT = 200;
    private static Display display = null;
    private Button sendButton = null;
    private Text inputText = null;
    private Text outputText = null;
    private Popup popup = null;
    private int FONT_SIZE = 10;
    private AbstractMessenger msgr = new Messenger();

    private void init() {
        this.popup = new Popup();
        FormLayout layout = new FormLayout();
        shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                shell.setText("" + shell.getSize().x + "," + shell.getSize().y);
            }
        });
        this.sendButton = new Button((Composite)shell, 8);
        this.inputText = new Text((Composite)shell, 2052);
        this.outputText = new Text((Composite)shell, 2626);
        this.sendButton.setText("&Send");
        this.sendButton.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                swtChatWindow.this.onSendButton();
            }
        });
        FormData sendButtonData = new FormData();
        sendButtonData.right = new FormAttachment(100, 0);
        sendButtonData.bottom = new FormAttachment(100, 0);
        sendButtonData.top = new FormAttachment((Control)this.outputText, layout.marginHeight);
        this.sendButton.setLayoutData((Object)sendButtonData);
        FormData inputTextData = new FormData();
        inputTextData.left = new FormAttachment(0, 0);
        inputTextData.right = new FormAttachment((Control)this.sendButton, -layout.marginWidth);
        inputTextData.bottom = new FormAttachment(100, 0);
        this.inputText.setLayoutData((Object)inputTextData);
        this.inputText.forceFocus();
        FormData outputTextData = new FormData();
        outputTextData.top = new FormAttachment(0, 0);
        outputTextData.left = new FormAttachment(0, 0);
        outputTextData.right = new FormAttachment(100, 0);
        outputTextData.bottom = new FormAttachment((Control)this.inputText, -layout.marginHeight);
        this.outputText.setLayoutData((Object)outputTextData);
        this.outputText.setText("");
        this.outputText.setEditable(false);
        Font initialFont = this.outputText.getFont();
        FontData[] fontData = initialFont.getFontData();
        for (int i = 0; i < fontData.length; ++i) {
            fontData[i].setHeight(this.FONT_SIZE);
        }
        Font newFont = new Font((Device)display, fontData[0]);
        this.outputText.setFont(newFont);
        shell.setDefaultButton(this.sendButton);
        shell.setSize(500, 200);
        shell.setLayout((Layout)layout);
        shell.open();
    }

    private void onSendButton() {
        final String msg = this.inputText.getText();
        System.out.println("onSendButton -->" + msg + "<--");
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    swtChatWindow.this.msgr.sendMessage(msg);
                    swtChatWindow.this.inputText.setFocus();
                    swtChatWindow.this.outputText.setSelection(swtChatWindow.this.outputText.getCharCount(), swtChatWindow.this.outputText.getCharCount());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void displayMessage(final String msg) {
        if (msg != null && msg.length() > 0) {
            display.asyncExec(new Runnable(){

                public void run() {
                    swtChatWindow.this.outputText.append(msg + "\r\n");
                    swtChatWindow.this.inputText.setFocus();
                    shell.forceActive();
                    swtChatWindow.this.outputText.setSelection(swtChatWindow.this.outputText.getCharCount(), swtChatWindow.this.outputText.getCharCount());
                }
            });
        }
    }

    public static void main(String[] args) {
        display = new Display();
        shell = new Shell(display);
        swtChatWindow my_main = new swtChatWindow();
        my_main.dostuff();
        my_main.init();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        my_main.destroy();
        display.dispose();
        System.exit(0);
    }

    private void destroy() {
        System.out.println("(swt)Main.destroy()");
        this.msgr.removeListener(this);
        this.msgr.destroy();
    }

    private void dostuff() {
        this.msgr = new Messenger();
        this.msgr.addListener(this);
        this.msgr.initialize();
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onMessageReceived(String message) {
        if (message.equalsIgnoreCase("SkypeControlAPI")) {
            this.sleep(2000);
        } else {
            this.displayMessage(message);
        }
    }
}

