package net.lamot.java.jskype.swtclient;

import net.lamot.java.jskype.general.AbstractMessenger;
import net.lamot.java.jskype.general.MessageListenerInterface;
import net.lamot.java.jskype.windows.Messenger;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;


/**
 * Copyright (C) 2004  B. Lamot
 ***********************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 ************************************************************
 *
 * Part of the swt client example.
 * This is a window with a display text area and a input field.
 *
 */
public class swtChatWindow implements MessageListenerInterface {
    
    private static swtChatWindow _instance = null;
    private static Shell shell = null;
    //private swtGUI parentWindow = null;
    private static final int WINDOW_WIDTH = 500;
    private static final int WINDOW_HEIGHT = 200;
    private static Display display = null;
    private Button sendButton = null;
    private Text inputText = null;
    private Text outputText = null;
    private Popup popup = null;
    private int FONT_SIZE = 10;
    
    private AbstractMessenger msgr = new Messenger();
    
    private void init() {
        popup = new Popup();
        FormLayout layout = new FormLayout();
        
        //The title of the window shows the size
        shell.addListener(SWT.Resize, new Listener() {
            public void handleEvent(Event e) {
                shell.setText("" + shell.getSize().x + "," + shell.getSize().y);
            }
        });
        
        
        //create the OK button
        sendButton = new Button(shell, SWT.PUSH);
        inputText = new Text(shell, SWT.SINGLE | SWT.BORDER);
        outputText = new Text(shell, SWT.BORDER | SWT.WRAP | SWT.MULTI | SWT.V_SCROLL);
        
        sendButton.setText("&Send");
        sendButton.addListener(SWT.MouseDown, new Listener() {
            public void handleEvent(Event e) {
                onSendButton();
            }
        });
        FormData sendButtonData = new FormData();
        sendButtonData.right = new FormAttachment(100, 0);
        sendButtonData.bottom = new FormAttachment(100, 0);
        sendButtonData.top = new FormAttachment(outputText, layout.marginHeight);
        sendButton.setLayoutData(sendButtonData);
        
        
        FormData inputTextData = new FormData();
        inputTextData.left = new FormAttachment(0, 0);
        inputTextData.right = new FormAttachment(sendButton, -layout.marginWidth);
        inputTextData.bottom = new FormAttachment(100, 0);
        inputText.setLayoutData(inputTextData);
        inputText.forceFocus();
        
        FormData outputTextData = new FormData();
        outputTextData.top = new FormAttachment(0, 0);
        outputTextData.left = new FormAttachment(0, 0);
        outputTextData.right = new FormAttachment(100, 0);
        outputTextData.bottom = new FormAttachment(inputText, -layout.marginHeight);
        outputText.setLayoutData(outputTextData);
        outputText.setText("");
        outputText.setEditable(false);
        
        
        Font initialFont = outputText.getFont();
        FontData[] fontData = initialFont.getFontData();
        for (int i = 0; i < fontData.length; i++) {
            fontData[i].setHeight(FONT_SIZE);
        }
        Font newFont = new Font(display, fontData[0]);
        outputText.setFont(newFont);
        
        
        shell.setDefaultButton(sendButton);
        //And finally build the window on the screen.
        shell.setSize(WINDOW_WIDTH, WINDOW_HEIGHT);
        shell.setLayout(layout);
        shell.open();
        
        //return shell;
        
    }
    
    private void onSendButton() {
        final String msg = inputText.getText();
        System.out.println("onSendButton -->"+msg+"<--");
        display.asyncExec(new Runnable() {
            public void run() {
                
                try {
                    //send the msg
                    msgr.sendMessage(msg);
                    //inputText.setText("");
                    inputText.setFocus();
                    outputText.setSelection(outputText.getCharCount(), outputText.getCharCount());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        
    }
    
    public void displayMessage(final String msg) {
        //System.out.println("swtChatWindow.displayMessage() enter");
        if (msg != null && msg.length() > 0) {
            display.asyncExec(new Runnable() {
                public void run() {
                    outputText.append(msg + "\r\n");
                    inputText.setFocus();
                    shell.forceActive();
                    outputText.setSelection(outputText.getCharCount(), outputText.getCharCount());
                }
            });
        }
    }
    
    public static void main(String args[]) {
        display = new Display();
        shell = new Shell(display);
        swtChatWindow my_main = new swtChatWindow();
        my_main.dostuff();
        my_main.init();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch())
                display.sleep();
        }
        my_main.destroy();
        display.dispose();
        System.exit(0);
    }
    
    /**
     *
     */
    private void destroy() {
        System.out.println("(swt)Main.destroy()");
        msgr.removeListener(this);
        msgr.destroy();
    }
    
    /**
     *
     */
    private void dostuff() {
        msgr = new Messenger();
        msgr.addListener(this);
        msgr.initialize();
    }
    
    private void sleep (int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
        /*
         * (non-Javadoc)
         *
         * @see net.lamot.java.jskype.general.MessageListenerInterface#onMessageReceived(java.lang.String)
         */
    public void onMessageReceived(String message) {
        //System.out.println("Got a message: " + message );
        if (message.equalsIgnoreCase("SkypeControlAPI")) {
            sleep (2000); // added by Wei Li
            //msgr.sendMessage("GET CURRENTUSERHANDLE");
            //msgr.sendMessage("GET USERSTATUS ");
            //msgr.sendMessage("SEARCH FRIENDS ");
        } else {
            displayMessage(message);
        }
        //popup.pop(message);
    }
    
}
