package net.lamot.java.jskype.swtclient;


import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/**
 * 
 * Copyright (C) 2004  B. Lamot
 ***********************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 ************************************************************
 *
 * This is part of the swt client example.
 * This is a swt pop up window.
*/

public class Popup {

    final static Display display = Display.getDefault();
    final static private Color bgcolor = new Color(display, 205, 240, 255);
    final static private int height = 100;
    final static private int width = 100;
    final static private int FINAL_SLEEP = 2000;

    public synchronized void pop(final String textStr) {
        final Shell[] splash = new Shell[]{null};
        final Image[] image = new Image[]{null};
        final Label[] textlabel = new Label[]{null};
        final int[] x = new int[]{0};
        final int[] y = new int[]{0};
        display.syncExec(new Runnable() {
            public void run() {
                splash[0] = new Shell(SWT.ON_TOP);
                textlabel[0] = new Label(splash[0], SWT.SHADOW_NONE | SWT.CENTER | SWT.WRAP);
                image[0] = new Image(display, width, height);
                textlabel[0].setText(textStr);
                textlabel[0].setBackground(bgcolor);

                GC gc = new GC(image[0]);
                gc.setBackground(bgcolor);
                gc.fillRectangle(image[0].getBounds());
                gc.dispose();
                Label label = new Label(splash[0], SWT.NONE);
                label.setImage(image[0]);

                FormLayout layout = new FormLayout();

                FormData labelData = new FormData();
                labelData.left = new FormAttachment(0, 0);
                labelData.top = new FormAttachment(0, 0);
                labelData.right = new FormAttachment(100, 0);
                labelData.bottom = new FormAttachment(100, 0);
                label.setLayoutData(labelData);

                FormData textlabeldata = new FormData();
                textlabeldata.left = new FormAttachment(0, 0);
                textlabeldata.right = new FormAttachment(100, 0);
                textlabeldata.bottom = new FormAttachment(50, 0);
                textlabel[0].setLayoutData(textlabeldata);
                splash[0].setLayout(layout);

                textlabel[0].pack();
                splash[0].pack();
                Rectangle splashRect = splash[0].getBounds();
                Rectangle displayRect = display.getClientArea();

                x[0] = ((displayRect.width - splashRect.width));
                y[0] = (displayRect.height);
                splash[0].setLocation(x[0], y[0]);
            }
        });
        for (int i = 0; i < height; i += 6) {
            final int j = i;
            display.syncExec(new Runnable() {
                public void run() {

                    splash[0].setVisible(false);
                    splash[0].setBounds(x[0], y[0] - j, width, j);
                    splash[0].setVisible(true);
                }
            });
            try {
                Thread.sleep(10);
            } catch (Throwable e) {
            }
        }

        try {
            Thread.sleep(FINAL_SLEEP);
        } catch (Throwable e) {
        }
        display.syncExec(new Runnable() {
            public void run() {

                textlabel[0].dispose();
                image[0].dispose();
                splash[0].dispose();
            }
        });
    }

}


