package net.lamot.java.jskype.swtclient;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import net.lamot.java.jskype.general.AbstractMessenger;
import net.lamot.java.jskype.general.MessageListenerInterface;
import net.lamot.java.jskype.windows.Messenger;

/**
* Copyright (C) 2004  B. Lamot
 ***********************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 ************************************************************
 *
 * An example implementation of a client.
 * This example uses the swt toolkit which is part of the eclipse IDE.
 * See www.eclipse.org for more information.
 * 
 */
public class Main implements MessageListenerInterface {
	private AbstractMessenger msgr = new Messenger();

	public static final int WINDOW_WIDTH = 200;

	public static final int WINDOW_HEIGHT = 420;

	public static final int WINDOW_INSETS = 4;

	public static void main(String args[]) {
		Display display = new Display();
		Shell shell = new Shell(display);
		Main my_main = new Main();
		my_main.dostuff();
		
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch())
				display.sleep();
		}
		my_main.destroy();
		display.dispose();
	}

	/**
	 *  
	 */
	private void destroy() {
		System.out.println("(swt)Main.destroy()");
		msgr.removeListener(this);
		msgr.destroy();
	}

	/**
	 *  
	 */
	private void dostuff() {
		msgr.addListener(this);
		msgr.initialize();
		msgr.sendMessage("GET USERSTATUS ");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see net.lamot.java.jskype.general.MessageListenerInterface#onMessageReceived(java.lang.String)
	 */
	public void onMessageReceived(String message) {
		System.out.println("Message: " + message);
		Popup popup = new Popup();
		popup.pop(message);
	}

}