#ifndef _MAIN_H
#define _MAIN_H

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <plib\sl.h>
#include <plib\sm.h>
#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glaux.h>
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>


#define SCREEN_WIDTH 1024								// We want our screen width 800 pixels
#define SCREEN_HEIGHT 735								// We want our screen height 600 pixels
#define SCREEN_DEPTH 16									// We want 16 bits per pixel

extern bool  g_bFullScreen;								// Set full screen as default
extern HWND  g_hWnd;									// This is the handle for the window
extern RECT  g_rRect;									// This holds the window dimensions
extern HDC   g_hDC;										// General HDC - (handle to device context)
extern HGLRC g_hRC;										// General OpenGL_DC - Our Rendering Context for OpenGL
extern HINSTANCE g_hInstance;							// This holds our window hInstance

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hprev, PSTR cmdline, int ishow);
LRESULT CALLBACK WinProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
WPARAM MainLoop();
void ChangeToFullScreen();
HWND CreateMyWindow(LPSTR strWindowName, int width, int height, DWORD dwStyle, bool bFullScreen, HINSTANCE hInstance);
void CreateTexture(UINT textureArray[], LPSTR strFileName, int textureID);
bool bSetupPixelFormat(HDC hdc);
void SizeOpenGLScreen(int width, int height);
void InitializeOpenGL(int width, int height);
void Init(HWND hWnd);
void DeInit();
void ProcessMouse(MSG msg);
void ProcessKeys();
void RenderWorldScene();
void RenderP1Scene();
void RenderP2Scene();
void RenderShadow();
void RenderLights();
void RenderMenuText();
void RenderText();
void RenderMenu();
void CheckPlayerKilled();

void InitializeObjects();
void ViewAll();
void ViewMenu();
void ViewWorld();
void ViewP1();
void ViewP2();
void SetOrthographicProjection();
void ResetPerspectiveProjection();
void RenderBitmapString(float x, float y, char *string);
void RenderBiggerBitmapString(float x, float y, char *string);

#endif 