#ifndef _GLWALL_H
#define _GLWALL_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library

float whitewall[4] = {1, 1, 1, 1};

class CFunWall
{
public: 
	bool destroyed;
	float posX;
	float posY;

	CFunWall(GLuint* tex, int num)
	{
		destroyed = true;
		posX = -1;
		posY = -1;

		textures = tex;
		wallTex = num;
	}

	void SetPosition(float x, float y)
	{
		destroyed = false;
		posX = (int)x + 0.5;
		posY = (int)y + 0.5;		
	}

	void Render()
	{
		float width = 0.4;
		float height = 0.3;

		if (!destroyed)
		{
			glPushMatrix();
			
			glEnable(GL_TEXTURE_2D);							
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
			glBindTexture(GL_TEXTURE_2D, textures[wallTex]);
			
			glTranslatef(posX, posY, 0);

			glBegin(GL_QUADS);
			glTexCoord2f(0, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(-width, -width, height);
			glTexCoord2f(1, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(width, -width, height);
			glTexCoord2f(1, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(width, width, height);
			glTexCoord2f(0, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(-width, width, height);
			glEnd();

			glDisable(GL_TEXTURE_2D);	
			
			glEnable(GL_TEXTURE_2D);
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
			glBindTexture(GL_TEXTURE_2D, textures[wallTex + 1]);

			glBegin(GL_QUADS);

			glTexCoord2f(0, 0);
			glNormal3f(0, -1, 0);
			glVertex3f(-width, -width, 0);
			glTexCoord2f(1, 0);
			glNormal3f(0, -1, 0);
			glVertex3f(width, -width, 0);
			glTexCoord2f(1, 1);
			glNormal3f(0, -1, 0);
			glVertex3f(width, -width, height);
			glTexCoord2f(0, 1);
			glNormal3f(0, -1, 0);
			glVertex3f(-width, -width, height);

			glTexCoord2f(0, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(-width, width, 0);
			glTexCoord2f(1, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(width, width, 0);
			glTexCoord2f(1, 1);
			glNormal3f(0, 1, 0);
			glVertex3f(width, width, height);
			glTexCoord2f(0, 1);
			glNormal3f(0, 1, 0);
			glVertex3f(-width, width, height);
			
			glTexCoord2f(0, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-width, width, 0);
			glTexCoord2f(1, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-width, -width, 0);
			glTexCoord2f(1, 1);
			glNormal3f(-1, 0, 0);
			glVertex3f(-width, -width, height);
			glTexCoord2f(0, 1);
			glNormal3f(-1, 0, 0);
			glVertex3f(-width, width, height);

			glTexCoord2f(0, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(width, width, 0);
			glTexCoord2f(1, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(width, -width, 0);
			glTexCoord2f(1, 1);
			glNormal3f(1, 0, 0);
			glVertex3f(width, -width, height);
			glTexCoord2f(0, 1);
			glNormal3f(1, 0, 0);
			glVertex3f(width, width, height);
			
			glEnd();
			glDisable(GL_TEXTURE_2D);
			glPopMatrix();
		}
	}

	private:
		GLuint* textures;
		int wallTex;
};

#endif