#ifndef _GLVECTOR_H
#define _GLVECTOR_H

#include <gl/gl.h>
#include <math.h>


class CVector3
{
public:
	CVector3() {}
	CVector3( GLfloat v[] ) 
	{
		Set( v[0], v[1], v[2] );
	}
	CVector3( GLfloat _x, GLfloat _y, GLfloat _z ) 
	{
		Set( _x, _y, _z );
	}
	void Set( GLfloat _x, GLfloat _y, GLfloat _z ) 
	{
		x = _x;
		y = _y;
		z = _z;
	}
	
	CVector3& operator = ( CVector3 v ) 
	{
		x = v.x;
		y = v.y;
		z = v.z;
		return *this;
	}
	CVector3& operator = ( GLfloat v[] ) 
	{
		x = v[0];
		y = v[1];
		z = v[2];
		return *this;
	}
	
	CVector3 operator -= ( CVector3 &v ) 
	{
		x -= v.x;
		y -= v.y;
		z -= v.z;
		return *this;
	}
	CVector3 operator += ( CVector3 &v ) 
	{
		x += v.x;
		y += v.y;
		z += v.z;
		return *this;
	}
	CVector3 operator - () 
	{
		x = -x;
		y = -y;
		z = -z;
		return *this;
	}
	CVector3 operator - ( CVector3 &v ) 
	{
		return CVector3( x - v.x,
						 y - v.y,
						 z - v.z );
	}
	CVector3 operator + ( CVector3 &v ) 
	{
		return CVector3( x + v.x,
						 y + v.y,
						 z + v.z );
	}
	CVector3 operator * ( GLfloat scalar ) 
	{
		return CVector3( x * scalar, y * scalar, z * scalar );
	}
	CVector3 operator *= ( GLfloat scalar ) 
	{
		x *= scalar;
		y *= scalar;
		z *= scalar;
		return *this;
	}
	CVector3 operator / ( GLfloat scalar ) 
	{
		return CVector3( x / scalar, y / scalar, z / scalar );
	}
	CVector3 operator /= ( GLfloat scalar ) 
	{
		x /= scalar;
		y /= scalar;
		z /= scalar;
		return *this;
	}
	friend GLfloat Dot( CVector3 &v1, CVector3 &v2 );
	friend CVector3 Cross( CVector3 &v1, CVector3 &v2 );
	GLdouble Intensity() { return sqrt( IntensitySquare() ); }
	GLfloat IntensitySquare() 
	{
		return ( x * x +
				 y * y +
				 z * z );
	}
	void Normalize() 
	{
		GLfloat i = (GLfloat)Intensity();
		x /= i;
		y /= i;
		z /= i;
	}

	GLfloat* GetArray()
	{
		theArray[0] = x;
		theArray[1] = y;
		theArray[2] = z;

		return theArray;
	}

	GLfloat x;
	GLfloat y;
	GLfloat z;
	GLfloat theArray[3];
};

inline
GLfloat Dot( CVector3 &v1, CVector3 &v2 ) 
{
	return ( v1.x * v2.x + v1.y * v2.y + v1.z * v2.z );
}

inline
CVector3 Cross( CVector3 &v1, CVector3 &v2 ) 
{
	return CVector3( v1.y * v2.z - v1.z * v2.y,
					 v1.z * v2.x - v1.x * v2.z,
					 v1.x * v2.y - v1.y * v2.x );
}

#endif // _GLVECTOR_H