#ifndef _GLTRAP_H
#define _GLTRAP_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library

float gray[4] = {0.1, 0.1, 0.1, 1};

class CFunTrap
{
public: 
	bool available;
	float posX;
	float posY;

	CFunTrap()
	{
		available = true;
		posX = -1;
		posY = -1;
	}

	void SetPosition(float x, float y)
	{
		available = false;
		posX = (int)x + 0.5;
		posY = (int)y + 0.5;		
	}

	void gluBox(float x, float y, float z, float width, float length, float height, float color[])
	{

		glColor4f(color[0], color[1], color[2], color[3]);

		glPushMatrix();
		glTranslatef(x, y, z);

		glBegin(GL_QUADS);
		//Top
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2, -length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2, -length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(width/2, length/2, height);
		glNormal3f(0, 0, 1);
		glVertex3f(-width/2, length/2, height);

		//Bottom
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2, -length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2, -length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(width/2, length/2, 0);
		glNormal3f(0, 0, -1);
		glVertex3f(-width/2, length/2, 0);

		//East
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, -length/2, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, length/2, 0);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, length/2, height);
		glNormal3f(1, 0, 0);
		glVertex3f(width/2, -length/2, height);

		//West
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, length/2, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, -length/2, 0);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, -length/2, height);
		glNormal3f(-1, 0, 0);
		glVertex3f(-width/2, length/2, height);

		//North
		glNormal3f(0, 1, 0);
		glVertex3f(-width/2, length/2, 0);
		glNormal3f(0, 1, 0);
		glVertex3f(width/2, length/2, 0);
		glNormal3f(0, 1, 0);
		glVertex3f(width/2, length/2, height);
		glNormal3f(0, 1, 0);
		glVertex3f(-width/2, length/2, height);

		//South
		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, -length/2, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, -length/2, 0);
		glNormal3f(0, -1, 0);
		glVertex3f(width/2, -length/2, height);
		glNormal3f(0, -1, 0);
		glVertex3f(-width/2, -length/2, height);

		glEnd();
		
		glPopMatrix();	
	}

	void Render()
	{
		float width = 0.3;

		if (!available)
		{
			glPushMatrix();
			glTranslatef(posX, posY, 0.1);
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_BLEND);
			glEnable(GL_BLEND);
			glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
			glColor4ub(211, 97, 214, 60);
			gluDisk(gluNewQuadric(), 0, width, 10, 10);
			glDisable(GL_BLEND);
			glPopMatrix();
		}
	}
};

#endif