#ifndef _GLSNOW_H
#define _GLSNOW_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library

#include "glcrystals.h"
#include "randomc.h"

class CFunSnow
{
public: 
	CFunSnow()
	{
	}
	
	void Initialize(TRanrotWGenerator* randgen, GLuint* textures, int i)
	{
		stop = false;
		rg = randgen;
		snowCrystals = new CFunCrystals(rg, textures, i);
	}

	void Render(float season)
	{
		if (season >= 0.45 && season <= 0.8)
		{
			glPushMatrix();
			snowCrystals->Render();
			glPopMatrix();
		}

		if (!stop && season > 0.65)
			Stop();
	}

	void Stop()
	{
		snowCrystals->Stop();
		stop = true;
	}

private:
	CFunCrystals* snowCrystals;
	TRanrotWGenerator* rg;
	bool stop;
};

#endif


