#ifndef _GLPARTICLES_H
#define _GLPARTICLES_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>

#include "randomc.h"

#define PI 3.1415926535897932384626433832795
#define PIdiv180 (PI/180.0)

#define MAX_PARTICLES 500

typedef struct						
{
	bool active;				
	float life;					
	float fade;				
	float posX;				
	float posY;					
	float posZ;				
	float dirX;				
	float dirY;				
	float dirZ;					
} particle;

particle particles[MAX_PARTICLES];	

float particleColor[3] = {1.0, 0.3, 0.0};

// This is our item class
class CFunParticles
{
	public:

		CFunParticles(TRanrotWGenerator* randgen, GLuint* tex, int num)
		{	
			stop = false;
			rg = randgen;
			slowdown = 2.0;
			zoom = -40.0;

			textures = tex;
			textureNum = num;

			for (int i = 0; i < MAX_PARTICLES; i++)			
			{
				particles[i].active = true;								
				particles[i].life = 0.4 ;							
				particles[i].fade = float(rg->IRandom(0, 100)) / 1000.0 + 0.003;	
				particles[i].posX = 0.0;					
				particles[i].posY = 0.0;					
				particles[i].posZ = 0.0;					
				particles[i].dirX = float((rg->IRandom(0, 40)) - 20.0);		
				particles[i].dirY = float((rg->IRandom(0, 40)) - 20.0);	
				particles[i].dirZ = float((rg->IRandom(0, 40)) - 20.0);	
			}
		}

		void Stop()
		{
			stop = true;
		}

		void Render()
		{
			glDisable(GL_DEPTH_TEST);						
			glEnable(GL_BLEND);								
			glBlendFunc(GL_SRC_ALPHA,GL_ONE);					
			glEnable(GL_TEXTURE_2D);						
			glBindTexture(GL_TEXTURE_2D, textures[textureNum]);		

			for (int i = 0; i < MAX_PARTICLES; i++)				
			{
				if (particles[i].active)						
				{
					float x = particles[i].posX;						
					float y = particles[i].posY;					
					float z = particles[i].posZ;				
		
					glColor4f(particleColor[0], particleColor[1], particleColor[2], particles[i].life);

					glBegin(GL_TRIANGLE_STRIP);					
						glTexCoord2d(1,1);
						glVertex3f(x+0.5f,y,z+0.5f); // Top Right
						glTexCoord2d(0,1);
						glVertex3f(x-0.5f,y,z+0.5f); // Top Left
						glTexCoord2d(1,0);
						glVertex3f(x+0.5f,y,z-0.5f); // Bottom Right
						glTexCoord2d(0,0);
						glVertex3f(x-0.5f,y,z-0.5f); // Bottom Left
					glEnd();									

					particles[i].posX += particles[i].dirX / (slowdown * 1000);
					particles[i].posY += particles[i].dirY / (slowdown * 1000);
					particles[i].posZ += particles[i].dirZ / (slowdown * 1000);

					particles[i].life -= particles[i].fade;		

					if (!stop && particles[i].life < 0.0)				
					{
						particles[i].life = 0.4;				
						particles[i].fade = float(rg->IRandom(0, 100)) / 1000.0 + 0.003;
						particles[i].posX = 0.0;					
						particles[i].posY = 0.0;					
						particles[i].posZ = 0.0;					
						particles[i].dirX = float((rg->IRandom(0, 40)) - 20.0);	
						particles[i].dirY = float((rg->IRandom(0, 40)) - 20.0);	
						particles[i].dirZ = float((rg->IRandom(0, 40)) - 20.0);	
					}
				}
			}
			glEnable(GL_DEPTH_TEST);						
			glDisable(GL_BLEND);									
			glDisable(GL_TEXTURE_2D);						
		}

	private:
		bool stop;
		TRanrotWGenerator* rg;
		float slowdown;
		float zoom;
		GLuint* textures;
		int textureNum;
};

#endif
