#ifndef _GLMAZE_H
#define _GLMAZE_H

#include <gl\gl.h>										// Header File For The OpenGL32 Library
#include <gl\glu.h>										// Header File For The GLu32 Library
#include <gl\glut.h>

#include "gldisjointsets.h"
#include "randomc.h"

class CFunMaze
{
	public:
		int mazeSize;
		TRanrotWGenerator* rg;
		bool* wallHorizontal;
		bool* wallVertical;

		CFunMaze(TRanrotWGenerator* randgen)
		{
			mazeSize = 9;
			ds = new CFunDisjointSets(mazeSize * mazeSize);
			wallHorizontal = new bool[mazeSize * mazeSize];
			wallVertical = new bool[mazeSize * mazeSize];
			for (int i = 0; i < mazeSize * mazeSize; i++)
			{
				wallHorizontal[i] = true;
				wallVertical[i] = true;
			}
			wallHeight = 0.8;
			wallWidth = 0.05;

			rg = randgen;
		}

		bool IsInteriorWall(int wall)
		{
			if (wall >= 2 * (mazeSize * mazeSize) - mazeSize)
				return false;
			for (int i = 1; i <= mazeSize; i++)
			{
				if (wall == (i * mazeSize - 1))
					return false;
			}
			return true;
		}

		void KnockDownWall(int wall, boolean orientation)
		{
			if (orientation) //VERTICAL WALL
			{
				ds->Union(wall, wall + 1);
				wallVertical[wall] = false;
			}
			else
			{
				ds->Union(wall, wall + mazeSize);
				wallHorizontal[wall] = false;
			}
		}

		void CreateMaze(GLuint* tex, int num)
		{
			textures = tex;
			mazeTex = num;

			int numCells = mazeSize * mazeSize;
			int wall;
			
			while (ds->numComponents > 1)
			{
				wall = rg->IRandom(0, 2 * numCells - 1);
				
				if (IsInteriorWall(wall))
				{
					if (wall < numCells && wallVertical[wall] && ds->Find(wall) != ds->Find(wall + 1))
						KnockDownWall(wall, true);
					else if (wall >= numCells && wallHorizontal[wall - numCells] && ds->Find(wall - numCells) != ds->Find(wall - numCells + mazeSize))
						KnockDownWall(wall - numCells, false);
				}
			}

			wallVertical[mazeSize * (mazeSize + 1) / 2 - 1] = false;
			wallHorizontal[numCells - (mazeSize + 1) / 2] = false;

			CreateDL();
		}

		void CreateDL()
		{
			mazeWallList = glGenLists(1);
			glNewList(mazeWallList, GL_COMPILE);
			glColor3f(1, 1, 1);
			glEnable(GL_TEXTURE_2D);							
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
			glBindTexture(GL_TEXTURE_2D, textures[mazeTex]);
			
			//Top
			glBegin(GL_QUADS);
			glTexCoord2f(0, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(-wallWidth/2, -(1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0.0625, 0);
			glNormal3f(0, 0, 1);
			glVertex3f(wallWidth/2, -(1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0.0625, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(wallWidth/2, (1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0, 1);
			glNormal3f(0, 0, 1);
			glVertex3f(-wallWidth/2, (1 + wallWidth)/2, wallHeight);
			
			//Bottom
			glTexCoord2f(0, 0);
			glNormal3f(0, 0, -1);
			glVertex3f(-wallWidth/2, -(1 + wallWidth)/2, 0);
			glTexCoord2f(0.0625, 0);
			glNormal3f(0, 0, -1);
			glVertex3f(wallWidth/2, -(1 + wallWidth)/2, 0);
			glTexCoord2f(0.0625, 1);
			glNormal3f(0, 0, -1);
			glVertex3f(wallWidth/2, (1 + wallWidth)/2, 0);
			glTexCoord2f(0, 1);
			glNormal3f(0, 0, -1);
			glVertex3f(-wallWidth/2, (1 + wallWidth)/2, 0);
			
			//East
			glTexCoord2f(0, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2, -(1 + wallWidth)/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2, (1 + wallWidth)/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2, (1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0, 1);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2, -(1 + wallWidth)/2, wallHeight);
			
			//West
			glTexCoord2f(0, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2, (1 + wallWidth)/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2, -(1 + wallWidth)/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2, -(1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0, 1);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2, (1 + wallWidth)/2, wallHeight);
			
			//North
			glTexCoord2f(0, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(-wallWidth/2, (1 + wallWidth)/2, 0);
			glTexCoord2f(0.0625, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(wallWidth/2, (1 + wallWidth)/2, 0);
			glTexCoord2f(0.0625, 1);
			glTexCoord2f(0, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(wallWidth/2, (1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0, 1);
			glTexCoord2f(0, 0);
			glNormal3f(0, 1, 0);
			glVertex3f(-wallWidth/2, (1 + wallWidth)/2, wallHeight);

			//South
			glTexCoord2f(0, 0);
			glNormal3f(0, -1, 0);
			glVertex3f(-wallWidth/2, -(1 + wallWidth)/2, 0);
			glTexCoord2f(0.0625, 0);
			glNormal3f(0, -1, 0);
			glVertex3f(wallWidth/2, -(1 + wallWidth)/2, 0);
			glTexCoord2f(0.0625, 1);
			glNormal3f(0, -1, 0);
			glVertex3f(wallWidth/2, -(1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0, 1);
			glNormal3f(0, -1, 0);
			glVertex3f(-wallWidth/2, -(1 + wallWidth)/2, wallHeight);
			glEnd();
			glDisable(GL_TEXTURE_2D);
			
			//East
			glColor3f(0.3, 0.3, 0.3);
			glBegin(GL_QUADS);
			glTexCoord2f(0, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2 - 0.01, -(1 + wallWidth)/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2 - 0.01, (1 + wallWidth)/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2 - 0.01, (1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0, 1);
			glNormal3f(1, 0, 0);
			glVertex3f(wallWidth/2 - 0.01, -(1 + wallWidth)/2, wallHeight);
			
			//West
			glTexCoord2f(0, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2 + 0.01, (1 + wallWidth)/2, 0);
			glTexCoord2f(1, 0);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2 + 0.01, -(1 + wallWidth)/2, 0);
			glTexCoord2f(1, 1);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2 + 0.01, -(1 + wallWidth)/2, wallHeight);
			glTexCoord2f(0, 1);
			glNormal3f(-1, 0, 0);
			glVertex3f(-wallWidth/2 + 0.01, (1 + wallWidth)/2, wallHeight);
			glEnd();

			glEndList();
		}

		void Render()
		{			
			float numCells = mazeSize * mazeSize;

			for (float i = 0; i < numCells; i++)
			{
				if ((int)i % mazeSize == 0 && (int)i != 36 )
				{
					glPushMatrix();
					glTranslatef(100 + (((int)i % mazeSize)), 100 + ((int)i / mazeSize) + 0.5, 0);
					glCallList(mazeWallList);
					glPopMatrix();
				}
				if (i < 9 && (int)i != 4 )
				{
					glPushMatrix();
					glTranslatef(100 + ((int)i % mazeSize) + 0.5, 100 + ((int)i / mazeSize), 0);
					glRotatef(90, 0, 0, 1);
					glCallList(mazeWallList);
					glPopMatrix();
				}

				if (wallVertical[(int) i])
				{
					glPushMatrix();
					glTranslatef(100 + (((int)i % mazeSize) + 1), 100 + ((int)i / mazeSize) + 0.5, 0);
					glCallList(mazeWallList);
					glPopMatrix();
				}
				if (wallHorizontal[(int) i])
				{
					glPushMatrix();
					glTranslatef(100 + ((int)i % mazeSize) + 0.5, 100 + (((int)i / mazeSize) + 1), 0);
					glRotatef(90, 0, 0, 1);
					glCallList(mazeWallList);
					glPopMatrix();
				}

				glColor3f(1, 1, 1);
				glPushMatrix();
				glTranslatef(100 + ((int)i % mazeSize), 100 + ((int)i / mazeSize), 0);
				glBegin(GL_QUADS);
				glNormal3f(0, 0, 1);
				glVertex3f(0, 0, 0);
				glNormal3f(0, 0, 1);
				glVertex3f(1, 0, 0);
				glNormal3f(0, 0, 1);
				glVertex3f(1, 1, 0);
				glNormal3f(0, 0, 1);
				glVertex3f(0, 1, 0);
				glEnd();
				glPopMatrix();
			
			}
		}

	private:
		float wallHeight;
		float wallWidth;
		CFunDisjointSets* ds;
		GLuint* textures;
		int mazeTex;
		GLuint mazeWallList;
};


#endif
